/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.App;
import com.bugsnag.android.Device;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.SessionFilenameInfo;
import com.bugsnag.android.User;
import com.bugsnag.android.UserAware;
import com.bugsnag.android.internal.DateUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class Session
implements JsonStream.Streamable,
UserAware {
    private final File file;
    private final Notifier notifier;
    private String id;
    private Date startedAt;
    private User user;
    private final Logger logger;
    private App app;
    private Device device;
    private final AtomicBoolean autoCaptured = new AtomicBoolean(false);
    private final AtomicInteger unhandledCount = new AtomicInteger();
    private final AtomicInteger handledCount = new AtomicInteger();
    private final AtomicBoolean tracked = new AtomicBoolean(false);
    final AtomicBoolean isPaused = new AtomicBoolean(false);
    private String apiKey;

    static Session copySession(Session session) {
        Session copy = new Session(session.id, session.startedAt, session.user, session.unhandledCount.get(), session.handledCount.get(), session.notifier, session.logger, session.getApiKey());
        copy.tracked.set(session.tracked.get());
        copy.autoCaptured.set(session.isAutoCaptured());
        return copy;
    }

    Session(Map<String, Object> map, Logger logger, String apiKey) {
        this(null, null, logger, apiKey);
        this.setId((String)map.get("id"));
        String timestamp = (String)map.get("startedAt");
        this.setStartedAt(DateUtils.fromIso8601(timestamp));
        Map events = (Map)map.get("events");
        Number handled = (Number)events.get("handled");
        this.handledCount.set(handled.intValue());
        Number unhandled = (Number)events.get("unhandled");
        this.unhandledCount.set(unhandled.intValue());
    }

    Session(String id, Date startedAt, User user, boolean autoCaptured, Notifier notifier, Logger logger, String apiKey) {
        this(null, notifier, logger, apiKey);
        this.id = id;
        this.startedAt = new Date(startedAt.getTime());
        this.user = user;
        this.autoCaptured.set(autoCaptured);
        this.apiKey = apiKey;
    }

    Session(String id, Date startedAt, User user, int unhandledCount, int handledCount, Notifier notifier, Logger logger, String apiKey) {
        this(id, startedAt, user, false, notifier, logger, apiKey);
        this.unhandledCount.set(unhandledCount);
        this.handledCount.set(handledCount);
        this.tracked.set(true);
        this.apiKey = apiKey;
    }

    Session(File file, Notifier notifier, Logger logger, String apiKey) {
        this.file = file;
        this.logger = logger;
        this.apiKey = SessionFilenameInfo.findApiKeyInFilename(file, apiKey);
        if (notifier != null) {
            Notifier copy = new Notifier(notifier.getName(), notifier.getVersion(), notifier.getUrl());
            copy.setDependencies(new ArrayList<Notifier>(notifier.getDependencies()));
            this.notifier = copy;
        } else {
            this.notifier = null;
        }
    }

    private void logNull(String property) {
        this.logger.e("Invalid null value supplied to session." + property + ", ignoring");
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public void setId(@NonNull String id) {
        if (id != null) {
            this.id = id;
        } else {
            this.logNull("id");
        }
    }

    @NonNull
    public Date getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(@NonNull Date startedAt) {
        if (startedAt != null) {
            this.startedAt = startedAt;
        } else {
            this.logNull("startedAt");
        }
    }

    @Override
    @NonNull
    public User getUser() {
        return this.user;
    }

    @Override
    public void setUser(@Nullable String id, @Nullable String email, @Nullable String name) {
        this.user = new User(id, email, name);
    }

    @NonNull
    public App getApp() {
        return this.app;
    }

    @NonNull
    public Device getDevice() {
        return this.device;
    }

    void setApp(App app) {
        this.app = app;
    }

    void setDevice(Device device) {
        this.device = device;
    }

    int getUnhandledCount() {
        return this.unhandledCount.intValue();
    }

    int getHandledCount() {
        return this.handledCount.intValue();
    }

    Session incrementHandledAndCopy() {
        this.handledCount.incrementAndGet();
        return Session.copySession(this);
    }

    Session incrementUnhandledAndCopy() {
        this.unhandledCount.incrementAndGet();
        return Session.copySession(this);
    }

    AtomicBoolean isTracked() {
        return this.tracked;
    }

    boolean isAutoCaptured() {
        return this.autoCaptured.get();
    }

    void setAutoCaptured(boolean autoCaptured) {
        this.autoCaptured.set(autoCaptured);
    }

    boolean isLegacyPayload() {
        return this.file == null || !this.file.getName().endsWith("_v2.json") && !this.file.getName().endsWith("_v3.json");
    }

    Notifier getNotifier() {
        return this.notifier;
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        if (this.file != null) {
            if (!this.isLegacyPayload()) {
                this.serializePayload(writer);
            } else {
                this.serializeLegacyPayload(writer);
            }
        } else {
            writer.beginObject();
            writer.name("notifier").value(this.notifier);
            writer.name("app").value(this.app);
            writer.name("device").value(this.device);
            writer.name("sessions").beginArray();
            this.serializeSessionInfo(writer);
            writer.endArray();
            writer.endObject();
        }
    }

    private void serializePayload(@NonNull JsonStream writer) throws IOException {
        writer.value(this.file);
    }

    private void serializeLegacyPayload(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("notifier").value(this.notifier);
        writer.name("app").value(this.app);
        writer.name("device").value(this.device);
        writer.name("sessions").beginArray();
        writer.value(this.file);
        writer.endArray();
        writer.endObject();
    }

    void serializeSessionInfo(@NonNull JsonStream writer) throws IOException {
        writer.beginObject();
        writer.name("id").value(this.id);
        writer.name("startedAt").value(this.startedAt);
        writer.name("user").value(this.user);
        writer.endObject();
    }

    public void setApiKey(@NonNull String apiKey) {
        if (apiKey != null) {
            this.apiKey = apiKey;
        } else {
            this.logNull("apiKey");
        }
    }

    @NonNull
    public String getApiKey() {
        return this.apiKey;
    }
}

