/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractHttpEntity {
    protected final Map<String, String> headers = new LinkedHashMap<String, String>();
    @Nullable
    private String body;
    private long bodyLength = -1L;

    AbstractHttpEntity() {
    }

    public void addHeader(@NonNull String name, @NonNull String value) {
        if (name == null || value == null) {
            return;
        }
        this.headers.put(name, value);
    }

    public void removeHeader(@NonNull String name) {
        this.headers.remove(name);
    }

    @NonNull
    public Set<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    @NonNull
    public String getHeader(@NonNull String headerName) {
        if (headerName == null) {
            return "";
        }
        String headerValue = this.headers.get(headerName);
        return headerValue != null ? headerValue : "";
    }

    @Nullable
    public String getBody() {
        return this.body;
    }

    public void setBody(@Nullable String body) {
        this.body = body;
    }

    public long getBodyLength() {
        return this.bodyLength;
    }

    public void setBodyLength(@IntRange(from=0L) long bodyLength) {
        if (bodyLength >= 0L) {
            this.bodyLength = bodyLength;
        }
    }
}

