/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.repackaged.dslplatform.json;

import androidx.annotation.Nullable;
import com.bugsnag.android.repackaged.dslplatform.json.ConfigurationException;
import com.bugsnag.android.repackaged.dslplatform.json.JsonReader;
import com.bugsnag.android.repackaged.dslplatform.json.JsonWriter;
import com.bugsnag.android.repackaged.dslplatform.json.ObjectConverter;
import com.bugsnag.android.repackaged.dslplatform.json.ParsingException;
import com.bugsnag.android.repackaged.dslplatform.json.StringConverter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlConverter {
    static final JsonReader.ReadObject<Element> Reader = new JsonReader.ReadObject<Element>(){

        @Override
        @Nullable
        public Element read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : XmlConverter.deserialize(reader);
        }
    };
    static final JsonWriter.WriteObject<Element> Writer = new JsonWriter.WriteObject<Element>(){

        @Override
        public void write(JsonWriter writer, @Nullable Element value) {
            XmlConverter.serializeNullable(value, writer);
        }
    };
    private static final DocumentBuilder documentBuilder;
    private static final String TEXT_NODE_TAG = "#text";
    private static final String COMMENT_NODE_TAG = "#comment";
    private static final String CDATA_NODE_TAG = "#cdata-section";

    public static void serializeNullable(@Nullable Element value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            XmlConverter.serialize(value, sw);
        }
    }

    public static void serialize(Element value, JsonWriter sw) {
        Document document = value.getOwnerDocument();
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer serializer = domImplLS.createLSSerializer();
        LSOutput lsOutput = domImplLS.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        StringWriter writer = new StringWriter();
        lsOutput.setCharacterStream(writer);
        serializer.write(document, lsOutput);
        StringConverter.serialize(writer.toString(), sw);
    }

    public static Element deserialize(JsonReader reader) throws IOException {
        if (reader.last() == 34) {
            try {
                InputSource source = new InputSource(new StringReader(reader.readString()));
                return documentBuilder.parse(source).getDocumentElement();
            }
            catch (SAXException ex) {
                throw reader.newParseErrorAt("Invalid XML value", 0, ex);
            }
        }
        LinkedHashMap<String, Object> map = ObjectConverter.deserializeMap(reader);
        return XmlConverter.mapToXml(map);
    }

    public static Element mapToXml(Map<String, Object> map) throws IOException {
        Set<String> xmlRootElementNames = map.keySet();
        if (xmlRootElementNames.size() > 1) {
            throw ParsingException.create("Invalid XML. Expecting root element", true);
        }
        String rootName = xmlRootElementNames.iterator().next();
        Document document = XmlConverter.createDocument();
        Element rootElement = document.createElement(rootName);
        document.appendChild(rootElement);
        XmlConverter.buildXmlFromHashMap(document, rootElement, map.get(rootName));
        return rootElement;
    }

    private static synchronized Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException(e);
        }
    }

    private static void buildXmlFromHashMap(Document doc, Element subtreeRootElement, @Nullable Object elementContent) {
        if (elementContent instanceof HashMap) {
            HashMap elementContentMap = (HashMap)elementContent;
            for (Map.Entry childEntry : elementContentMap.entrySet()) {
                String key = (String)childEntry.getKey();
                if (key.startsWith("@")) {
                    subtreeRootElement.setAttribute(key.substring(1), childEntry.getValue().toString());
                    continue;
                }
                if (key.startsWith("#")) {
                    if (key.equals(TEXT_NODE_TAG)) {
                        if (childEntry.getValue() instanceof List) {
                            XmlConverter.buildTextNodeList(doc, subtreeRootElement, (List)childEntry.getValue());
                            continue;
                        }
                        Text textNode = doc.createTextNode(childEntry.getValue().toString());
                        subtreeRootElement.appendChild(textNode);
                        continue;
                    }
                    if (key.equals(CDATA_NODE_TAG)) {
                        if (childEntry.getValue() instanceof List) {
                            XmlConverter.buildCDataList(doc, subtreeRootElement, (List)childEntry.getValue());
                            continue;
                        }
                        CDATASection cDataNode = doc.createCDATASection(childEntry.getValue().toString());
                        subtreeRootElement.appendChild(cDataNode);
                        continue;
                    }
                    if (!key.equals(COMMENT_NODE_TAG)) continue;
                    if (childEntry.getValue() instanceof List) {
                        XmlConverter.buildCommentList(doc, subtreeRootElement, (List)childEntry.getValue());
                        continue;
                    }
                    Comment commentNode = doc.createComment(childEntry.getValue().toString());
                    subtreeRootElement.appendChild(commentNode);
                    continue;
                }
                Element newElement = doc.createElement(key);
                subtreeRootElement.appendChild(newElement);
                XmlConverter.buildXmlFromHashMap(doc, newElement, childEntry.getValue());
            }
        } else if (elementContent instanceof List) {
            XmlConverter.buildXmlFromJsonArray(doc, subtreeRootElement, (List)elementContent);
        } else if (elementContent != null) {
            subtreeRootElement.setTextContent(elementContent.toString());
        }
    }

    private static void buildTextNodeList(Document doc, Node subtreeRoot, List<String> nodeValues) {
        StringBuilder sb = new StringBuilder();
        for (String nodeValue : nodeValues) {
            sb.append(nodeValue);
        }
        subtreeRoot.appendChild(doc.createTextNode(sb.toString()));
    }

    private static void buildCDataList(Document doc, Node subtreeRoot, List<String> nodeValues) {
        for (String nodeValue : nodeValues) {
            subtreeRoot.appendChild(doc.createCDATASection(nodeValue));
        }
    }

    private static void buildCommentList(Document doc, Node subtreeRoot, List<String> nodeValues) {
        for (String nodeValue : nodeValues) {
            subtreeRoot.appendChild(doc.createComment(nodeValue));
        }
    }

    private static void buildXmlFromJsonArray(Document doc, Node listHeadNode, List<Object> elementContentList) {
        Node subtreeRootNode = listHeadNode.getParentNode();
        XmlConverter.buildXmlFromHashMap(doc, (Element)listHeadNode, elementContentList.get(0));
        for (Object elementContent : elementContentList.subList(1, elementContentList.size())) {
            Element newElement = doc.createElement(listHeadNode.getNodeName());
            subtreeRootNode.appendChild(newElement);
            XmlConverter.buildXmlFromHashMap(doc, newElement, elementContent);
        }
    }

    public static ArrayList<Element> deserializeCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollectionCustom(Reader);
    }

    public static void deserializeCollection(JsonReader reader, Collection<Element> res) throws IOException {
        reader.deserializeCollection(Reader, res);
    }

    public static ArrayList<Element> deserializeNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollectionCustom(Reader);
    }

    public static void deserializeNullableCollection(JsonReader reader, Collection<Element> res) throws IOException {
        reader.deserializeNullableCollection(Reader, res);
    }

    static {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

