/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.ErrorInternal;
import com.bugsnag.android.ErrorType;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Stackframe;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class Error
implements JsonStream.Streamable {
    private final ErrorInternal impl;
    private final Logger logger;

    Error(@NonNull ErrorInternal impl, @NonNull Logger logger) {
        this.impl = impl;
        this.logger = logger;
    }

    private void logNull(String property) {
        this.logger.e("Invalid null value supplied to error." + property + ", ignoring");
    }

    public void setErrorClass(@NonNull String errorClass) {
        if (errorClass != null) {
            this.impl.setErrorClass(errorClass);
        } else {
            this.logNull("errorClass");
        }
    }

    @NonNull
    public String getErrorClass() {
        return this.impl.getErrorClass();
    }

    public void setErrorMessage(@Nullable String errorMessage) {
        this.impl.setErrorMessage(errorMessage);
    }

    @Nullable
    public String getErrorMessage() {
        return this.impl.getErrorMessage();
    }

    public void setType(@NonNull ErrorType type) {
        if (type != null) {
            this.impl.setType(type);
        } else {
            this.logNull("type");
        }
    }

    @NonNull
    public ErrorType getType() {
        return this.impl.getType();
    }

    @NonNull
    public List<Stackframe> getStacktrace() {
        return this.impl.getStacktrace();
    }

    @NonNull
    public Stackframe addStackframe(@Nullable String method, @Nullable String file, long lineNumber) {
        return this.impl.addStackframe(method, file, lineNumber);
    }

    @Override
    public void toStream(@NonNull JsonStream stream) throws IOException {
        this.impl.toStream(stream);
    }

    static List<Error> createError(@NonNull Throwable exc, @NonNull Collection<String> projectPackages, @NonNull Logger logger) {
        return ErrorInternal.Companion.createError(exc, projectPackages, logger);
    }
}

