/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.location.LocationManager;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;
import android.util.DisplayMetrics;
import com.bugsnag.android.Connectivity;
import com.bugsnag.android.ContextExtensionsKt;
import com.bugsnag.android.Device;
import com.bugsnag.android.DeviceBuildInfo;
import com.bugsnag.android.DeviceIdStore;
import com.bugsnag.android.DeviceWithState;
import com.bugsnag.android.Logger;
import com.bugsnag.android.internal.BackgroundTaskService;
import com.bugsnag.android.internal.TaskType;
import com.bugsnag.android.internal.dag.Provider;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0012\b\u0000\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\t\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u00020\u0018J\b\u00101\u001a\u00020,H\u0007J\r\u00102\u001a\u0004\u0018\u00010,\u00a2\u0006\u0002\u00103J\u000f\u00104\u001a\u0004\u0018\u00010,H\u0002\u00a2\u0006\u0002\u00103J\b\u00105\u001a\u00020\u0010H\u0002J\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020,J\u000e\u0010;\u001a\u0002092\u0006\u0010<\u001a\u00020,J\u000e\u0010=\u001a\u0002092\u0006\u0010:\u001a\u00020,J\u0011\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0002\u0010?J\u0014\u0010@\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00010AJ\n\u0010B\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010C\u001a\u00020\u0018H\u0002J\u000f\u0010D\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\bEJ\u000f\u0010F\u001a\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0002\u0010GJ\u000f\u0010H\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010IJ\n\u0010J\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010K\u001a\u00020\u0010H\u0002J\b\u0010L\u001a\u00020\u0010H\u0002J\u001e\u0010M\u001a\u00020.2\u0014\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00010%H\u0002J\u0012\u0010O\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010,\u0018\u00010+H\u0002J\u0015\u0010P\u001a\u00020\u00102\u0006\u0010Q\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\bRR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010 \u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u0004\u0018\u00010'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010,\u0018\u00010+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/bugsnag/android/DeviceDataCollector;", "", "connectivity", "Lcom/bugsnag/android/Connectivity;", "appContext", "Landroid/content/Context;", "resources", "Landroid/content/res/Resources;", "deviceIdStore", "Lcom/bugsnag/android/internal/dag/Provider;", "Lcom/bugsnag/android/DeviceIdStore$DeviceIds;", "buildInfo", "Lcom/bugsnag/android/DeviceBuildInfo;", "dataDirectory", "Ljava/io/File;", "rootedFuture", "", "bgTaskService", "Lcom/bugsnag/android/internal/BackgroundTaskService;", "logger", "Lcom/bugsnag/android/Logger;", "(Lcom/bugsnag/android/Connectivity;Landroid/content/Context;Landroid/content/res/Resources;Lcom/bugsnag/android/internal/dag/Provider;Lcom/bugsnag/android/DeviceBuildInfo;Ljava/io/File;Lcom/bugsnag/android/internal/dag/Provider;Lcom/bugsnag/android/internal/BackgroundTaskService;Lcom/bugsnag/android/Logger;)V", "cpuAbi", "", "", "[Ljava/lang/String;", "displayMetrics", "Landroid/util/DisplayMetrics;", "kotlin.jvm.PlatformType", "dpi", "", "Ljava/lang/Integer;", "emulator", "locale", "orientation", "Ljava/util/concurrent/atomic/AtomicInteger;", "runtimeVersions", "", "screenDensity", "", "Ljava/lang/Float;", "screenResolution", "totalMemoryFuture", "Ljava/util/concurrent/Future;", "", "addRuntimeVersionInfo", "", "key", "value", "calculateFreeDisk", "calculateFreeMemory", "()Ljava/lang/Long;", "calculateTotalMemory", "checkIsRooted", "generateDevice", "Lcom/bugsnag/android/Device;", "generateDeviceWithState", "Lcom/bugsnag/android/DeviceWithState;", "now", "generateHistoricDeviceWithState", "timeStamp", "generateInternalDeviceWithState", "getCpuAbi", "()[Ljava/lang/String;", "getDeviceMetadata", "", "getLocationStatus", "getNetworkAccess", "getOrientationAsString", "getOrientationAsString$bugsnag_android_core_release", "getScreenDensity", "()Ljava/lang/Float;", "getScreenDensityDpi", "()Ljava/lang/Integer;", "getScreenResolution", "isEmulator", "isLocationEnabled", "populateBatteryInfo", "into", "retrieveTotalDeviceMemory", "updateOrientation", "newOrientation", "updateOrientation$bugsnag_android_core_release", "bugsnag-android-core_release"})
public final class DeviceDataCollector {
    @NotNull
    private final Connectivity connectivity;
    @NotNull
    private final Context appContext;
    @NotNull
    private final Provider<DeviceIdStore.DeviceIds> deviceIdStore;
    @NotNull
    private final DeviceBuildInfo buildInfo;
    @NotNull
    private final File dataDirectory;
    @Nullable
    private final Provider<Boolean> rootedFuture;
    @NotNull
    private final BackgroundTaskService bgTaskService;
    @NotNull
    private final Logger logger;
    private final DisplayMetrics displayMetrics;
    private final boolean emulator;
    @Nullable
    private final Float screenDensity;
    @Nullable
    private final Integer dpi;
    @Nullable
    private final String screenResolution;
    @NotNull
    private final String locale;
    @NotNull
    private final String[] cpuAbi;
    @NotNull
    private Map<String, Object> runtimeVersions;
    @Nullable
    private final Future<Long> totalMemoryFuture;
    @NotNull
    private AtomicInteger orientation;

    public DeviceDataCollector(@NotNull Connectivity connectivity, @NotNull Context appContext, @NotNull Resources resources, @NotNull Provider<DeviceIdStore.DeviceIds> deviceIdStore, @NotNull DeviceBuildInfo buildInfo, @NotNull File dataDirectory, @Nullable Provider<Boolean> rootedFuture, @NotNull BackgroundTaskService bgTaskService, @NotNull Logger logger) {
        String string;
        Map map2;
        this.connectivity = connectivity;
        this.appContext = appContext;
        this.deviceIdStore = deviceIdStore;
        this.buildInfo = buildInfo;
        this.dataDirectory = dataDirectory;
        this.rootedFuture = rootedFuture;
        this.bgTaskService = bgTaskService;
        this.logger = logger;
        this.displayMetrics = resources.getDisplayMetrics();
        this.emulator = this.isEmulator();
        this.screenDensity = this.getScreenDensity();
        this.dpi = this.getScreenDensityDpi();
        this.screenResolution = this.getScreenResolution();
        this.locale = Locale.getDefault().toString();
        this.cpuAbi = this.getCpuAbi();
        this.totalMemoryFuture = this.retrieveTotalDeviceMemory();
        this.orientation = new AtomicInteger(resources.getConfiguration().orientation);
        Map map3 = new LinkedHashMap();
        Integer n = this.buildInfo.getApiLevel();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            map2 = map3;
            string = "androidApiLevel";
            Integer n2 = it;
            map2.put(string, n2);
        }
        String string2 = this.buildInfo.getOsBuild();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            map2 = map3;
            string = "osBuild";
            map2.put(string, it);
        }
        this.runtimeVersions = map3;
    }

    @NotNull
    public final Device generateDevice() {
        Object object;
        Object object2;
        DeviceIdStore.DeviceIds deviceIds = this.deviceIdStore.get();
        Object object3 = this.totalMemoryFuture;
        String string = this.locale;
        String string2 = deviceIds == null ? null : deviceIds.getDeviceId();
        Boolean bl = this.checkIsRooted();
        String[] stringArray = this.cpuAbi;
        DeviceBuildInfo deviceBuildInfo = this.buildInfo;
        try {
            Future<Long> $this$generateDevice_u24lambda_u2d2 = object3;
            boolean bl2 = false;
            Future<Long> future = $this$generateDevice_u24lambda_u2d2;
            object2 = Result.constructor-impl((Object)(future == null ? null : future.get()));
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object3 = object = object2;
        Map map2 = MapsKt.toMutableMap(this.runtimeVersions);
        Long l = (Long)(Result.isFailure-impl((Object)object3) ? null : object3);
        String string3 = string;
        String string4 = string2;
        Boolean bl3 = bl;
        String[] stringArray2 = stringArray;
        DeviceBuildInfo deviceBuildInfo2 = deviceBuildInfo;
        return new Device(deviceBuildInfo2, stringArray2, bl3, string4, string3, l, map2);
    }

    @NotNull
    public final DeviceWithState generateDeviceWithState(long now) {
        Object object;
        Object object2;
        DeviceIdStore.DeviceIds deviceIds = this.deviceIdStore.get();
        Object object3 = this.totalMemoryFuture;
        String string = this.locale;
        String string2 = deviceIds == null ? null : deviceIds.getDeviceId();
        Boolean bl = this.checkIsRooted();
        DeviceBuildInfo deviceBuildInfo = this.buildInfo;
        try {
            Future<Long> $this$generateDeviceWithState_u24lambda_u2d3 = object3;
            boolean bl2 = false;
            Future<Long> future = $this$generateDeviceWithState_u24lambda_u2d3;
            object2 = Result.constructor-impl((Object)(future == null ? null : future.get()));
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object3 = object = object2;
        Date date = new Date(now);
        String string3 = this.getOrientationAsString$bugsnag_android_core_release();
        Long l = this.calculateFreeMemory();
        Long l2 = this.calculateFreeDisk();
        Map map2 = MapsKt.toMutableMap(this.runtimeVersions);
        Long l3 = (Long)(Result.isFailure-impl((Object)object3) ? null : object3);
        String string4 = string;
        String string5 = string2;
        Boolean bl3 = bl;
        DeviceBuildInfo deviceBuildInfo2 = deviceBuildInfo;
        return new DeviceWithState(deviceBuildInfo2, bl3, string5, string4, l3, map2, l2, l, string3, date);
    }

    @NotNull
    public final DeviceWithState generateInternalDeviceWithState(long now) {
        Object object;
        Object object2;
        DeviceIdStore.DeviceIds deviceIds = this.deviceIdStore.get();
        Object object3 = this.totalMemoryFuture;
        String string = this.locale;
        String string2 = deviceIds == null ? null : deviceIds.getInternalDeviceId();
        Boolean bl = this.checkIsRooted();
        DeviceBuildInfo deviceBuildInfo = this.buildInfo;
        try {
            Future<Long> $this$generateInternalDeviceWithState_u24lambda_u2d4 = object3;
            boolean bl2 = false;
            Future<Long> future = $this$generateInternalDeviceWithState_u24lambda_u2d4;
            object2 = Result.constructor-impl((Object)(future == null ? null : future.get()));
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object3 = object = object2;
        Date date = new Date(now);
        String string3 = this.getOrientationAsString$bugsnag_android_core_release();
        Long l = this.calculateFreeMemory();
        Long l2 = this.calculateFreeDisk();
        Map map2 = MapsKt.toMutableMap(this.runtimeVersions);
        Long l3 = (Long)(Result.isFailure-impl((Object)object3) ? null : object3);
        String string4 = string;
        String string5 = string2;
        Boolean bl3 = bl;
        DeviceBuildInfo deviceBuildInfo2 = deviceBuildInfo;
        return new DeviceWithState(deviceBuildInfo2, bl3, string5, string4, l3, map2, l2, l, string3, date);
    }

    @NotNull
    public final DeviceWithState generateHistoricDeviceWithState(long timeStamp) {
        DeviceIdStore.DeviceIds deviceIds = this.deviceIdStore.get();
        return new DeviceWithState(this.buildInfo, this.checkIsRooted(), (String)(deviceIds == null ? null : deviceIds.getInternalDeviceId()), this.locale, null, MapsKt.toMutableMap(this.runtimeVersions), null, null, this.getOrientationAsString$bugsnag_android_core_release(), new Date(timeStamp));
    }

    @NotNull
    public final Map<String, Object> getDeviceMetadata() {
        HashMap map2 = new HashMap();
        this.populateBatteryInfo(map2);
        ((Map)map2).put("locationStatus", this.getLocationStatus());
        ((Map)map2).put("networkAccess", this.getNetworkAccess());
        ((Map)map2).put("brand", this.buildInfo.getBrand());
        ((Map)map2).put("screenDensity", this.screenDensity);
        ((Map)map2).put("dpi", this.dpi);
        ((Map)map2).put("emulator", this.emulator);
        ((Map)map2).put("screenResolution", this.screenResolution);
        return map2;
    }

    private final boolean checkIsRooted() {
        boolean bl;
        try {
            bl = this.rootedFuture != null && this.rootedFuture.get() != false;
        }
        catch (Exception exc) {
            bl = false;
        }
        return bl;
    }

    private final boolean isEmulator() {
        String fingerprint = this.buildInfo.getFingerprint();
        return fingerprint != null && (StringsKt.startsWith$default((String)fingerprint, (String)"unknown", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fingerprint, (CharSequence)"generic", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fingerprint, (CharSequence)"vbox", (boolean)false, (int)2, null));
    }

    private final Integer getScreenDensityDpi() {
        DisplayMetrics displayMetrics = this.displayMetrics;
        return displayMetrics == null ? null : Integer.valueOf(displayMetrics.densityDpi);
    }

    private final void populateBatteryInfo(Map<String, Object> into) {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = ContextExtensionsKt.registerReceiverSafe(this.appContext, null, ifilter, this.logger);
            if (batteryStatus != null) {
                int status;
                Object object;
                Object object2;
                int level = batteryStatus.getIntExtra("level", -1);
                int scale = batteryStatus.getIntExtra("scale", -1);
                if (level != -1 || scale != -1) {
                    float batteryLevel = (float)level / (float)scale;
                    Map<String, Object> map2 = into;
                    object2 = "batteryLevel";
                    object = Float.valueOf(batteryLevel);
                    map2.put((String)object2, object);
                }
                boolean charging = (status = batteryStatus.getIntExtra("status", -1)) == 2 || status == 5;
                object2 = into;
                object = "charging";
                Boolean bl = charging;
                object2.put(object, bl);
            }
        }
        catch (Exception exception) {
            this.logger.w("Could not get battery status");
        }
    }

    private final String getLocationStatus() {
        try {
            return this.isLocationEnabled() ? "allowed" : "disallowed";
        }
        catch (Exception exception) {
            this.logger.w("Could not get locationStatus");
            return null;
        }
    }

    private final boolean isLocationEnabled() {
        boolean bl;
        if (Build.VERSION.SDK_INT >= 31) {
            LocationManager locationManager = ContextExtensionsKt.getLocationManager(this.appContext);
            bl = locationManager == null ? false : locationManager.isLocationEnabled();
        } else {
            ContentResolver cr = this.appContext.getContentResolver();
            String providersAllowed = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            bl = providersAllowed != null && ((CharSequence)providersAllowed).length() > 0;
        }
        return bl;
    }

    private final String getNetworkAccess() {
        return this.connectivity.retrieveNetworkAccessState();
    }

    private final Float getScreenDensity() {
        DisplayMetrics displayMetrics = this.displayMetrics;
        return displayMetrics == null ? null : Float.valueOf(displayMetrics.density);
    }

    private final String getScreenResolution() {
        String string;
        if (this.displayMetrics != null) {
            int max = Math.max(this.displayMetrics.widthPixels, this.displayMetrics.heightPixels);
            int min = Math.min(this.displayMetrics.widthPixels, this.displayMetrics.heightPixels);
            string = "" + max + 'x' + min;
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String[] getCpuAbi() {
        String[] stringArray;
        String[] stringArray2 = this.buildInfo.getCpuAbis();
        if (stringArray2 == null) {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        } else {
            stringArray = stringArray2;
        }
        return stringArray;
    }

    @SuppressLint(value={"UsableSpace"})
    public final long calculateFreeDisk() {
        Object object;
        Object object2 = this;
        try {
            DeviceDataCollector $this$calculateFreeDisk_u24lambda_u2d6 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$calculateFreeDisk_u24lambda_u2d6.bgTaskService.submitTask(TaskType.IO, () -> DeviceDataCollector.calculateFreeDisk$lambda-6$lambda-5($this$calculateFreeDisk_u24lambda_u2d6)).get());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = 0L;
        return ((Number)(Result.isFailure-impl((Object)object2) ? object : object2)).longValue();
    }

    @Nullable
    public final Long calculateFreeMemory() {
        Long l;
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                Long freeMemory;
                Long l2;
                ActivityManager activityManager = ContextExtensionsKt.getActivityManagerFrom(this.appContext);
                if (activityManager == null) {
                    l2 = null;
                } else {
                    ActivityManager.MemoryInfo memoryInfo;
                    ActivityManager am = activityManager;
                    boolean bl = false;
                    ActivityManager.MemoryInfo it = memoryInfo = new ActivityManager.MemoryInfo();
                    boolean bl2 = false;
                    am.getMemoryInfo(it);
                    ActivityManager.MemoryInfo memoryInfo2 = memoryInfo;
                    l2 = freeMemory = Long.valueOf(memoryInfo2.availMem);
                }
                if (freeMemory != null) {
                    return freeMemory;
                }
            }
            catch (Throwable e) {
                return null;
            }
        }
        try {
            l = (Long)Process.class.getDeclaredMethod("getFreeMemory", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable e) {
            l = null;
        }
        return l;
    }

    private final Future<Long> retrieveTotalDeviceMemory() {
        Future future;
        try {
            future = this.bgTaskService.submitTask(TaskType.DEFAULT, () -> DeviceDataCollector.retrieveTotalDeviceMemory$lambda-9(this));
        }
        catch (RejectedExecutionException exc) {
            this.logger.w("Failed to lookup available device memory", exc);
            future = null;
        }
        return future;
    }

    private final Long calculateTotalMemory() {
        Object object;
        if (Build.VERSION.SDK_INT >= 16) {
            Long totalMemory;
            Long l;
            object = ContextExtensionsKt.getActivityManagerFrom(this.appContext);
            if (object == null) {
                l = null;
            } else {
                ActivityManager.MemoryInfo memoryInfo;
                ActivityManager am = object;
                boolean bl = false;
                ActivityManager.MemoryInfo it = memoryInfo = new ActivityManager.MemoryInfo();
                boolean bl2 = false;
                am.getMemoryInfo(it);
                ActivityManager.MemoryInfo memoryInfo2 = memoryInfo;
                l = totalMemory = Long.valueOf(memoryInfo2.totalMem);
            }
            if (totalMemory != null) {
                return totalMemory;
            }
        }
        DeviceDataCollector deviceDataCollector = this;
        try {
            DeviceDataCollector $this$calculateTotalMemory_u24lambda_u2d12 = deviceDataCollector;
            boolean bl = false;
            object = Result.constructor-impl((Object)((Long)Process.class.getDeclaredMethod("getTotalMemory", new Class[0]).invoke(null, new Object[0])));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        deviceDataCollector = object;
        return (Long)((Object)(Result.isFailure-impl((Object)deviceDataCollector) ? null : deviceDataCollector));
    }

    @Nullable
    public final String getOrientationAsString$bugsnag_android_core_release() {
        String string;
        switch (this.orientation.get()) {
            case 2: {
                string = "landscape";
                break;
            }
            case 1: {
                string = "portrait";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public final boolean updateOrientation$bugsnag_android_core_release(int newOrientation) {
        return this.orientation.getAndSet(newOrientation) != newOrientation;
    }

    public final void addRuntimeVersionInfo(@NotNull String key, @NotNull String value) {
        Map newRuntimeVersions = MapsKt.toMutableMap(this.runtimeVersions);
        newRuntimeVersions.put(key, value);
        this.runtimeVersions = newRuntimeVersions;
    }

    private static final Long calculateFreeDisk$lambda-6$lambda-5(DeviceDataCollector $this_runCatching) {
        return $this_runCatching.dataDirectory.getUsableSpace();
    }

    private static final Long retrieveTotalDeviceMemory$lambda-9(DeviceDataCollector this$0) {
        return this$0.calculateTotalMemory();
    }
}

