/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Environment;
import android.os.storage.StorageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.ActivityBreadcrumbCollector;
import com.bugsnag.android.AppDataCollector;
import com.bugsnag.android.BackgroundTaskService;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.BreadcrumbState;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.CallbackAware;
import com.bugsnag.android.CallbackState;
import com.bugsnag.android.ClientComponentCallbacks;
import com.bugsnag.android.ClientObservable;
import com.bugsnag.android.ConfigChangeReceiver;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Connectivity;
import com.bugsnag.android.ConnectivityCompat;
import com.bugsnag.android.ContextExtensionsKt;
import com.bugsnag.android.ContextState;
import com.bugsnag.android.DeliveryDelegate;
import com.bugsnag.android.DeviceBuildInfo;
import com.bugsnag.android.DeviceDataCollector;
import com.bugsnag.android.DeviceIdStore;
import com.bugsnag.android.Event;
import com.bugsnag.android.EventStore;
import com.bugsnag.android.ExceptionHandler;
import com.bugsnag.android.FileStore;
import com.bugsnag.android.ImmutableConfig;
import com.bugsnag.android.ImmutableConfigKt;
import com.bugsnag.android.InternalReportDelegate;
import com.bugsnag.android.Intrinsics;
import com.bugsnag.android.LastRunInfo;
import com.bugsnag.android.LastRunInfoStore;
import com.bugsnag.android.LaunchCrashTracker;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Metadata;
import com.bugsnag.android.MetadataAware;
import com.bugsnag.android.MetadataState;
import com.bugsnag.android.NativeInterface;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.OnBreadcrumbCallback;
import com.bugsnag.android.OnErrorCallback;
import com.bugsnag.android.OnSessionCallback;
import com.bugsnag.android.Plugin;
import com.bugsnag.android.PluginClient;
import com.bugsnag.android.RootDetector;
import com.bugsnag.android.Session;
import com.bugsnag.android.SessionLifecycleCallback;
import com.bugsnag.android.SessionStore;
import com.bugsnag.android.SessionTracker;
import com.bugsnag.android.Severity;
import com.bugsnag.android.SeverityReason;
import com.bugsnag.android.SharedPrefMigrator;
import com.bugsnag.android.SystemBroadcastReceiver;
import com.bugsnag.android.TaskType;
import com.bugsnag.android.User;
import com.bugsnag.android.UserAware;
import com.bugsnag.android.UserState;
import com.bugsnag.android.UserStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;

public class Client
implements MetadataAware,
CallbackAware,
UserAware {
    final ImmutableConfig immutableConfig;
    final MetadataState metadataState;
    private final ContextState contextState;
    private final CallbackState callbackState;
    private final UserState userState;
    final Context appContext;
    @NonNull
    final DeviceDataCollector deviceDataCollector;
    @NonNull
    final AppDataCollector appDataCollector;
    @NonNull
    final BreadcrumbState breadcrumbState;
    @NonNull
    protected final EventStore eventStore;
    private final SessionStore sessionStore;
    final SessionTracker sessionTracker;
    private final SystemBroadcastReceiver systemBroadcastReceiver;
    private final ActivityBreadcrumbCollector activityBreadcrumbCollector;
    private final SessionLifecycleCallback sessionLifecycleCallback;
    private final Connectivity connectivity;
    @Nullable
    private final StorageManager storageManager;
    final Logger logger;
    final DeliveryDelegate deliveryDelegate;
    final ClientObservable clientObservable;
    private PluginClient pluginClient;
    final Notifier notifier = new Notifier();
    @Nullable
    final LastRunInfo lastRunInfo;
    final LastRunInfoStore lastRunInfoStore;
    final LaunchCrashTracker launchCrashTracker;
    final BackgroundTaskService bgTaskService = new BackgroundTaskService();
    private final ExceptionHandler exceptionHandler;

    public Client(@NonNull Context androidContext) {
        this(androidContext, Configuration.load(androidContext));
    }

    public Client(@NonNull Context androidContext, @NonNull String apiKey) {
        this(androidContext, Configuration.load(androidContext, apiKey));
    }

    public Client(@NonNull Context androidContext, @NonNull Configuration configuration) {
        Context ctx = androidContext.getApplicationContext();
        this.appContext = ctx != null ? ctx : androidContext;
        this.connectivity = new ConnectivityCompat(this.appContext, (Function2<? super Boolean, ? super String, Unit>)new Function2<Boolean, String, Unit>(){

            public Unit invoke(Boolean hasConnection, String networkState) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("hasConnection", hasConnection);
                data.put("networkState", networkState);
                Client.this.leaveAutoBreadcrumb("Connectivity changed", BreadcrumbType.STATE, data);
                if (hasConnection.booleanValue()) {
                    Client.this.eventStore.flushAsync();
                    Client.this.sessionTracker.flushAsync();
                }
                return null;
            }
        });
        this.immutableConfig = ImmutableConfigKt.sanitiseConfiguration(this.appContext, configuration, this.connectivity);
        this.logger = this.immutableConfig.getLogger();
        this.warnIfNotAppContext(androidContext);
        this.clientObservable = new ClientObservable();
        this.callbackState = configuration.impl.callbackState.copy();
        int maxBreadcrumbs = this.immutableConfig.getMaxBreadcrumbs();
        this.breadcrumbState = new BreadcrumbState(maxBreadcrumbs, this.callbackState, this.logger);
        this.storageManager = ContextExtensionsKt.getStorageManagerFrom(this.appContext);
        this.contextState = new ContextState();
        this.contextState.setContext(configuration.getContext());
        this.sessionStore = new SessionStore(this.immutableConfig, this.logger, null);
        this.sessionTracker = new SessionTracker(this.immutableConfig, this.callbackState, this, this.sessionStore, this.logger, this.bgTaskService);
        this.metadataState = this.copyMetadataState(configuration);
        ActivityManager am = ContextExtensionsKt.getActivityManagerFrom(this.appContext);
        this.launchCrashTracker = new LaunchCrashTracker(this.immutableConfig);
        this.appDataCollector = new AppDataCollector(this.appContext, this.appContext.getPackageManager(), this.immutableConfig, this.sessionTracker, am, this.launchCrashTracker, this.logger);
        SharedPrefMigrator sharedPrefMigrator = new SharedPrefMigrator(this.appContext);
        DeviceIdStore deviceIdStore = new DeviceIdStore(this.appContext, sharedPrefMigrator, this.logger);
        String deviceId = deviceIdStore.loadDeviceId();
        UserStore userStore = new UserStore(this.immutableConfig, deviceId, sharedPrefMigrator, this.logger);
        this.userState = userStore.load(configuration.getUser());
        sharedPrefMigrator.deleteLegacyPrefs();
        DeviceBuildInfo info = DeviceBuildInfo.Companion.defaultInfo();
        Resources resources = this.appContext.getResources();
        this.deviceDataCollector = new DeviceDataCollector(this.connectivity, this.appContext, resources, deviceId, info, Environment.getDataDirectory(), new RootDetector(this.logger), this.bgTaskService, this.logger);
        if (this.appContext instanceof Application) {
            Application application = (Application)this.appContext;
            this.sessionLifecycleCallback = new SessionLifecycleCallback(this.sessionTracker);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.sessionLifecycleCallback);
            if (this.immutableConfig.shouldRecordBreadcrumbType(BreadcrumbType.STATE)) {
                this.activityBreadcrumbCollector = new ActivityBreadcrumbCollector((Function2<? super String, ? super Map<String, ? extends Object>, Unit>)new Function2<String, Map<String, ? extends Object>, Unit>(){

                    public Unit invoke(String activity, Map<String, ?> metadata) {
                        Client.this.leaveBreadcrumb(activity, metadata, BreadcrumbType.STATE);
                        return null;
                    }
                });
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityBreadcrumbCollector);
            } else {
                this.activityBreadcrumbCollector = null;
            }
        } else {
            this.activityBreadcrumbCollector = null;
            this.sessionLifecycleCallback = null;
        }
        InternalReportDelegate delegate = new InternalReportDelegate(this.appContext, this.logger, this.immutableConfig, this.storageManager, this.appDataCollector, this.deviceDataCollector, this.sessionTracker, this.notifier, this.bgTaskService);
        this.eventStore = new EventStore(this.immutableConfig, this.logger, this.notifier, this.bgTaskService, (FileStore.Delegate)delegate);
        this.deliveryDelegate = new DeliveryDelegate(this.logger, this.eventStore, this.immutableConfig, this.breadcrumbState, this.notifier, this.bgTaskService);
        this.exceptionHandler = new ExceptionHandler(this, this.logger);
        if (this.immutableConfig.getEnabledErrorTypes().getUnhandledExceptions()) {
            this.exceptionHandler.install();
        }
        this.systemBroadcastReceiver = SystemBroadcastReceiver.register(this, this.logger, this.bgTaskService);
        this.registerOrientationChangeListener();
        this.registerMemoryTrimListener();
        this.lastRunInfoStore = new LastRunInfoStore(this.immutableConfig);
        this.lastRunInfo = this.loadLastRunInfo();
        this.loadPlugins(configuration);
        this.connectivity.registerForNetworkChanges();
        this.eventStore.flushOnLaunch();
        this.eventStore.flushAsync();
        this.sessionTracker.flushAsync();
        Map<String, Object> data = Collections.emptyMap();
        this.leaveAutoBreadcrumb("Bugsnag loaded", BreadcrumbType.STATE, data);
        this.logger.d("Bugsnag loaded");
    }

    @VisibleForTesting
    Client(ImmutableConfig immutableConfig, MetadataState metadataState, ContextState contextState, CallbackState callbackState, UserState userState, ClientObservable clientObservable, Context appContext, @NonNull DeviceDataCollector deviceDataCollector, @NonNull AppDataCollector appDataCollector, @NonNull BreadcrumbState breadcrumbState, @NonNull EventStore eventStore, SessionStore sessionStore, SystemBroadcastReceiver systemBroadcastReceiver, SessionTracker sessionTracker, ActivityBreadcrumbCollector activityBreadcrumbCollector, SessionLifecycleCallback sessionLifecycleCallback, Connectivity connectivity, @Nullable StorageManager storageManager, Logger logger, DeliveryDelegate deliveryDelegate, LastRunInfoStore lastRunInfoStore, LaunchCrashTracker launchCrashTracker, ExceptionHandler exceptionHandler) {
        this.immutableConfig = immutableConfig;
        this.metadataState = metadataState;
        this.contextState = contextState;
        this.callbackState = callbackState;
        this.userState = userState;
        this.clientObservable = clientObservable;
        this.appContext = appContext;
        this.deviceDataCollector = deviceDataCollector;
        this.appDataCollector = appDataCollector;
        this.breadcrumbState = breadcrumbState;
        this.eventStore = eventStore;
        this.sessionStore = sessionStore;
        this.systemBroadcastReceiver = systemBroadcastReceiver;
        this.sessionTracker = sessionTracker;
        this.activityBreadcrumbCollector = activityBreadcrumbCollector;
        this.sessionLifecycleCallback = sessionLifecycleCallback;
        this.connectivity = connectivity;
        this.storageManager = storageManager;
        this.logger = logger;
        this.deliveryDelegate = deliveryDelegate;
        this.lastRunInfoStore = lastRunInfoStore;
        this.launchCrashTracker = launchCrashTracker;
        this.lastRunInfo = null;
        this.exceptionHandler = exceptionHandler;
    }

    private LastRunInfo loadLastRunInfo() {
        LastRunInfo lastRunInfo = this.lastRunInfoStore.load();
        LastRunInfo currentRunInfo = new LastRunInfo(0, false, false);
        this.persistRunInfo(currentRunInfo);
        return lastRunInfo;
    }

    private void persistRunInfo(final LastRunInfo runInfo) {
        try {
            this.bgTaskService.submitTask(TaskType.IO, new Runnable(){

                @Override
                public void run() {
                    Client.this.lastRunInfoStore.persist(runInfo);
                }
            });
        }
        catch (RejectedExecutionException exc) {
            this.logger.w("Failed to persist last run info", exc);
        }
    }

    private void loadPlugins(@NonNull Configuration configuration) {
        NativeInterface.setClient(this);
        Set<Plugin> userPlugins = configuration.getPlugins();
        this.pluginClient = new PluginClient(userPlugins, this.immutableConfig, this.logger);
        this.pluginClient.loadPlugins(this);
    }

    private void logNull(String property) {
        this.logger.e("Invalid null value supplied to client." + property + ", ignoring");
    }

    private MetadataState copyMetadataState(@NonNull Configuration configuration) {
        Metadata orig = configuration.impl.metadataState.getMetadata();
        Metadata copy = orig.copy();
        return configuration.impl.metadataState.copy(copy);
    }

    private void registerOrientationChangeListener() {
        IntentFilter configFilter = new IntentFilter();
        configFilter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        ConfigChangeReceiver receiver = new ConfigChangeReceiver(this.deviceDataCollector, (Function2<? super String, ? super String, Unit>)new Function2<String, String, Unit>(){

            public Unit invoke(String oldOrientation, String newOrientation) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("from", oldOrientation);
                data.put("to", newOrientation);
                Client.this.leaveAutoBreadcrumb("Orientation changed", BreadcrumbType.STATE, data);
                Client.this.clientObservable.postOrientationChange(newOrientation);
                return null;
            }
        });
        ContextExtensionsKt.registerReceiverSafe(this.appContext, receiver, configFilter, this.logger);
    }

    private void registerMemoryTrimListener() {
        this.appContext.registerComponentCallbacks((ComponentCallbacks)new ClientComponentCallbacks((Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(){

            public Unit invoke(Boolean isLowMemory) {
                Client.this.clientObservable.postMemoryTrimEvent(isLowMemory);
                return null;
            }
        }));
    }

    void setupNdkPlugin() {
        String lastRunInfoPath = this.lastRunInfoStore.getFile().getAbsolutePath();
        int crashes = this.lastRunInfo != null ? this.lastRunInfo.getConsecutiveLaunchCrashes() : 0;
        this.clientObservable.postNdkInstall(this.immutableConfig, lastRunInfoPath, crashes);
        this.syncInitialState();
        this.clientObservable.postNdkDeliverPending();
    }

    void registerObserver(Observer observer) {
        this.metadataState.addObserver(observer);
        this.breadcrumbState.addObserver(observer);
        this.sessionTracker.addObserver(observer);
        this.clientObservable.addObserver(observer);
        this.userState.addObserver(observer);
        this.contextState.addObserver(observer);
        this.deliveryDelegate.addObserver(observer);
        this.launchCrashTracker.addObserver(observer);
    }

    void unregisterObserver(Observer observer) {
        this.metadataState.deleteObserver(observer);
        this.breadcrumbState.deleteObserver(observer);
        this.sessionTracker.deleteObserver(observer);
        this.clientObservable.deleteObserver(observer);
        this.userState.deleteObserver(observer);
        this.contextState.deleteObserver(observer);
        this.deliveryDelegate.deleteObserver(observer);
        this.launchCrashTracker.deleteObserver(observer);
    }

    void syncInitialState() {
        this.metadataState.emitObservableEvent();
        this.contextState.emitObservableEvent();
        this.userState.emitObservableEvent();
    }

    public void startSession() {
        this.sessionTracker.startSession(false);
    }

    public void pauseSession() {
        this.sessionTracker.pauseSession();
    }

    public boolean resumeSession() {
        return this.sessionTracker.resumeSession();
    }

    @Nullable
    public String getContext() {
        return this.contextState.getContext();
    }

    public void setContext(@Nullable String context) {
        this.contextState.setContext(context);
    }

    @Override
    public void setUser(@Nullable String id, @Nullable String email, @Nullable String name) {
        this.userState.setUser(new User(id, email, name));
    }

    @Override
    @NonNull
    public User getUser() {
        return this.userState.getUser();
    }

    @Override
    public void addOnError(@NonNull OnErrorCallback onError) {
        if (onError != null) {
            this.callbackState.addOnError(onError);
        } else {
            this.logNull("addOnError");
        }
    }

    @Override
    public void removeOnError(@NonNull OnErrorCallback onError) {
        if (onError != null) {
            this.callbackState.removeOnError(onError);
        } else {
            this.logNull("removeOnError");
        }
    }

    @Override
    public void addOnBreadcrumb(@NonNull OnBreadcrumbCallback onBreadcrumb) {
        if (onBreadcrumb != null) {
            this.callbackState.addOnBreadcrumb(onBreadcrumb);
        } else {
            this.logNull("addOnBreadcrumb");
        }
    }

    @Override
    public void removeOnBreadcrumb(@NonNull OnBreadcrumbCallback onBreadcrumb) {
        if (onBreadcrumb != null) {
            this.callbackState.removeOnBreadcrumb(onBreadcrumb);
        } else {
            this.logNull("removeOnBreadcrumb");
        }
    }

    @Override
    public void addOnSession(@NonNull OnSessionCallback onSession) {
        if (onSession != null) {
            this.callbackState.addOnSession(onSession);
        } else {
            this.logNull("addOnSession");
        }
    }

    @Override
    public void removeOnSession(@NonNull OnSessionCallback onSession) {
        if (onSession != null) {
            this.callbackState.removeOnSession(onSession);
        } else {
            this.logNull("removeOnSession");
        }
    }

    public void notify(@NonNull Throwable exception) {
        this.notify(exception, null);
    }

    public void notify(@NonNull Throwable exc, @Nullable OnErrorCallback onError) {
        if (exc != null) {
            SeverityReason severityReason = SeverityReason.newInstance("handledException");
            Metadata metadata = this.metadataState.getMetadata();
            Event event = new Event(exc, this.immutableConfig, severityReason, metadata, this.logger);
            this.populateAndNotifyAndroidEvent(event, onError);
        } else {
            this.logNull("notify");
        }
    }

    void notifyUnhandledException(@NonNull Throwable exc, Metadata metadata, String severityReason, @Nullable String attributeValue) {
        SeverityReason handledState = SeverityReason.newInstance(severityReason, Severity.ERROR, attributeValue);
        Metadata data = Metadata.Companion.merge(this.metadataState.getMetadata(), metadata);
        Event event = new Event(exc, this.immutableConfig, handledState, data, this.logger);
        this.populateAndNotifyAndroidEvent(event, null);
        int consecutiveLaunchCrashes = this.lastRunInfo == null ? 0 : this.lastRunInfo.getConsecutiveLaunchCrashes();
        boolean launching = this.launchCrashTracker.isLaunching();
        if (launching) {
            ++consecutiveLaunchCrashes;
        }
        LastRunInfo runInfo = new LastRunInfo(consecutiveLaunchCrashes, true, launching);
        this.persistRunInfo(runInfo);
        this.bgTaskService.shutdown();
    }

    void populateAndNotifyAndroidEvent(@NonNull Event event, @Nullable OnErrorCallback onError) {
        event.setDevice(this.deviceDataCollector.generateDeviceWithState(new Date().getTime()));
        event.addMetadata("device", this.deviceDataCollector.getDeviceMetadata());
        event.setApp(this.appDataCollector.generateAppWithState());
        event.addMetadata("app", this.appDataCollector.getAppDataMetadata());
        event.setBreadcrumbs(new ArrayList<Breadcrumb>(this.breadcrumbState.getStore()));
        User user = this.userState.getUser();
        event.setUser(user.getId(), user.getEmail(), user.getName());
        if (Intrinsics.isEmpty(event.getContext())) {
            String context = this.contextState.getContext();
            event.setContext(context != null ? context : this.appDataCollector.getActiveScreenClass());
        }
        this.notifyInternal(event, onError);
    }

    void notifyInternal(@NonNull Event event, @Nullable OnErrorCallback onError) {
        String type = event.getImpl().getSeverityReasonType();
        this.logger.d("Client#notifyInternal() - event captured by Client, type=" + type);
        if (event.shouldDiscardClass()) {
            this.logger.d("Skipping notification - should not notify for this class");
            return;
        }
        if (!this.immutableConfig.shouldNotifyForReleaseStage()) {
            this.logger.d("Skipping notification - should not notify for this release stage");
            return;
        }
        Set<String> redactedKeys = this.metadataState.getMetadata().getRedactedKeys();
        Metadata eventMetadata = event.getImpl().getMetadata();
        eventMetadata.setRedactedKeys(redactedKeys);
        Session currentSession = this.sessionTracker.getCurrentSession();
        if (currentSession != null && (this.immutableConfig.getAutoTrackSessions() || !currentSession.isAutoCaptured())) {
            event.setSession(currentSession);
        }
        if (!this.callbackState.runOnErrorTasks(event, this.logger) || onError != null && !onError.onError(event)) {
            this.logger.d("Skipping notification - onError task returned false");
            return;
        }
        this.deliveryDelegate.deliver(event);
    }

    @NonNull
    public List<Breadcrumb> getBreadcrumbs() {
        return new ArrayList<Breadcrumb>(this.breadcrumbState.getStore());
    }

    @NonNull
    AppDataCollector getAppDataCollector() {
        return this.appDataCollector;
    }

    @NonNull
    DeviceDataCollector getDeviceDataCollector() {
        return this.deviceDataCollector;
    }

    public void addMetadata(@NonNull String section, @NonNull Map<String, ?> value) {
        if (section != null && value != null) {
            this.metadataState.addMetadata(section, value);
        } else {
            this.logNull("addMetadata");
        }
    }

    @Override
    public void addMetadata(@NonNull String section, @NonNull String key, @Nullable Object value) {
        if (section != null && key != null) {
            this.metadataState.addMetadata(section, key, value);
        } else {
            this.logNull("addMetadata");
        }
    }

    @Override
    public void clearMetadata(@NonNull String section) {
        if (section != null) {
            this.metadataState.clearMetadata(section);
        } else {
            this.logNull("clearMetadata");
        }
    }

    @Override
    public void clearMetadata(@NonNull String section, @NonNull String key) {
        if (section != null && key != null) {
            this.metadataState.clearMetadata(section, key);
        } else {
            this.logNull("clearMetadata");
        }
    }

    @Override
    @Nullable
    public Map<String, Object> getMetadata(@NonNull String section) {
        if (section != null) {
            return this.metadataState.getMetadata(section);
        }
        this.logNull("getMetadata");
        return null;
    }

    @Override
    @Nullable
    public Object getMetadata(@NonNull String section, @NonNull String key) {
        if (section != null && key != null) {
            return this.metadataState.getMetadata(section, key);
        }
        this.logNull("getMetadata");
        return null;
    }

    @NonNull
    Map<String, Object> getMetadata() {
        return this.metadataState.getMetadata().toMap();
    }

    public void leaveBreadcrumb(@NonNull String message) {
        if (message != null) {
            this.breadcrumbState.add(new Breadcrumb(message, this.logger));
        } else {
            this.logNull("leaveBreadcrumb");
        }
    }

    public void leaveBreadcrumb(@NonNull String message, @NonNull Map<String, Object> metadata, @NonNull BreadcrumbType type) {
        if (message != null && type != null && metadata != null) {
            this.breadcrumbState.add(new Breadcrumb(message, type, metadata, new Date(), this.logger));
        } else {
            this.logNull("leaveBreadcrumb");
        }
    }

    void leaveAutoBreadcrumb(@NonNull String message, @NonNull BreadcrumbType type, @NonNull Map<String, Object> metadata) {
        if (this.immutableConfig.shouldRecordBreadcrumbType(type)) {
            this.breadcrumbState.add(new Breadcrumb(message, type, metadata, new Date(), this.logger));
        }
    }

    @Nullable
    public LastRunInfo getLastRunInfo() {
        return this.lastRunInfo;
    }

    public void markLaunchCompleted() {
        this.launchCrashTracker.markLaunchCompleted();
    }

    SessionTracker getSessionTracker() {
        return this.sessionTracker;
    }

    @NonNull
    EventStore getEventStore() {
        return this.eventStore;
    }

    protected void finalize() throws Throwable {
        if (this.systemBroadcastReceiver != null) {
            try {
                ContextExtensionsKt.unregisterReceiverSafe(this.appContext, this.systemBroadcastReceiver, this.logger);
            }
            catch (IllegalArgumentException exception) {
                this.logger.w("Receiver not registered");
            }
        }
        super.finalize();
    }

    private void warnIfNotAppContext(Context androidContext) {
        if (!(androidContext instanceof Application)) {
            this.logger.w("Warning - Non-Application context detected! Please ensure that you are initializing Bugsnag from a custom Application class.");
        }
    }

    ImmutableConfig getConfig() {
        return this.immutableConfig;
    }

    void setBinaryArch(String binaryArch) {
        this.getAppDataCollector().setBinaryArch(binaryArch);
    }

    Context getAppContext() {
        return this.appContext;
    }

    @Nullable
    String getCodeBundleId() {
        return this.appDataCollector.getCodeBundleId();
    }

    void setCodeBundleId(@Nullable String codeBundleId) {
        this.appDataCollector.setCodeBundleId(codeBundleId);
    }

    void addRuntimeVersionInfo(@NonNull String key, @NonNull String value) {
        this.deviceDataCollector.addRuntimeVersionInfo(key, value);
    }

    @VisibleForTesting
    void close() {
        this.connectivity.unregisterForNetworkChanges();
        this.bgTaskService.shutdown();
    }

    Logger getLogger() {
        return this.logger;
    }

    @Nullable
    Plugin getPlugin(@NonNull Class clz) {
        return this.pluginClient.findPlugin(clz);
    }

    Notifier getNotifier() {
        return this.notifier;
    }

    MetadataState getMetadataState() {
        return this.metadataState;
    }

    void setAutoNotify(boolean autoNotify) {
        this.pluginClient.setAutoNotify(this, autoNotify);
        if (autoNotify) {
            this.exceptionHandler.install();
        } else {
            this.exceptionHandler.uninstall();
        }
    }

    void setAutoDetectAnrs(boolean autoDetectAnrs) {
        this.pluginClient.setAutoDetectAnrs(this, autoDetectAnrs);
    }
}

