/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.BackgroundTaskService;
import com.bugsnag.android.BaseObservable;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.BreadcrumbState;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.DeliveryParams;
import com.bugsnag.android.DeliveryStatus;
import com.bugsnag.android.Error;
import com.bugsnag.android.Event;
import com.bugsnag.android.EventPayload;
import com.bugsnag.android.EventStore;
import com.bugsnag.android.ImmutableConfig;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.Session;
import com.bugsnag.android.StateEvent;
import com.bugsnag.android.TaskType;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;

class DeliveryDelegate
extends BaseObservable {
    final Logger logger;
    private final EventStore eventStore;
    private final ImmutableConfig immutableConfig;
    final BreadcrumbState breadcrumbState;
    private final Notifier notifier;
    final BackgroundTaskService backgroundTaskService;

    DeliveryDelegate(Logger logger, EventStore eventStore, ImmutableConfig immutableConfig, BreadcrumbState breadcrumbState, Notifier notifier, BackgroundTaskService backgroundTaskService) {
        this.logger = logger;
        this.eventStore = eventStore;
        this.immutableConfig = immutableConfig;
        this.breadcrumbState = breadcrumbState;
        this.notifier = notifier;
        this.backgroundTaskService = backgroundTaskService;
    }

    void deliver(@NonNull Event event) {
        this.logger.d("DeliveryDelegate#deliver() - event being stored/delivered by Client");
        String apiKey = event.getApiKey();
        EventPayload eventPayload = new EventPayload(apiKey, event, this.notifier, this.immutableConfig);
        Session session = event.getSession();
        if (session != null) {
            if (event.isUnhandled()) {
                event.setSession(session.incrementUnhandledAndCopy());
                this.notifyObservers(StateEvent.NotifyUnhandled.INSTANCE);
            } else {
                event.setSession(session.incrementHandledAndCopy());
                this.notifyObservers(StateEvent.NotifyHandled.INSTANCE);
            }
        }
        if (event.getImpl().getOriginalUnhandled()) {
            String severityReasonType = event.getImpl().getSeverityReasonType();
            boolean promiseRejection = "unhandledPromiseRejection".equals(severityReasonType);
            boolean anr = event.getImpl().isAnr(event);
            this.cacheEvent(event, anr || promiseRejection);
        } else {
            this.deliverPayloadAsync(event, eventPayload);
        }
    }

    private void deliverPayloadAsync(@NonNull Event event, EventPayload eventPayload) {
        final EventPayload finalEventPayload = eventPayload;
        final Event finalEvent = event;
        try {
            this.backgroundTaskService.submitTask(TaskType.ERROR_REQUEST, new Runnable(){

                @Override
                public void run() {
                    DeliveryDelegate.this.deliverPayloadInternal(finalEventPayload, finalEvent);
                }
            });
        }
        catch (RejectedExecutionException exception) {
            this.cacheEvent(event, false);
            this.logger.w("Exceeded max queue count, saving to disk to send later");
        }
    }

    @VisibleForTesting
    DeliveryStatus deliverPayloadInternal(@NonNull EventPayload payload, @NonNull Event event) {
        this.logger.d("DeliveryDelegate#deliverPayloadInternal() - attempting event delivery");
        DeliveryParams deliveryParams = this.immutableConfig.getErrorApiDeliveryParams(payload);
        Delivery delivery = this.immutableConfig.getDelivery();
        DeliveryStatus deliveryStatus = delivery.deliver(payload, deliveryParams);
        switch (deliveryStatus) {
            case DELIVERED: {
                this.logger.i("Sent 1 new event to Bugsnag");
                this.leaveErrorBreadcrumb(event);
                break;
            }
            case UNDELIVERED: {
                this.logger.w("Could not send event(s) to Bugsnag, saving to disk to send later");
                this.cacheEvent(event, false);
                this.leaveErrorBreadcrumb(event);
                break;
            }
            case FAILURE: {
                this.logger.w("Problem sending event to Bugsnag");
                break;
            }
        }
        return deliveryStatus;
    }

    private void cacheEvent(@NonNull Event event, boolean attemptSend) {
        this.eventStore.write(event);
        if (attemptSend) {
            this.eventStore.flushAsync();
        }
    }

    private void leaveErrorBreadcrumb(@NonNull Event event) {
        List<Error> errors = event.getErrors();
        if (errors.size() > 0) {
            String errorClass = errors.get(0).getErrorClass();
            String message = errors.get(0).getErrorMessage();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("errorClass", errorClass);
            data.put("message", message);
            data.put("unhandled", String.valueOf(event.isUnhandled()));
            data.put("severity", event.getSeverity().toString());
            this.breadcrumbState.add(new Breadcrumb(errorClass, BreadcrumbType.ERROR, data, new Date(), this.logger));
        }
    }
}

