/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.CallbackAware;
import com.bugsnag.android.CollectionUtils;
import com.bugsnag.android.ConfigInternal;
import com.bugsnag.android.DebugLogger;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.EndpointConfiguration;
import com.bugsnag.android.ErrorTypes;
import com.bugsnag.android.FeatureFlag;
import com.bugsnag.android.FeatureFlagAware;
import com.bugsnag.android.Intrinsics;
import com.bugsnag.android.Logger;
import com.bugsnag.android.MetadataAware;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.OnBreadcrumbCallback;
import com.bugsnag.android.OnErrorCallback;
import com.bugsnag.android.OnSendCallback;
import com.bugsnag.android.OnSessionCallback;
import com.bugsnag.android.Plugin;
import com.bugsnag.android.Telemetry;
import com.bugsnag.android.ThreadSendPolicy;
import com.bugsnag.android.User;
import com.bugsnag.android.UserAware;
import java.io.File;
import java.util.Map;
import java.util.Set;

public class Configuration
implements CallbackAware,
MetadataAware,
UserAware,
FeatureFlagAware {
    private static final int MIN_BREADCRUMBS = 0;
    private static final int MAX_BREADCRUMBS = 500;
    private static final int VALID_API_KEY_LEN = 32;
    private static final long MIN_LAUNCH_CRASH_THRESHOLD_MS = 0L;
    final ConfigInternal impl;

    public Configuration(@NonNull String apiKey) {
        this.validateApiKey(apiKey);
        this.impl = new ConfigInternal(apiKey);
    }

    @NonNull
    public static Configuration load(@NonNull Context context) {
        return ConfigInternal.load(context);
    }

    @NonNull
    static Configuration load(@NonNull Context context, @NonNull String apiKey) {
        return ConfigInternal.load(context, apiKey);
    }

    private void validateApiKey(String value) {
        if (Configuration.isInvalidApiKey(value)) {
            DebugLogger.INSTANCE.w("Invalid configuration. apiKey should be a 32-character hexademical string, got " + value);
        }
    }

    @VisibleForTesting
    static boolean isInvalidApiKey(String apiKey) {
        if (Intrinsics.isEmpty(apiKey)) {
            throw new IllegalArgumentException("No Bugsnag API Key set");
        }
        if (apiKey.length() != 32) {
            return true;
        }
        for (int k = 0; k < 32; ++k) {
            char chr = apiKey.charAt(k);
            if (Character.isDigit(chr) || chr >= 'a' && chr <= 'f') continue;
            return true;
        }
        return false;
    }

    private void logNull(String property) {
        this.getLogger().e("Invalid null value supplied to config." + property + ", ignoring");
    }

    @NonNull
    public String getApiKey() {
        return this.impl.getApiKey();
    }

    public void setApiKey(@NonNull String apiKey) {
        this.validateApiKey(apiKey);
        this.impl.setApiKey(apiKey);
    }

    @Nullable
    public String getAppVersion() {
        return this.impl.getAppVersion();
    }

    public void setAppVersion(@Nullable String appVersion) {
        this.impl.setAppVersion(appVersion);
    }

    @Nullable
    public Integer getVersionCode() {
        return this.impl.getVersionCode();
    }

    public void setVersionCode(@Nullable Integer versionCode) {
        this.impl.setVersionCode(versionCode);
    }

    @Nullable
    public String getReleaseStage() {
        return this.impl.getReleaseStage();
    }

    public void setReleaseStage(@Nullable String releaseStage) {
        this.impl.setReleaseStage(releaseStage);
    }

    @NonNull
    public ThreadSendPolicy getSendThreads() {
        return this.impl.getSendThreads();
    }

    public void setSendThreads(@NonNull ThreadSendPolicy sendThreads) {
        if (sendThreads != null) {
            this.impl.setSendThreads(sendThreads);
        } else {
            this.logNull("sendThreads");
        }
    }

    public boolean getPersistUser() {
        return this.impl.getPersistUser();
    }

    public void setPersistUser(boolean persistUser) {
        this.impl.setPersistUser(persistUser);
    }

    @Nullable
    public File getPersistenceDirectory() {
        return this.impl.getPersistenceDirectory();
    }

    public void setPersistenceDirectory(@Nullable File directory) {
        this.impl.setPersistenceDirectory(directory);
    }

    @Deprecated
    public long getLaunchCrashThresholdMs() {
        this.getLogger().w("The launchCrashThresholdMs configuration option is deprecated and will be removed in a future release. Please use launchDurationMillis instead.");
        return this.getLaunchDurationMillis();
    }

    @Deprecated
    public void setLaunchCrashThresholdMs(long launchCrashThresholdMs) {
        this.getLogger().w("The launchCrashThresholdMs configuration option is deprecated and will be removed in a future release. Please use launchDurationMillis instead.");
        this.setLaunchDurationMillis(launchCrashThresholdMs);
    }

    public boolean getSendLaunchCrashesSynchronously() {
        return this.impl.getSendLaunchCrashesSynchronously();
    }

    public void setSendLaunchCrashesSynchronously(boolean sendLaunchCrashesSynchronously) {
        this.impl.setSendLaunchCrashesSynchronously(sendLaunchCrashesSynchronously);
    }

    public long getLaunchDurationMillis() {
        return this.impl.getLaunchDurationMillis();
    }

    public void setLaunchDurationMillis(long launchDurationMillis) {
        if (launchDurationMillis >= 0L) {
            this.impl.setLaunchDurationMillis(launchDurationMillis);
        } else {
            this.getLogger().e("Invalid configuration value detected. Option launchDurationMillis should be a positive long value.Supplied value is " + launchDurationMillis);
        }
    }

    public boolean getAutoTrackSessions() {
        return this.impl.getAutoTrackSessions();
    }

    public void setAutoTrackSessions(boolean autoTrackSessions) {
        this.impl.setAutoTrackSessions(autoTrackSessions);
    }

    @NonNull
    public ErrorTypes getEnabledErrorTypes() {
        return this.impl.getEnabledErrorTypes();
    }

    public void setEnabledErrorTypes(@NonNull ErrorTypes enabledErrorTypes) {
        if (enabledErrorTypes != null) {
            this.impl.setEnabledErrorTypes(enabledErrorTypes);
        } else {
            this.logNull("enabledErrorTypes");
        }
    }

    public boolean getAutoDetectErrors() {
        return this.impl.getAutoDetectErrors();
    }

    public void setAutoDetectErrors(boolean autoDetectErrors) {
        this.impl.setAutoDetectErrors(autoDetectErrors);
    }

    @Nullable
    public String getAppType() {
        return this.impl.getAppType();
    }

    public void setAppType(@Nullable String appType) {
        this.impl.setAppType(appType);
    }

    @Nullable
    public Logger getLogger() {
        return this.impl.getLogger();
    }

    public void setLogger(@Nullable Logger logger) {
        this.impl.setLogger(logger);
    }

    @NonNull
    public Delivery getDelivery() {
        return this.impl.getDelivery();
    }

    public void setDelivery(@NonNull Delivery delivery) {
        if (delivery != null) {
            this.impl.setDelivery(delivery);
        } else {
            this.logNull("delivery");
        }
    }

    @NonNull
    public EndpointConfiguration getEndpoints() {
        return this.impl.getEndpoints();
    }

    public void setEndpoints(@NonNull EndpointConfiguration endpoints) {
        if (endpoints != null) {
            this.impl.setEndpoints(endpoints);
        } else {
            this.logNull("endpoints");
        }
    }

    public int getMaxBreadcrumbs() {
        return this.impl.getMaxBreadcrumbs();
    }

    public void setMaxBreadcrumbs(int maxBreadcrumbs) {
        if (maxBreadcrumbs >= 0 && maxBreadcrumbs <= 500) {
            this.impl.setMaxBreadcrumbs(maxBreadcrumbs);
        } else {
            this.getLogger().e("Invalid configuration value detected. Option maxBreadcrumbs should be an integer between 0-100. Supplied value is " + maxBreadcrumbs);
        }
    }

    public int getMaxPersistedEvents() {
        return this.impl.getMaxPersistedEvents();
    }

    public void setMaxPersistedEvents(int maxPersistedEvents) {
        if (maxPersistedEvents >= 0) {
            this.impl.setMaxPersistedEvents(maxPersistedEvents);
        } else {
            this.getLogger().e("Invalid configuration value detected. Option maxPersistedEvents should be a positive integer.Supplied value is " + maxPersistedEvents);
        }
    }

    public int getMaxReportedThreads() {
        return this.impl.getMaxReportedThreads();
    }

    public void setMaxReportedThreads(int maxReportedThreads) {
        if (maxReportedThreads >= 0) {
            this.impl.setMaxReportedThreads(maxReportedThreads);
        } else {
            this.getLogger().e("Invalid configuration value detected. Option maxReportedThreads should be a positive integer.Supplied value is " + maxReportedThreads);
        }
    }

    public int getMaxPersistedSessions() {
        return this.impl.getMaxPersistedSessions();
    }

    public void setMaxPersistedSessions(int maxPersistedSessions) {
        if (maxPersistedSessions >= 0) {
            this.impl.setMaxPersistedSessions(maxPersistedSessions);
        } else {
            this.getLogger().e("Invalid configuration value detected. Option maxPersistedSessions should be a positive integer.Supplied value is " + maxPersistedSessions);
        }
    }

    public int getMaxStringValueLength() {
        return this.impl.getMaxStringValueLength();
    }

    public void setMaxStringValueLength(int maxStringValueLength) {
        if (maxStringValueLength >= 0) {
            this.impl.setMaxStringValueLength(maxStringValueLength);
        } else {
            this.getLogger().e("Invalid configuration value detected. Option maxStringValueLength should be a positive integer.Supplied value is " + maxStringValueLength);
        }
    }

    @Nullable
    public String getContext() {
        return this.impl.getContext();
    }

    public void setContext(@Nullable String context) {
        this.impl.setContext(context);
    }

    @NonNull
    public Set<String> getRedactedKeys() {
        return this.impl.getRedactedKeys();
    }

    public void setRedactedKeys(@NonNull Set<String> redactedKeys) {
        if (CollectionUtils.containsNullElements(redactedKeys)) {
            this.logNull("redactedKeys");
        } else {
            this.impl.setRedactedKeys(redactedKeys);
        }
    }

    @NonNull
    public Set<String> getDiscardClasses() {
        return this.impl.getDiscardClasses();
    }

    public void setDiscardClasses(@NonNull Set<String> discardClasses) {
        if (CollectionUtils.containsNullElements(discardClasses)) {
            this.logNull("discardClasses");
        } else {
            this.impl.setDiscardClasses(discardClasses);
        }
    }

    @Nullable
    public Set<String> getEnabledReleaseStages() {
        return this.impl.getEnabledReleaseStages();
    }

    public void setEnabledReleaseStages(@Nullable Set<String> enabledReleaseStages) {
        this.impl.setEnabledReleaseStages(enabledReleaseStages);
    }

    @Nullable
    public Set<BreadcrumbType> getEnabledBreadcrumbTypes() {
        return this.impl.getEnabledBreadcrumbTypes();
    }

    public void setEnabledBreadcrumbTypes(@Nullable Set<BreadcrumbType> enabledBreadcrumbTypes) {
        this.impl.setEnabledBreadcrumbTypes(enabledBreadcrumbTypes);
    }

    @NonNull
    public Set<Telemetry> getTelemetry() {
        return this.impl.getTelemetry();
    }

    public void setTelemetry(@NonNull Set<Telemetry> telemetry) {
        if (telemetry != null) {
            this.impl.setTelemetry(telemetry);
        } else {
            this.logNull("telemetry");
        }
    }

    @NonNull
    public Set<String> getProjectPackages() {
        return this.impl.getProjectPackages();
    }

    public void setProjectPackages(@NonNull Set<String> projectPackages) {
        if (CollectionUtils.containsNullElements(projectPackages)) {
            this.logNull("projectPackages");
        } else {
            this.impl.setProjectPackages(projectPackages);
        }
    }

    @Override
    public void addOnError(@NonNull OnErrorCallback onError) {
        if (onError != null) {
            this.impl.addOnError(onError);
        } else {
            this.logNull("addOnError");
        }
    }

    @Override
    public void removeOnError(@NonNull OnErrorCallback onError) {
        if (onError != null) {
            this.impl.removeOnError(onError);
        } else {
            this.logNull("removeOnError");
        }
    }

    @Override
    public void addOnBreadcrumb(@NonNull OnBreadcrumbCallback onBreadcrumb) {
        if (onBreadcrumb != null) {
            this.impl.addOnBreadcrumb(onBreadcrumb);
        } else {
            this.logNull("addOnBreadcrumb");
        }
    }

    @Override
    public void removeOnBreadcrumb(@NonNull OnBreadcrumbCallback onBreadcrumb) {
        if (onBreadcrumb != null) {
            this.impl.removeOnBreadcrumb(onBreadcrumb);
        } else {
            this.logNull("removeOnBreadcrumb");
        }
    }

    @Override
    public void addOnSession(@NonNull OnSessionCallback onSession) {
        if (onSession != null) {
            this.impl.addOnSession(onSession);
        } else {
            this.logNull("addOnSession");
        }
    }

    @Override
    public void removeOnSession(@NonNull OnSessionCallback onSession) {
        if (onSession != null) {
            this.impl.removeOnSession(onSession);
        } else {
            this.logNull("removeOnSession");
        }
    }

    public void addOnSend(@NonNull OnSendCallback onSend) {
        if (onSend != null) {
            this.impl.addOnSend(onSend);
        } else {
            this.logNull("addOnSend");
        }
    }

    public void removeOnSend(@NonNull OnSendCallback onSend) {
        if (onSend != null) {
            this.impl.removeOnSend(onSend);
        } else {
            this.logNull("removeOnSend");
        }
    }

    public void addMetadata(@NonNull String section, @NonNull Map<String, ?> value) {
        if (section != null && value != null) {
            this.impl.addMetadata(section, value);
        } else {
            this.logNull("addMetadata");
        }
    }

    @Override
    public void addMetadata(@NonNull String section, @NonNull String key, @Nullable Object value) {
        if (section != null && key != null) {
            this.impl.addMetadata(section, key, value);
        } else {
            this.logNull("addMetadata");
        }
    }

    @Override
    public void clearMetadata(@NonNull String section) {
        if (section != null) {
            this.impl.clearMetadata(section);
        } else {
            this.logNull("clearMetadata");
        }
    }

    @Override
    public void clearMetadata(@NonNull String section, @NonNull String key) {
        if (section != null && key != null) {
            this.impl.clearMetadata(section, key);
        } else {
            this.logNull("clearMetadata");
        }
    }

    @Override
    @Nullable
    public Map<String, Object> getMetadata(@NonNull String section) {
        if (section != null) {
            return this.impl.getMetadata(section);
        }
        this.logNull("getMetadata");
        return null;
    }

    @Override
    @Nullable
    public Object getMetadata(@NonNull String section, @NonNull String key) {
        if (section != null && key != null) {
            return this.impl.getMetadata(section, key);
        }
        this.logNull("getMetadata");
        return null;
    }

    @Override
    public void addFeatureFlag(@NonNull String name) {
        if (name != null) {
            this.impl.addFeatureFlag(name);
        } else {
            this.logNull("addFeatureFlag");
        }
    }

    @Override
    public void addFeatureFlag(@NonNull String name, @Nullable String variant) {
        if (name != null) {
            this.impl.addFeatureFlag(name, variant);
        } else {
            this.logNull("addFeatureFlag");
        }
    }

    @Override
    public void addFeatureFlags(@NonNull Iterable<FeatureFlag> featureFlags) {
        if (featureFlags != null) {
            this.impl.addFeatureFlags(featureFlags);
        } else {
            this.logNull("addFeatureFlags");
        }
    }

    @Override
    public void clearFeatureFlag(@NonNull String name) {
        if (name != null) {
            this.impl.clearFeatureFlag(name);
        } else {
            this.logNull("clearFeatureFlag");
        }
    }

    @Override
    public void clearFeatureFlags() {
        this.impl.clearFeatureFlags();
    }

    @Override
    @NonNull
    public User getUser() {
        return this.impl.getUser();
    }

    @Override
    public void setUser(@Nullable String id, @Nullable String email, @Nullable String name) {
        this.impl.setUser(id, email, name);
    }

    public void addPlugin(@NonNull Plugin plugin) {
        if (plugin != null) {
            this.impl.addPlugin(plugin);
        } else {
            this.logNull("addPlugin");
        }
    }

    public void setAttemptDeliveryOnCrash(boolean attemptDeliveryOnCrash) {
        this.impl.setAttemptDeliveryOnCrash(attemptDeliveryOnCrash);
    }

    public boolean isAttemptDeliveryOnCrash() {
        return this.impl.getAttemptDeliveryOnCrash();
    }

    Set<Plugin> getPlugins() {
        return this.impl.getPlugins();
    }

    Notifier getNotifier() {
        return this.impl.getNotifier();
    }
}

