/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android.internal;

import com.bugsnag.android.NdkPluginCaller;
import com.bugsnag.android.internal.InternalMetrics;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u001c\u0010\u0012\u001a\u00020\r2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u000bH\u0016J\u001c\u0010\u0014\u001a\u00020\r2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u000bH\u0016R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t0\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\t`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/bugsnag/android/internal/InternalMetricsImpl;", "Lcom/bugsnag/android/internal/InternalMetrics;", "()V", "callbackCounts", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "configDifferences", "", "allCallbacks", "", "modifyCallback", "", "callback", "delta", "notifyAddCallback", "notifyRemoveCallback", "setCallbackCounts", "newCallbackCounts", "setConfigDifferences", "differences", "toJsonableMap", "bugsnag-android-core_release"})
public final class InternalMetricsImpl
implements InternalMetrics {
    private final HashMap<String, Object> configDifferences;
    private final HashMap<String, Integer> callbackCounts;

    @Override
    @NotNull
    public Map<String, Object> toJsonableMap() {
        Map<String, Object> callbacks = this.allCallbacks();
        Object[] objectArray = new Pair[2];
        Map<String, Object> map = (Map<String, Object>)this.configDifferences;
        boolean bl = false;
        objectArray[0] = !map.isEmpty() ? TuplesKt.to((Object)"config", this.configDifferences) : null;
        map = callbacks;
        bl = false;
        objectArray[1] = !map.isEmpty() ? TuplesKt.to((Object)"callbacks", callbacks) : null;
        return MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    @Override
    public void setConfigDifferences(@NotNull Map<String, ? extends Object> differences) {
        Intrinsics.checkParameterIsNotNull(differences, (String)"differences");
        this.configDifferences.clear();
        this.configDifferences.putAll(differences);
        NdkPluginCaller.INSTANCE.setStaticData(MapsKt.mapOf((Pair)TuplesKt.to((Object)"usage", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"config", this.configDifferences)))));
    }

    @Override
    public void setCallbackCounts(@NotNull Map<String, Integer> newCallbackCounts) {
        Intrinsics.checkParameterIsNotNull(newCallbackCounts, (String)"newCallbackCounts");
        this.callbackCounts.clear();
        this.callbackCounts.putAll(newCallbackCounts);
        NdkPluginCaller.INSTANCE.initCallbackCounts(newCallbackCounts);
    }

    @Override
    public void notifyAddCallback(@NotNull String callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.modifyCallback(callback, 1);
        NdkPluginCaller.INSTANCE.notifyAddCallback(callback);
    }

    @Override
    public void notifyRemoveCallback(@NotNull String callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.modifyCallback(callback, -1);
        NdkPluginCaller.INSTANCE.notifyRemoveCallback(callback);
    }

    private final void modifyCallback(String callback, int delta) {
        Integer n = this.callbackCounts.get(callback);
        if (n == null) {
            n = 0;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"callbackCounts[callback] ?: 0");
        int currentValue = n;
        ((Map)this.callbackCounts).put(callback, RangesKt.coerceAtLeast((int)(currentValue += delta), (int)0));
    }

    private final Map<String, Object> allCallbacks() {
        Map<String, Boolean> usage;
        Integer ndkOnError;
        boolean bl = false;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.putAll((Map)this.callbackCounts);
        Map<String, Integer> counts = NdkPluginCaller.INSTANCE.getCurrentCallbackSetCounts();
        if (counts != null && (ndkOnError = counts.get("ndkOnError")) != null) {
            ((Map)result).put("ndkOnError", ndkOnError);
        }
        if ((usage = NdkPluginCaller.INSTANCE.getCurrentNativeApiCallUsage()) != null) {
            result.putAll(usage);
        }
        return result;
    }

    public InternalMetricsImpl() {
        boolean bl = false;
        this.configDifferences = new HashMap();
        bl = false;
        this.callbackCounts = new HashMap();
    }
}

