/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.os.StrictMode;
import androidx.annotation.NonNull;
import com.bugsnag.android.Client;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Metadata;
import com.bugsnag.android.StrictModeHandler;

class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String STRICT_MODE_TAB = "StrictMode";
    private static final String STRICT_MODE_KEY = "Violation";
    private final Thread.UncaughtExceptionHandler originalHandler;
    private final StrictModeHandler strictModeHandler = new StrictModeHandler();
    private final Client client;
    private final Logger logger;

    ExceptionHandler(Client client, Logger logger) {
        this.client = client;
        this.logger = logger;
        this.originalHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    void install() {
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    void uninstall() {
        Thread.setDefaultUncaughtExceptionHandler(this.originalHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {
        try {
            String severityReason;
            if (this.client.getConfig().shouldDiscardError(throwable)) {
                return;
            }
            boolean strictModeThrowable = this.strictModeHandler.isStrictModeThrowable(throwable);
            Metadata metadata = new Metadata();
            String violationDesc = null;
            if (strictModeThrowable) {
                violationDesc = this.strictModeHandler.getViolationDescription(throwable.getMessage());
                metadata = new Metadata();
                metadata.addMetadata(STRICT_MODE_TAB, STRICT_MODE_KEY, violationDesc);
            }
            String string = severityReason = strictModeThrowable ? "strictMode" : "unhandledException";
            if (strictModeThrowable) {
                StrictMode.ThreadPolicy originalThreadPolicy = StrictMode.getThreadPolicy();
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)StrictMode.ThreadPolicy.LAX);
                this.client.notifyUnhandledException(throwable, metadata, severityReason, violationDesc);
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)originalThreadPolicy);
            } else {
                this.client.notifyUnhandledException(throwable, metadata, severityReason, null);
            }
        }
        catch (Throwable throwable2) {
        }
        finally {
            this.forwardToOriginalHandler(thread, throwable);
        }
    }

    private void forwardToOriginalHandler(@NonNull Thread thread, @NonNull Throwable throwable) {
        if (this.originalHandler != null) {
            this.originalHandler.uncaughtException(thread, throwable);
        } else {
            System.err.printf("Exception in thread \"%s\" ", thread.getName());
            this.logger.w("Exception", throwable);
        }
    }
}

