/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.ActivityBreadcrumbCollector;
import com.bugsnag.android.AppDataCollector;
import com.bugsnag.android.BackgroundTaskService;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.BreadcrumbState;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.BugsnagStateModule;
import com.bugsnag.android.CallbackAware;
import com.bugsnag.android.CallbackState;
import com.bugsnag.android.ClientComponentCallbacks;
import com.bugsnag.android.ClientObservable;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Connectivity;
import com.bugsnag.android.ConnectivityCompat;
import com.bugsnag.android.ContextExtensionsKt;
import com.bugsnag.android.ContextState;
import com.bugsnag.android.DataCollectionModule;
import com.bugsnag.android.DeliveryDelegate;
import com.bugsnag.android.DeviceDataCollector;
import com.bugsnag.android.Error;
import com.bugsnag.android.Event;
import com.bugsnag.android.EventStorageModule;
import com.bugsnag.android.EventStore;
import com.bugsnag.android.ExceptionHandler;
import com.bugsnag.android.LastRunInfo;
import com.bugsnag.android.LastRunInfoStore;
import com.bugsnag.android.LaunchCrashTracker;
import com.bugsnag.android.Logger;
import com.bugsnag.android.MemoryTrimState;
import com.bugsnag.android.Metadata;
import com.bugsnag.android.MetadataAware;
import com.bugsnag.android.MetadataState;
import com.bugsnag.android.NativeInterface;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.OnBreadcrumbCallback;
import com.bugsnag.android.OnErrorCallback;
import com.bugsnag.android.OnSessionCallback;
import com.bugsnag.android.Plugin;
import com.bugsnag.android.PluginClient;
import com.bugsnag.android.Session;
import com.bugsnag.android.SessionLifecycleCallback;
import com.bugsnag.android.SessionTracker;
import com.bugsnag.android.Severity;
import com.bugsnag.android.SeverityReason;
import com.bugsnag.android.StorageModule;
import com.bugsnag.android.SystemBroadcastReceiver;
import com.bugsnag.android.TaskType;
import com.bugsnag.android.TrackerModule;
import com.bugsnag.android.User;
import com.bugsnag.android.UserAware;
import com.bugsnag.android.UserState;
import com.bugsnag.android.internal.ImmutableConfig;
import com.bugsnag.android.internal.StateObserver;
import com.bugsnag.android.internal.dag.ConfigModule;
import com.bugsnag.android.internal.dag.ContextModule;
import com.bugsnag.android.internal.dag.SystemServiceModule;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;

public class Client
implements MetadataAware,
CallbackAware,
UserAware {
    final ImmutableConfig immutableConfig;
    final MetadataState metadataState;
    private final ContextState contextState;
    private final CallbackState callbackState;
    private final UserState userState;
    final Context appContext;
    @NonNull
    final DeviceDataCollector deviceDataCollector;
    @NonNull
    final AppDataCollector appDataCollector;
    @NonNull
    final BreadcrumbState breadcrumbState;
    @NonNull
    final MemoryTrimState memoryTrimState = new MemoryTrimState();
    @NonNull
    protected final EventStore eventStore;
    final SessionTracker sessionTracker;
    final SystemBroadcastReceiver systemBroadcastReceiver;
    final Logger logger;
    final Connectivity connectivity;
    final DeliveryDelegate deliveryDelegate;
    final ClientObservable clientObservable;
    PluginClient pluginClient;
    final Notifier notifier;
    @Nullable
    final LastRunInfo lastRunInfo;
    final LastRunInfoStore lastRunInfoStore;
    final LaunchCrashTracker launchCrashTracker;
    final BackgroundTaskService bgTaskService = new BackgroundTaskService();
    private final ExceptionHandler exceptionHandler;

    public Client(@NonNull Context androidContext) {
        this(androidContext, Configuration.load(androidContext));
    }

    public Client(@NonNull Context androidContext, @NonNull String apiKey) {
        this(androidContext, Configuration.load(androidContext, apiKey));
    }

    public Client(@NonNull Context androidContext, @NonNull Configuration configuration) {
        ContextModule contextModule = new ContextModule(androidContext);
        this.appContext = contextModule.getCtx();
        this.notifier = configuration.getNotifier();
        this.connectivity = new ConnectivityCompat(this.appContext, (Function2<? super Boolean, ? super String, Unit>)new Function2<Boolean, String, Unit>(){

            public Unit invoke(Boolean hasConnection, String networkState) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("hasConnection", hasConnection);
                data.put("networkState", networkState);
                Client.this.leaveAutoBreadcrumb("Connectivity changed", BreadcrumbType.STATE, data);
                if (hasConnection.booleanValue()) {
                    Client.this.eventStore.flushAsync();
                    Client.this.sessionTracker.flushAsync();
                }
                return null;
            }
        });
        ConfigModule configModule = new ConfigModule(contextModule, configuration, this.connectivity);
        this.immutableConfig = configModule.getConfig();
        this.logger = this.immutableConfig.getLogger();
        this.warnIfNotAppContext(androidContext);
        StorageModule storageModule = new StorageModule(this.appContext, this.immutableConfig, this.logger);
        BugsnagStateModule bugsnagStateModule = new BugsnagStateModule(configModule, configuration);
        this.clientObservable = bugsnagStateModule.getClientObservable();
        this.callbackState = bugsnagStateModule.getCallbackState();
        this.breadcrumbState = bugsnagStateModule.getBreadcrumbState();
        this.contextState = bugsnagStateModule.getContextState();
        this.metadataState = bugsnagStateModule.getMetadataState();
        SystemServiceModule systemServiceModule = new SystemServiceModule(contextModule);
        storageModule.resolveDependencies(this.bgTaskService, TaskType.IO);
        TrackerModule trackerModule = new TrackerModule(configModule, storageModule, this, this.bgTaskService, this.callbackState);
        this.launchCrashTracker = trackerModule.getLaunchCrashTracker();
        this.sessionTracker = trackerModule.getSessionTracker();
        DataCollectionModule dataCollectionModule = new DataCollectionModule(contextModule, configModule, systemServiceModule, trackerModule, this.bgTaskService, this.connectivity, storageModule.getDeviceId(), this.memoryTrimState);
        dataCollectionModule.resolveDependencies(this.bgTaskService, TaskType.IO);
        this.appDataCollector = dataCollectionModule.getAppDataCollector();
        this.deviceDataCollector = dataCollectionModule.getDeviceDataCollector();
        this.userState = storageModule.getUserStore().load(configuration.getUser());
        storageModule.getSharedPrefMigrator().deleteLegacyPrefs();
        this.registerLifecycleCallbacks();
        EventStorageModule eventStorageModule = new EventStorageModule(contextModule, configModule, dataCollectionModule, this.bgTaskService, trackerModule, systemServiceModule, this.notifier, this.callbackState);
        eventStorageModule.resolveDependencies(this.bgTaskService, TaskType.IO);
        this.eventStore = eventStorageModule.getEventStore();
        this.deliveryDelegate = new DeliveryDelegate(this.logger, this.eventStore, this.immutableConfig, this.callbackState, this.notifier, this.bgTaskService);
        this.exceptionHandler = new ExceptionHandler(this, this.logger);
        if (this.immutableConfig.getEnabledErrorTypes().getUnhandledExceptions()) {
            this.exceptionHandler.install();
        }
        this.lastRunInfoStore = storageModule.getLastRunInfoStore();
        this.lastRunInfo = storageModule.getLastRunInfo();
        this.loadPlugins(configuration);
        this.eventStore.flushOnLaunch();
        this.eventStore.flushAsync();
        this.sessionTracker.flushAsync();
        this.systemBroadcastReceiver = new SystemBroadcastReceiver(this, this.logger);
        this.registerComponentCallbacks();
        this.registerListenersInBackground();
        Map<String, Object> data = Collections.emptyMap();
        this.leaveAutoBreadcrumb("Bugsnag loaded", BreadcrumbType.STATE, data);
        this.logger.d("Bugsnag loaded");
    }

    @VisibleForTesting
    Client(ImmutableConfig immutableConfig, MetadataState metadataState, ContextState contextState, CallbackState callbackState, UserState userState, ClientObservable clientObservable, Context appContext, @NonNull DeviceDataCollector deviceDataCollector2, @NonNull AppDataCollector appDataCollector2, @NonNull BreadcrumbState breadcrumbState, @NonNull EventStore eventStore2, SystemBroadcastReceiver systemBroadcastReceiver, SessionTracker sessionTracker, Connectivity connectivity, Logger logger, DeliveryDelegate deliveryDelegate, LastRunInfoStore lastRunInfoStore2, LaunchCrashTracker launchCrashTracker, ExceptionHandler exceptionHandler, Notifier notifier) {
        this.immutableConfig = immutableConfig;
        this.metadataState = metadataState;
        this.contextState = contextState;
        this.callbackState = callbackState;
        this.userState = userState;
        this.clientObservable = clientObservable;
        this.appContext = appContext;
        this.deviceDataCollector = deviceDataCollector2;
        this.appDataCollector = appDataCollector2;
        this.breadcrumbState = breadcrumbState;
        this.eventStore = eventStore2;
        this.systemBroadcastReceiver = systemBroadcastReceiver;
        this.sessionTracker = sessionTracker;
        this.connectivity = connectivity;
        this.logger = logger;
        this.deliveryDelegate = deliveryDelegate;
        this.lastRunInfoStore = lastRunInfoStore2;
        this.launchCrashTracker = launchCrashTracker;
        this.lastRunInfo = null;
        this.exceptionHandler = exceptionHandler;
        this.notifier = notifier;
    }

    void registerLifecycleCallbacks() {
        if (this.appContext instanceof Application) {
            Application application = (Application)this.appContext;
            SessionLifecycleCallback sessionCb = new SessionLifecycleCallback(this.sessionTracker);
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)sessionCb);
            if (!this.immutableConfig.shouldDiscardBreadcrumb(BreadcrumbType.STATE)) {
                ActivityBreadcrumbCollector activityCb = new ActivityBreadcrumbCollector((Function2<? super String, ? super Map<String, ? extends Object>, Unit>)new Function2<String, Map<String, ? extends Object>, Unit>(){

                    public Unit invoke(String activity, Map<String, ?> metadata) {
                        Client.this.leaveBreadcrumb(activity, metadata, BreadcrumbType.STATE);
                        return null;
                    }
                });
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            }
        }
    }

    void registerListenersInBackground() {
        try {
            this.bgTaskService.submitTask(TaskType.DEFAULT, new Runnable(){

                @Override
                public void run() {
                    Client.this.connectivity.registerForNetworkChanges();
                    SystemBroadcastReceiver.register(Client.this.appContext, Client.this.systemBroadcastReceiver, Client.this.logger);
                }
            });
        }
        catch (RejectedExecutionException ex) {
            this.logger.w("Failed to register for system events", ex);
        }
    }

    private void persistRunInfo(final LastRunInfo runInfo) {
        try {
            this.bgTaskService.submitTask(TaskType.IO, new Runnable(){

                @Override
                public void run() {
                    Client.this.lastRunInfoStore.persist(runInfo);
                }
            });
        }
        catch (RejectedExecutionException exc) {
            this.logger.w("Failed to persist last run info", exc);
        }
    }

    private void loadPlugins(@NonNull Configuration configuration) {
        NativeInterface.setClient(this);
        Set<Plugin> userPlugins = configuration.getPlugins();
        this.pluginClient = new PluginClient(userPlugins, this.immutableConfig, this.logger);
        this.pluginClient.loadPlugins(this);
    }

    private void logNull(String property) {
        this.logger.e("Invalid null value supplied to client." + property + ", ignoring");
    }

    private void registerComponentCallbacks() {
        this.appContext.registerComponentCallbacks((ComponentCallbacks)new ClientComponentCallbacks(this.deviceDataCollector, (Function2<? super String, ? super String, Unit>)new Function2<String, String, Unit>(){

            public Unit invoke(String oldOrientation, String newOrientation) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("from", oldOrientation);
                data.put("to", newOrientation);
                Client.this.leaveAutoBreadcrumb("Orientation changed", BreadcrumbType.STATE, data);
                Client.this.clientObservable.postOrientationChange(newOrientation);
                return null;
            }
        }, (Function2<? super Boolean, ? super Integer, Unit>)new Function2<Boolean, Integer, Unit>(){

            public Unit invoke(Boolean isLowMemory, Integer memoryTrimLevel) {
                Client.this.memoryTrimState.setLowMemory(Boolean.TRUE.equals(isLowMemory));
                if (Client.this.memoryTrimState.updateMemoryTrimLevel(memoryTrimLevel)) {
                    Client.this.leaveAutoBreadcrumb("Trim Memory", BreadcrumbType.STATE, Collections.singletonMap("trimLevel", Client.this.memoryTrimState.getTrimLevelDescription()));
                }
                Client.this.memoryTrimState.emitObservableEvent();
                return null;
            }
        }));
    }

    void setupNdkPlugin() {
        if (!this.setupNdkDirectory()) {
            this.logger.w("Failed to setup NDK directory.");
            return;
        }
        String lastRunInfoPath = this.lastRunInfoStore.getFile().getAbsolutePath();
        int crashes = this.lastRunInfo != null ? this.lastRunInfo.getConsecutiveLaunchCrashes() : 0;
        this.clientObservable.postNdkInstall(this.immutableConfig, lastRunInfoPath, crashes);
        this.syncInitialState();
        this.clientObservable.postNdkDeliverPending();
    }

    private boolean setupNdkDirectory() {
        try {
            return this.bgTaskService.submitTask(TaskType.IO, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    File outFile = new File(NativeInterface.getNativeReportPath());
                    return outFile.exists() || outFile.mkdirs();
                }
            }).get();
        }
        catch (Throwable exc) {
            return false;
        }
    }

    void addObserver(StateObserver observer) {
        this.metadataState.addObserver(observer);
        this.breadcrumbState.addObserver(observer);
        this.sessionTracker.addObserver(observer);
        this.clientObservable.addObserver(observer);
        this.userState.addObserver(observer);
        this.contextState.addObserver(observer);
        this.deliveryDelegate.addObserver(observer);
        this.launchCrashTracker.addObserver(observer);
        this.memoryTrimState.addObserver(observer);
    }

    void removeObserver(StateObserver observer) {
        this.metadataState.removeObserver(observer);
        this.breadcrumbState.removeObserver(observer);
        this.sessionTracker.removeObserver(observer);
        this.clientObservable.removeObserver(observer);
        this.userState.removeObserver(observer);
        this.contextState.removeObserver(observer);
        this.deliveryDelegate.removeObserver(observer);
        this.launchCrashTracker.removeObserver(observer);
        this.memoryTrimState.removeObserver(observer);
    }

    void syncInitialState() {
        this.metadataState.emitObservableEvent();
        this.contextState.emitObservableEvent();
        this.userState.emitObservableEvent();
        this.memoryTrimState.emitObservableEvent();
    }

    public void startSession() {
        this.sessionTracker.startSession(false);
    }

    public void pauseSession() {
        this.sessionTracker.pauseSession();
    }

    public boolean resumeSession() {
        return this.sessionTracker.resumeSession();
    }

    @Nullable
    public String getContext() {
        return this.contextState.getContext();
    }

    public void setContext(@Nullable String context) {
        this.contextState.setManualContext(context);
    }

    @Override
    public void setUser(@Nullable String id, @Nullable String email, @Nullable String name) {
        this.userState.setUser(new User(id, email, name));
    }

    @Override
    @NonNull
    public User getUser() {
        return this.userState.getUser();
    }

    @Override
    public void addOnError(@NonNull OnErrorCallback onError) {
        if (onError != null) {
            this.callbackState.addOnError(onError);
        } else {
            this.logNull("addOnError");
        }
    }

    @Override
    public void removeOnError(@NonNull OnErrorCallback onError) {
        if (onError != null) {
            this.callbackState.removeOnError(onError);
        } else {
            this.logNull("removeOnError");
        }
    }

    @Override
    public void addOnBreadcrumb(@NonNull OnBreadcrumbCallback onBreadcrumb) {
        if (onBreadcrumb != null) {
            this.callbackState.addOnBreadcrumb(onBreadcrumb);
        } else {
            this.logNull("addOnBreadcrumb");
        }
    }

    @Override
    public void removeOnBreadcrumb(@NonNull OnBreadcrumbCallback onBreadcrumb) {
        if (onBreadcrumb != null) {
            this.callbackState.removeOnBreadcrumb(onBreadcrumb);
        } else {
            this.logNull("removeOnBreadcrumb");
        }
    }

    @Override
    public void addOnSession(@NonNull OnSessionCallback onSession) {
        if (onSession != null) {
            this.callbackState.addOnSession(onSession);
        } else {
            this.logNull("addOnSession");
        }
    }

    @Override
    public void removeOnSession(@NonNull OnSessionCallback onSession) {
        if (onSession != null) {
            this.callbackState.removeOnSession(onSession);
        } else {
            this.logNull("removeOnSession");
        }
    }

    public void notify(@NonNull Throwable exception) {
        this.notify(exception, null);
    }

    public void notify(@NonNull Throwable exc, @Nullable OnErrorCallback onError) {
        if (exc != null) {
            if (this.immutableConfig.shouldDiscardError(exc)) {
                return;
            }
            SeverityReason severityReason = SeverityReason.newInstance("handledException");
            Metadata metadata = this.metadataState.getMetadata();
            Event event = new Event(exc, this.immutableConfig, severityReason, metadata, this.logger);
            this.populateAndNotifyAndroidEvent(event, onError);
        } else {
            this.logNull("notify");
        }
    }

    void notifyUnhandledException(@NonNull Throwable exc, Metadata metadata, String severityReason, @Nullable String attributeValue) {
        SeverityReason handledState = SeverityReason.newInstance(severityReason, Severity.ERROR, attributeValue);
        Metadata data = Metadata.Companion.merge(this.metadataState.getMetadata(), metadata);
        Event event = new Event(exc, this.immutableConfig, handledState, data, this.logger);
        this.populateAndNotifyAndroidEvent(event, null);
        int consecutiveLaunchCrashes = this.lastRunInfo == null ? 0 : this.lastRunInfo.getConsecutiveLaunchCrashes();
        boolean launching = this.launchCrashTracker.isLaunching();
        if (launching) {
            ++consecutiveLaunchCrashes;
        }
        LastRunInfo runInfo = new LastRunInfo(consecutiveLaunchCrashes, true, launching);
        this.persistRunInfo(runInfo);
        this.bgTaskService.shutdown();
    }

    void populateAndNotifyAndroidEvent(@NonNull Event event, @Nullable OnErrorCallback onError) {
        event.setDevice(this.deviceDataCollector.generateDeviceWithState(new Date().getTime()));
        event.addMetadata("device", this.deviceDataCollector.getDeviceMetadata());
        event.setApp(this.appDataCollector.generateAppWithState());
        event.addMetadata("app", this.appDataCollector.getAppDataMetadata());
        event.setBreadcrumbs(this.breadcrumbState.copy());
        User user = this.userState.getUser();
        event.setUser(user.getId(), user.getEmail(), user.getName());
        event.setContext(this.contextState.getContext());
        this.notifyInternal(event, onError);
    }

    void notifyInternal(@NonNull Event event, @Nullable OnErrorCallback onError) {
        Set<String> redactedKeys = this.metadataState.getMetadata().getRedactedKeys();
        event.setRedactedKeys(redactedKeys);
        Session currentSession = this.sessionTracker.getCurrentSession();
        if (currentSession != null && (this.immutableConfig.getAutoTrackSessions() || !currentSession.isAutoCaptured())) {
            event.setSession(currentSession);
        }
        if (!this.callbackState.runOnErrorTasks(event, this.logger) || onError != null && !onError.onError(event)) {
            this.logger.d("Skipping notification - onError task returned false");
            return;
        }
        this.leaveErrorBreadcrumb(event);
        this.deliveryDelegate.deliver(event);
    }

    @NonNull
    public List<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbState.copy();
    }

    @NonNull
    AppDataCollector getAppDataCollector() {
        return this.appDataCollector;
    }

    @NonNull
    DeviceDataCollector getDeviceDataCollector() {
        return this.deviceDataCollector;
    }

    public void addMetadata(@NonNull String section, @NonNull Map<String, ?> value) {
        if (section != null && value != null) {
            this.metadataState.addMetadata(section, value);
        } else {
            this.logNull("addMetadata");
        }
    }

    @Override
    public void addMetadata(@NonNull String section, @NonNull String key, @Nullable Object value) {
        if (section != null && key != null) {
            this.metadataState.addMetadata(section, key, value);
        } else {
            this.logNull("addMetadata");
        }
    }

    @Override
    public void clearMetadata(@NonNull String section) {
        if (section != null) {
            this.metadataState.clearMetadata(section);
        } else {
            this.logNull("clearMetadata");
        }
    }

    @Override
    public void clearMetadata(@NonNull String section, @NonNull String key) {
        if (section != null && key != null) {
            this.metadataState.clearMetadata(section, key);
        } else {
            this.logNull("clearMetadata");
        }
    }

    @Override
    @Nullable
    public Map<String, Object> getMetadata(@NonNull String section) {
        if (section != null) {
            return this.metadataState.getMetadata(section);
        }
        this.logNull("getMetadata");
        return null;
    }

    @Override
    @Nullable
    public Object getMetadata(@NonNull String section, @NonNull String key) {
        if (section != null && key != null) {
            return this.metadataState.getMetadata(section, key);
        }
        this.logNull("getMetadata");
        return null;
    }

    @NonNull
    Map<String, Object> getMetadata() {
        return this.metadataState.getMetadata().toMap();
    }

    public void leaveBreadcrumb(@NonNull String message) {
        if (message != null) {
            this.breadcrumbState.add(new Breadcrumb(message, this.logger));
        } else {
            this.logNull("leaveBreadcrumb");
        }
    }

    public void leaveBreadcrumb(@NonNull String message, @NonNull Map<String, Object> metadata, @NonNull BreadcrumbType type) {
        if (message != null && type != null && metadata != null) {
            this.breadcrumbState.add(new Breadcrumb(message, type, metadata, new Date(), this.logger));
        } else {
            this.logNull("leaveBreadcrumb");
        }
    }

    void leaveAutoBreadcrumb(@NonNull String message, @NonNull BreadcrumbType type, @NonNull Map<String, Object> metadata) {
        if (!this.immutableConfig.shouldDiscardBreadcrumb(type)) {
            this.breadcrumbState.add(new Breadcrumb(message, type, metadata, new Date(), this.logger));
        }
    }

    private void leaveErrorBreadcrumb(@NonNull Event event) {
        List<Error> errors = event.getErrors();
        if (errors.size() > 0) {
            String errorClass = errors.get(0).getErrorClass();
            String message = errors.get(0).getErrorMessage();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("errorClass", errorClass);
            data.put("message", message);
            data.put("unhandled", String.valueOf(event.isUnhandled()));
            data.put("severity", event.getSeverity().toString());
            this.breadcrumbState.add(new Breadcrumb(errorClass, BreadcrumbType.ERROR, data, new Date(), this.logger));
        }
    }

    @Nullable
    public LastRunInfo getLastRunInfo() {
        return this.lastRunInfo;
    }

    public void markLaunchCompleted() {
        this.launchCrashTracker.markLaunchCompleted();
    }

    SessionTracker getSessionTracker() {
        return this.sessionTracker;
    }

    @NonNull
    EventStore getEventStore() {
        return this.eventStore;
    }

    protected void finalize() throws Throwable {
        if (this.systemBroadcastReceiver != null) {
            try {
                ContextExtensionsKt.unregisterReceiverSafe(this.appContext, this.systemBroadcastReceiver, this.logger);
            }
            catch (IllegalArgumentException exception) {
                this.logger.w("Receiver not registered");
            }
        }
        super.finalize();
    }

    private void warnIfNotAppContext(Context androidContext) {
        if (!(androidContext instanceof Application)) {
            this.logger.w("You should initialize Bugsnag from the onCreate() callback of your Application subclass, as this guarantees errors are captured as early as possible. If a custom Application subclass is not possible in your app then you should suppress this warning by passing the Application context instead: Bugsnag.start(context.getApplicationContext()). For further info see: https://docs.bugsnag.com/platforms/android/#basic-configuration");
        }
    }

    ImmutableConfig getConfig() {
        return this.immutableConfig;
    }

    void setBinaryArch(String binaryArch) {
        this.getAppDataCollector().setBinaryArch(binaryArch);
    }

    Context getAppContext() {
        return this.appContext;
    }

    @Nullable
    String getCodeBundleId() {
        return this.appDataCollector.getCodeBundleId();
    }

    void setCodeBundleId(@Nullable String codeBundleId) {
        this.appDataCollector.setCodeBundleId(codeBundleId);
    }

    void addRuntimeVersionInfo(@NonNull String key, @NonNull String value) {
        this.deviceDataCollector.addRuntimeVersionInfo(key, value);
    }

    @VisibleForTesting
    void close() {
        this.connectivity.unregisterForNetworkChanges();
        this.bgTaskService.shutdown();
    }

    Logger getLogger() {
        return this.logger;
    }

    @Nullable
    Plugin getPlugin(@NonNull Class clz) {
        return this.pluginClient.findPlugin(clz);
    }

    Notifier getNotifier() {
        return this.notifier;
    }

    MetadataState getMetadataState() {
        return this.metadataState;
    }

    ContextState getContextState() {
        return this.contextState;
    }

    void setAutoNotify(boolean autoNotify) {
        this.pluginClient.setAutoNotify(this, autoNotify);
        if (autoNotify) {
            this.exceptionHandler.install();
        } else {
            this.exceptionHandler.uninstall();
        }
    }

    void setAutoDetectAnrs(boolean autoDetectAnrs) {
        this.pluginClient.setAutoDetectAnrs(this, autoDetectAnrs);
    }
}

