/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.IOUtils;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

abstract class FileStore {
    private final File storageDir;
    private final int maxStoreCount;
    private final Comparator<File> comparator;
    private final Lock lock = new ReentrantLock();
    private final Collection<File> queuedFiles = new ConcurrentSkipListSet<File>();
    private final Logger logger;
    private final Delegate delegate;

    FileStore(@NonNull File storageDir, int maxStoreCount, Comparator<File> comparator, Logger logger, Delegate delegate2) {
        this.maxStoreCount = maxStoreCount;
        this.comparator = comparator;
        this.logger = logger;
        this.delegate = delegate2;
        this.storageDir = storageDir;
        this.isStorageDirValid(storageDir);
    }

    private boolean isStorageDirValid(@NonNull File storageDir) {
        try {
            storageDir.mkdirs();
        }
        catch (Exception exception) {
            this.logger.e("Could not prepare file storage directory", exception);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueContentForDelivery(String content, String filename) {
        if (!this.isStorageDirValid(this.storageDir)) {
            return;
        }
        this.discardOldestFileIfNeeded();
        this.lock.lock();
        Writer out = null;
        String filePath = new File(this.storageDir, filename).getAbsolutePath();
        try {
            FileOutputStream fos = new FileOutputStream(filePath);
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            out.write(content);
        }
        catch (Exception exc) {
            File eventFile = new File(filePath);
            if (this.delegate != null) {
                this.delegate.onErrorIOFailure(exc, eventFile, "NDK Crash report copy");
            }
            IOUtils.deleteFile(eventFile, this.logger);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {
                this.logger.w("Failed to close unsent payload writer: " + filename, exception);
            }
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    String write(@NonNull JsonStream.Streamable streamable) {
        block10: {
            if (!this.isStorageDirValid(this.storageDir)) {
                return null;
            }
            if (this.maxStoreCount == 0) {
                return null;
            }
            this.discardOldestFileIfNeeded();
            String filename = new File(this.storageDir, this.getFilename(streamable)).getAbsolutePath();
            JsonStream stream = null;
            this.lock.lock();
            try {
                FileOutputStream fos = new FileOutputStream(filename);
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
                stream = new JsonStream(out);
                stream.value(streamable);
                this.logger.i("Saved unsent payload to disk: '" + filename + '\'');
                String string = filename;
                IOUtils.closeQuietly(stream);
                this.lock.unlock();
                return string;
            }
            catch (FileNotFoundException exc) {
                this.logger.w("Ignoring FileNotFoundException - unable to create file", exc);
            }
            catch (Exception exc2) {
                File eventFile = new File(filename);
                if (this.delegate != null) {
                    this.delegate.onErrorIOFailure(exc2, eventFile, "Crash report serialization");
                }
                IOUtils.deleteFile(eventFile, this.logger);
                break block10;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(stream);
                this.lock.unlock();
            }
        }
        return null;
    }

    void discardOldestFileIfNeeded() {
        if (this.isStorageDirValid(this.storageDir)) {
            File[] listFiles = this.storageDir.listFiles();
            if (listFiles == null) {
                return;
            }
            ArrayList<File> files = new ArrayList<File>(Arrays.asList(listFiles));
            if (files.size() >= this.maxStoreCount) {
                Collections.sort(files, this.comparator);
                for (int k = 0; k < files.size() && files.size() >= this.maxStoreCount; ++k) {
                    File oldestFile = (File)files.get(k);
                    if (this.queuedFiles.contains(oldestFile)) continue;
                    this.logger.w("Discarding oldest error as stored error limit reached: '" + oldestFile.getPath() + '\'');
                    this.deleteStoredFiles(Collections.singleton(oldestFile));
                    files.remove(k);
                    --k;
                }
            }
        }
    }

    @NonNull
    abstract String getFilename(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<File> findStoredFiles() {
        this.lock.lock();
        try {
            File[] values;
            ArrayList<File> files = new ArrayList<File>();
            if (this.isStorageDirValid(this.storageDir) && (values = this.storageDir.listFiles()) != null) {
                for (File value : values) {
                    if (value.length() == 0L) {
                        if (value.delete()) continue;
                        value.deleteOnExit();
                        continue;
                    }
                    if (!value.isFile() || this.queuedFiles.contains(value)) continue;
                    files.add(value);
                }
            }
            this.queuedFiles.addAll(files);
            ArrayList<File> arrayList = files;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    void cancelQueuedFiles(Collection<File> files) {
        this.lock.lock();
        try {
            if (files != null) {
                this.queuedFiles.removeAll(files);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteStoredFiles(Collection<File> storedFiles) {
        this.lock.lock();
        try {
            if (storedFiles != null) {
                this.queuedFiles.removeAll(storedFiles);
                for (File storedFile : storedFiles) {
                    if (storedFile.delete()) continue;
                    storedFile.deleteOnExit();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static interface Delegate {
        public void onErrorIOFailure(Exception var1, File var2, String var3);
    }
}

