/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Client;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.LastRunInfo;
import com.bugsnag.android.OnBreadcrumbCallback;
import com.bugsnag.android.OnErrorCallback;
import com.bugsnag.android.OnSessionCallback;
import com.bugsnag.android.User;
import java.util.List;
import java.util.Map;

public final class Bugsnag {
    private static final Object lock = new Object();
    @SuppressLint(value={"StaticFieldLeak"})
    static Client client;

    private Bugsnag() {
    }

    @NonNull
    public static Client start(@NonNull Context androidContext) {
        return Bugsnag.start(androidContext, Configuration.load(androidContext));
    }

    @NonNull
    public static Client start(@NonNull Context androidContext, @NonNull String apiKey) {
        return Bugsnag.start(androidContext, Configuration.load(androidContext, apiKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Client start(@NonNull Context androidContext, @NonNull Configuration config) {
        Object object = lock;
        synchronized (object) {
            if (client == null) {
                client = new Client(androidContext, config);
            } else {
                Bugsnag.logClientInitWarning();
            }
        }
        return client;
    }

    private static void logClientInitWarning() {
        Bugsnag.getClient().logger.w("Multiple Bugsnag.start calls detected. Ignoring.");
    }

    @Nullable
    public static String getContext() {
        return Bugsnag.getClient().getContext();
    }

    public static void setContext(@Nullable String context) {
        Bugsnag.getClient().setContext(context);
    }

    public static void setUser(@Nullable String id, @Nullable String email, @Nullable String name) {
        Bugsnag.getClient().setUser(id, email, name);
    }

    @NonNull
    public static User getUser() {
        return Bugsnag.getClient().getUser();
    }

    public static void addOnError(@NonNull OnErrorCallback onError) {
        Bugsnag.getClient().addOnError(onError);
    }

    public static void removeOnError(@NonNull OnErrorCallback onError) {
        Bugsnag.getClient().removeOnError(onError);
    }

    public static void addOnBreadcrumb(@NonNull OnBreadcrumbCallback onBreadcrumb) {
        Bugsnag.getClient().addOnBreadcrumb(onBreadcrumb);
    }

    public static void removeOnBreadcrumb(@NonNull OnBreadcrumbCallback onBreadcrumb) {
        Bugsnag.getClient().removeOnBreadcrumb(onBreadcrumb);
    }

    public static void addOnSession(@NonNull OnSessionCallback onSession) {
        Bugsnag.getClient().addOnSession(onSession);
    }

    public static void removeOnSession(@NonNull OnSessionCallback onSession) {
        Bugsnag.getClient().removeOnSession(onSession);
    }

    public static void notify(@NonNull Throwable exception) {
        Bugsnag.getClient().notify(exception);
    }

    public static void notify(@NonNull Throwable exception, @Nullable OnErrorCallback onError) {
        Bugsnag.getClient().notify(exception, onError);
    }

    public static void addMetadata(@NonNull String section, @NonNull Map<String, ?> value) {
        Bugsnag.getClient().addMetadata(section, value);
    }

    public static void addMetadata(@NonNull String section, @NonNull String key, @Nullable Object value) {
        Bugsnag.getClient().addMetadata(section, key, value);
    }

    public static void clearMetadata(@NonNull String section) {
        Bugsnag.getClient().clearMetadata(section);
    }

    public static void clearMetadata(@NonNull String section, @NonNull String key) {
        Bugsnag.getClient().clearMetadata(section, key);
    }

    @Nullable
    public static Map<String, Object> getMetadata(@NonNull String section) {
        return Bugsnag.getClient().getMetadata(section);
    }

    @Nullable
    public static Object getMetadata(@NonNull String section, @NonNull String key) {
        return Bugsnag.getClient().getMetadata(section, key);
    }

    public static void leaveBreadcrumb(@NonNull String message) {
        Bugsnag.getClient().leaveBreadcrumb(message);
    }

    public static void leaveBreadcrumb(@NonNull String message, @NonNull Map<String, Object> metadata, @NonNull BreadcrumbType type) {
        Bugsnag.getClient().leaveBreadcrumb(message, metadata, type);
    }

    public static void startSession() {
        Bugsnag.getClient().startSession();
    }

    public static boolean resumeSession() {
        return Bugsnag.getClient().resumeSession();
    }

    public static void pauseSession() {
        Bugsnag.getClient().pauseSession();
    }

    @NonNull
    public static List<Breadcrumb> getBreadcrumbs() {
        return Bugsnag.getClient().getBreadcrumbs();
    }

    @Nullable
    public static LastRunInfo getLastRunInfo() {
        return Bugsnag.getClient().getLastRunInfo();
    }

    public static void markLaunchCompleted() {
        Bugsnag.getClient().markLaunchCompleted();
    }

    @NonNull
    public static Client getClient() {
        if (client == null) {
            throw new IllegalStateException("You must call Bugsnag.start before any other Bugsnag methods");
        }
        return client;
    }
}

