/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.AppDataCollector;
import com.bugsnag.android.AppWithState;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Bugsnag;
import com.bugsnag.android.Client;
import com.bugsnag.android.DeviceDataCollector;
import com.bugsnag.android.DeviceWithState;
import com.bugsnag.android.Error;
import com.bugsnag.android.ErrorType;
import com.bugsnag.android.Event;
import com.bugsnag.android.EventStore;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Metadata;
import com.bugsnag.android.OnErrorCallback;
import com.bugsnag.android.Severity;
import com.bugsnag.android.SeverityReason;
import com.bugsnag.android.User;
import com.bugsnag.android.internal.ImmutableConfig;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class NativeInterface {
    private static Charset UTF8Charset = Charset.defaultCharset();
    @SuppressLint(value={"StaticFieldLeak"})
    private static Client client;

    @NonNull
    private static Client getClient() {
        if (client != null) {
            return client;
        }
        return Bugsnag.getClient();
    }

    public static void setClient(@NonNull Client client) {
        NativeInterface.client = client;
    }

    @Nullable
    public static String getContext() {
        return NativeInterface.getClient().getContext();
    }

    @NonNull
    public static String getNativeReportPath() {
        ImmutableConfig config = NativeInterface.getClient().getConfig();
        File persistenceDirectory = (File)config.getPersistenceDirectory().getValue();
        return new File(persistenceDirectory, "bugsnag-native").getAbsolutePath();
    }

    @NonNull
    public static Map<String, String> getUser() {
        HashMap<String, String> userData = new HashMap<String, String>();
        User user = NativeInterface.getClient().getUser();
        userData.put("id", user.getId());
        userData.put("name", user.getName());
        userData.put("email", user.getEmail());
        return userData;
    }

    @NonNull
    public static Map<String, Object> getApp() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        AppDataCollector source = NativeInterface.getClient().getAppDataCollector();
        AppWithState app = source.generateAppWithState();
        data.put("version", app.getVersion());
        data.put("releaseStage", app.getReleaseStage());
        data.put("id", app.getId());
        data.put("type", app.getType());
        data.put("buildUUID", app.getBuildUuid());
        data.put("duration", app.getDuration());
        data.put("durationInForeground", app.getDurationInForeground());
        data.put("versionCode", app.getVersionCode());
        data.put("inForeground", app.getInForeground());
        data.put("isLaunching", app.isLaunching());
        data.put("binaryArch", app.getBinaryArch());
        data.putAll(source.getAppDataMetadata());
        return data;
    }

    @NonNull
    public static Map<String, Object> getDevice() {
        DeviceDataCollector source = NativeInterface.getClient().getDeviceDataCollector();
        HashMap<String, Object> deviceData = new HashMap<String, Object>(source.getDeviceMetadata());
        DeviceWithState src = source.generateDeviceWithState(new Date().getTime());
        deviceData.put("freeDisk", src.getFreeDisk());
        deviceData.put("freeMemory", src.getFreeMemory());
        deviceData.put("orientation", src.getOrientation());
        deviceData.put("time", src.getTime());
        deviceData.put("cpuAbi", src.getCpuAbi());
        deviceData.put("jailbroken", src.getJailbroken());
        deviceData.put("id", src.getId());
        deviceData.put("locale", src.getLocale());
        deviceData.put("manufacturer", src.getManufacturer());
        deviceData.put("model", src.getModel());
        deviceData.put("osName", src.getOsName());
        deviceData.put("osVersion", src.getOsVersion());
        deviceData.put("runtimeVersions", src.getRuntimeVersions());
        deviceData.put("totalMemory", src.getTotalMemory());
        return deviceData;
    }

    @NonNull
    public static String[] getCpuAbi() {
        return NativeInterface.getClient().getDeviceDataCollector().getCpuAbi();
    }

    @NonNull
    public static Map<String, Object> getMetadata() {
        return NativeInterface.getClient().getMetadata();
    }

    @NonNull
    public static List<Breadcrumb> getBreadcrumbs() {
        return NativeInterface.getClient().getBreadcrumbs();
    }

    public static void setUser(@Nullable String id, @Nullable String email, @Nullable String name) {
        Client client = NativeInterface.getClient();
        client.setUser(id, email, name);
    }

    public static void setUser(@Nullable byte[] idBytes, @Nullable byte[] emailBytes, @Nullable byte[] nameBytes) {
        String id = idBytes == null ? null : new String(idBytes, UTF8Charset);
        String email = emailBytes == null ? null : new String(emailBytes, UTF8Charset);
        String name = nameBytes == null ? null : new String(nameBytes, UTF8Charset);
        NativeInterface.setUser(id, email, name);
    }

    public static void leaveBreadcrumb(@NonNull String name, @NonNull BreadcrumbType type) {
        if (name == null) {
            return;
        }
        NativeInterface.getClient().leaveBreadcrumb(name, new HashMap<String, Object>(), type);
    }

    public static void leaveBreadcrumb(@NonNull byte[] nameBytes, @NonNull BreadcrumbType type) {
        if (nameBytes == null) {
            return;
        }
        String name = new String(nameBytes, UTF8Charset);
        NativeInterface.getClient().leaveBreadcrumb(name, new HashMap<String, Object>(), type);
    }

    public static void leaveBreadcrumb(@NonNull String message, @NonNull String type, @NonNull Map<String, Object> metadata) {
        String typeName = type.toUpperCase(Locale.US);
        NativeInterface.getClient().leaveBreadcrumb(message, metadata, BreadcrumbType.valueOf(typeName));
    }

    public static void clearMetadata(@NonNull String section, @Nullable String key) {
        if (key == null) {
            NativeInterface.getClient().clearMetadata(section);
        } else {
            NativeInterface.getClient().clearMetadata(section, key);
        }
    }

    public static void addMetadata(@NonNull String tab, @Nullable String key, @Nullable Object value) {
        NativeInterface.getClient().addMetadata(tab, key, value);
    }

    @Nullable
    public static String getReleaseStage() {
        return NativeInterface.getClient().getConfig().getReleaseStage();
    }

    @NonNull
    public static String getSessionEndpoint() {
        return NativeInterface.getClient().getConfig().getEndpoints().getSessions();
    }

    @NonNull
    public static String getEndpoint() {
        return NativeInterface.getClient().getConfig().getEndpoints().getNotify();
    }

    public static void setContext(@Nullable String context) {
        NativeInterface.getClient().setContext(context);
    }

    public static void setBinaryArch(@NonNull String binaryArch) {
        NativeInterface.getClient().setBinaryArch(binaryArch);
    }

    @Nullable
    public static String getAppVersion() {
        return NativeInterface.getClient().getConfig().getAppVersion();
    }

    @Nullable
    public static Collection<String> getEnabledReleaseStages() {
        return NativeInterface.getClient().getConfig().getEnabledReleaseStages();
    }

    public static void registerSession(long startedAt, @Nullable String sessionId, int unhandledCount, int handledCount) {
        Client client = NativeInterface.getClient();
        User user = client.getUser();
        Date startDate = startedAt > 0L ? new Date(startedAt) : null;
        client.getSessionTracker().registerExistingSession(startDate, sessionId, user, unhandledCount, handledCount);
    }

    public static void deliverReport(@Nullable byte[] releaseStageBytes, @NonNull byte[] payloadBytes, @NonNull String apiKey, boolean isLaunching) {
        if (payloadBytes == null) {
            return;
        }
        String payload = new String(payloadBytes, UTF8Charset);
        String releaseStage = releaseStageBytes == null ? null : new String(releaseStageBytes, UTF8Charset);
        Client client = NativeInterface.getClient();
        ImmutableConfig config = client.getConfig();
        if (releaseStage == null || releaseStage.length() == 0 || !config.shouldDiscardByReleaseStage()) {
            EventStore eventStore2 = client.getEventStore();
            String filename = eventStore2.getNdkFilename(payload, apiKey);
            if (isLaunching) {
                filename = filename.replace(".json", "startupcrash.json");
            }
            eventStore2.enqueueContentForDelivery(payload, filename);
        }
    }

    public static void notify(@NonNull byte[] nameBytes, @NonNull byte[] messageBytes, @NonNull Severity severity, @NonNull StackTraceElement[] stacktrace) {
        if (nameBytes == null || messageBytes == null || stacktrace == null) {
            return;
        }
        String name = new String(nameBytes, UTF8Charset);
        String message = new String(messageBytes, UTF8Charset);
        NativeInterface.notify(name, message, severity, stacktrace);
    }

    public static void notify(final @NonNull String name, final @NonNull String message, final @NonNull Severity severity, @NonNull StackTraceElement[] stacktrace) {
        if (NativeInterface.getClient().getConfig().shouldDiscardError(name)) {
            return;
        }
        RuntimeException exc = new RuntimeException();
        exc.setStackTrace(stacktrace);
        NativeInterface.getClient().notify(exc, new OnErrorCallback(){

            @Override
            public boolean onError(@NonNull Event event) {
                event.updateSeverityInternal(severity);
                List<Error> errors = event.getErrors();
                Error error = event.getErrors().get(0);
                if (!errors.isEmpty()) {
                    error.setErrorClass(name);
                    error.setErrorMessage(message);
                    for (Error err : errors) {
                        err.setType(ErrorType.C);
                    }
                }
                return true;
            }
        });
    }

    @NonNull
    public static Event createEvent(@Nullable Throwable exc, @NonNull Client client, @NonNull SeverityReason severityReason) {
        Metadata metadata = client.getMetadataState().getMetadata();
        return new Event(exc, client.getConfig(), severityReason, metadata, client.logger);
    }

    @NonNull
    public static Logger getLogger() {
        return NativeInterface.getClient().getConfig().getLogger();
    }

    public static void setAutoNotify(boolean autoNotify) {
        NativeInterface.getClient().setAutoNotify(autoNotify);
    }

    public static void setAutoDetectAnrs(boolean autoDetectAnrs) {
        NativeInterface.getClient().setAutoDetectAnrs(autoDetectAnrs);
    }
}

