/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import com.bugsnag.android.Client;
import com.bugsnag.android.OnErrorCallback;
import java.util.concurrent.atomic.AtomicBoolean;

class LibraryLoader {
    private final AtomicBoolean attemptedLoad = new AtomicBoolean();
    private boolean loaded = false;

    LibraryLoader() {
    }

    boolean loadLibrary(String name, Client client, OnErrorCallback callback) {
        if (!this.attemptedLoad.getAndSet(true)) {
            try {
                System.loadLibrary(name);
                this.loaded = true;
                return true;
            }
            catch (UnsatisfiedLinkError error) {
                client.notify(error, callback);
            }
        }
        return false;
    }

    boolean isLoaded() {
        return this.loaded;
    }
}

