/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.VisibleForTesting;
import com.bugsnag.android.BackgroundTaskService$WhenMappings;
import com.bugsnag.android.BackgroundTaskServiceKt;
import com.bugsnag.android.TaskType;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B7\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u001a\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J(\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0012\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0019J\f\u0010\u001a\u001a\u00020\u0010*\u00020\u0003H\u0002R\u0014\u0010\u0007\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/bugsnag/android/BackgroundTaskService;", "", "errorExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "sessionExecutor", "ioExecutor", "internalReportExecutor", "defaultExecutor", "(Ljava/util/concurrent/ThreadPoolExecutor;Ljava/util/concurrent/ThreadPoolExecutor;Ljava/util/concurrent/ThreadPoolExecutor;Ljava/util/concurrent/ThreadPoolExecutor;Ljava/util/concurrent/ThreadPoolExecutor;)V", "getDefaultExecutor$bugsnag_android_core_release", "()Ljava/util/concurrent/ThreadPoolExecutor;", "getErrorExecutor$bugsnag_android_core_release", "getInternalReportExecutor$bugsnag_android_core_release", "getIoExecutor$bugsnag_android_core_release", "getSessionExecutor$bugsnag_android_core_release", "shutdown", "", "submitTask", "Ljava/util/concurrent/Future;", "taskType", "Lcom/bugsnag/android/TaskType;", "runnable", "Ljava/lang/Runnable;", "T", "callable", "Ljava/util/concurrent/Callable;", "awaitTerminationSafe", "bugsnag-android-core_release"})
public final class BackgroundTaskService {
    @NotNull
    private final ThreadPoolExecutor errorExecutor;
    @NotNull
    private final ThreadPoolExecutor sessionExecutor;
    @NotNull
    private final ThreadPoolExecutor ioExecutor;
    @NotNull
    private final ThreadPoolExecutor internalReportExecutor;
    @NotNull
    private final ThreadPoolExecutor defaultExecutor;

    @NotNull
    public final Future<?> submitTask(@NotNull TaskType taskType, @NotNull Runnable runnable) throws RejectedExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)taskType), (String)"taskType");
        Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
        Callable<Object> callable = Executors.callable(runnable);
        Intrinsics.checkExpressionValueIsNotNull(callable, (String)"Executors.callable(runnable)");
        return this.submitTask(taskType, callable);
    }

    @NotNull
    public final <T> Future<T> submitTask(@NotNull TaskType taskType, @NotNull Callable<T> callable) throws RejectedExecutionException {
        Future<T> future;
        Intrinsics.checkParameterIsNotNull((Object)((Object)taskType), (String)"taskType");
        Intrinsics.checkParameterIsNotNull(callable, (String)"callable");
        switch (BackgroundTaskService$WhenMappings.$EnumSwitchMapping$0[taskType.ordinal()]) {
            case 1: {
                Future<T> future2 = this.errorExecutor.submit(callable);
                future = future2;
                Intrinsics.checkExpressionValueIsNotNull(future2, (String)"errorExecutor.submit(callable)");
                break;
            }
            case 2: {
                Future<T> future3 = this.sessionExecutor.submit(callable);
                future = future3;
                Intrinsics.checkExpressionValueIsNotNull(future3, (String)"sessionExecutor.submit(callable)");
                break;
            }
            case 3: {
                Future<T> future4 = this.ioExecutor.submit(callable);
                future = future4;
                Intrinsics.checkExpressionValueIsNotNull(future4, (String)"ioExecutor.submit(callable)");
                break;
            }
            case 4: {
                Future<T> future5 = this.internalReportExecutor.submit(callable);
                future = future5;
                Intrinsics.checkExpressionValueIsNotNull(future5, (String)"internalReportExecutor.submit(callable)");
                break;
            }
            case 5: {
                Future<T> future6 = this.defaultExecutor.submit(callable);
                future = future6;
                Intrinsics.checkExpressionValueIsNotNull(future6, (String)"defaultExecutor.submit(callable)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return future;
    }

    public final void shutdown() {
        this.internalReportExecutor.shutdownNow();
        this.defaultExecutor.shutdownNow();
        this.errorExecutor.shutdown();
        this.sessionExecutor.shutdown();
        this.awaitTerminationSafe(this.errorExecutor);
        this.awaitTerminationSafe(this.sessionExecutor);
        this.ioExecutor.shutdown();
        this.awaitTerminationSafe(this.ioExecutor);
    }

    private final void awaitTerminationSafe(@NotNull ThreadPoolExecutor $this$awaitTerminationSafe) {
        try {
            $this$awaitTerminationSafe.awaitTermination(1500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @NotNull
    public final ThreadPoolExecutor getErrorExecutor$bugsnag_android_core_release() {
        return this.errorExecutor;
    }

    @NotNull
    public final ThreadPoolExecutor getSessionExecutor$bugsnag_android_core_release() {
        return this.sessionExecutor;
    }

    @NotNull
    public final ThreadPoolExecutor getIoExecutor$bugsnag_android_core_release() {
        return this.ioExecutor;
    }

    @NotNull
    public final ThreadPoolExecutor getInternalReportExecutor$bugsnag_android_core_release() {
        return this.internalReportExecutor;
    }

    @NotNull
    public final ThreadPoolExecutor getDefaultExecutor$bugsnag_android_core_release() {
        return this.defaultExecutor;
    }

    public BackgroundTaskService(@VisibleForTesting @NotNull ThreadPoolExecutor errorExecutor, @VisibleForTesting @NotNull ThreadPoolExecutor sessionExecutor, @VisibleForTesting @NotNull ThreadPoolExecutor ioExecutor, @VisibleForTesting @NotNull ThreadPoolExecutor internalReportExecutor, @VisibleForTesting @NotNull ThreadPoolExecutor defaultExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)errorExecutor, (String)"errorExecutor");
        Intrinsics.checkParameterIsNotNull((Object)sessionExecutor, (String)"sessionExecutor");
        Intrinsics.checkParameterIsNotNull((Object)ioExecutor, (String)"ioExecutor");
        Intrinsics.checkParameterIsNotNull((Object)internalReportExecutor, (String)"internalReportExecutor");
        Intrinsics.checkParameterIsNotNull((Object)defaultExecutor, (String)"defaultExecutor");
        this.errorExecutor = errorExecutor;
        this.sessionExecutor = sessionExecutor;
        this.ioExecutor = ioExecutor;
        this.internalReportExecutor = internalReportExecutor;
        this.defaultExecutor = defaultExecutor;
    }

    public /* synthetic */ BackgroundTaskService(ThreadPoolExecutor threadPoolExecutor, ThreadPoolExecutor threadPoolExecutor2, ThreadPoolExecutor threadPoolExecutor3, ThreadPoolExecutor threadPoolExecutor4, ThreadPoolExecutor threadPoolExecutor5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            threadPoolExecutor = BackgroundTaskServiceKt.createExecutor("Bugsnag Error thread", true);
        }
        if ((n & 2) != 0) {
            threadPoolExecutor2 = BackgroundTaskServiceKt.createExecutor("Bugsnag Session thread", true);
        }
        if ((n & 4) != 0) {
            threadPoolExecutor3 = BackgroundTaskServiceKt.createExecutor("Bugsnag IO thread", true);
        }
        if ((n & 8) != 0) {
            threadPoolExecutor4 = BackgroundTaskServiceKt.createExecutor("Bugsnag Internal Report thread", false);
        }
        if ((n & 0x10) != 0) {
            threadPoolExecutor5 = BackgroundTaskServiceKt.createExecutor("Bugsnag Default thread", false);
        }
        this(threadPoolExecutor, threadPoolExecutor2, threadPoolExecutor3, threadPoolExecutor4, threadPoolExecutor5);
    }

    public BackgroundTaskService() {
        this(null, null, null, null, null, 31, null);
    }
}

