/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import android.os.Build;
import android.os.storage.StorageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.AppDataCollector;
import com.bugsnag.android.BackgroundTaskService;
import com.bugsnag.android.DefaultDelivery;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.DeliveryParams;
import com.bugsnag.android.DeviceDataCollector;
import com.bugsnag.android.Event;
import com.bugsnag.android.EventPayload;
import com.bugsnag.android.FileStore;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Notifier;
import com.bugsnag.android.SessionTracker;
import com.bugsnag.android.SeverityReason;
import com.bugsnag.android.TaskType;
import com.bugsnag.android.internal.ImmutableConfig;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;

class InternalReportDelegate
implements FileStore.Delegate {
    static final String INTERNAL_DIAGNOSTICS_TAB = "BugsnagDiagnostics";
    final Logger logger;
    final ImmutableConfig config;
    @Nullable
    final StorageManager storageManager;
    final AppDataCollector appDataCollector;
    final DeviceDataCollector deviceDataCollector;
    final Context appContext;
    final SessionTracker sessionTracker;
    final Notifier notifier;
    final BackgroundTaskService backgroundTaskService;

    InternalReportDelegate(Context context, Logger logger, ImmutableConfig immutableConfig, @Nullable StorageManager storageManager, AppDataCollector appDataCollector, DeviceDataCollector deviceDataCollector, SessionTracker sessionTracker, Notifier notifier, BackgroundTaskService backgroundTaskService) {
        this.logger = logger;
        this.config = immutableConfig;
        this.storageManager = storageManager;
        this.appDataCollector = appDataCollector;
        this.deviceDataCollector = deviceDataCollector;
        this.appContext = context;
        this.sessionTracker = sessionTracker;
        this.notifier = notifier;
        this.backgroundTaskService = backgroundTaskService;
    }

    @Override
    public void onErrorIOFailure(Exception exc, File errorFile, String context) {
        SeverityReason severityReason = SeverityReason.newInstance("unhandledException");
        Event err = new Event(exc, this.config, severityReason, this.logger);
        err.setContext(context);
        err.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "canRead", errorFile.canRead());
        err.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "canWrite", errorFile.canWrite());
        err.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "exists", errorFile.exists());
        long usableSpace = this.appContext.getCacheDir().getUsableSpace();
        err.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "usableSpace", usableSpace);
        err.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "filename", errorFile.getName());
        err.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "fileLength", errorFile.length());
        this.recordStorageCacheBehavior(err);
        this.reportInternalBugsnagError(err);
    }

    void recordStorageCacheBehavior(Event event) {
        if (this.storageManager != null && Build.VERSION.SDK_INT >= 26) {
            File cacheDir = this.appContext.getCacheDir();
            File errDir = new File(cacheDir, "bugsnag-errors");
            try {
                boolean tombstone = this.storageManager.isCacheBehaviorTombstone(errDir);
                boolean group = this.storageManager.isCacheBehaviorGroup(errDir);
                event.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "cacheTombstone", tombstone);
                event.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "cacheGroup", group);
            }
            catch (IOException exc) {
                this.logger.w("Failed to record cache behaviour, skipping diagnostics", exc);
            }
        }
    }

    void reportInternalBugsnagError(@NonNull Event event) {
        event.setApp(this.appDataCollector.generateAppWithState());
        event.setDevice(this.deviceDataCollector.generateDeviceWithState(new Date().getTime()));
        event.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "notifierName", this.notifier.getName());
        event.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "notifierVersion", this.notifier.getVersion());
        event.addMetadata(INTERNAL_DIAGNOSTICS_TAB, "apiKey", this.config.getApiKey());
        final EventPayload payload = new EventPayload(null, event, this.notifier, this.config);
        try {
            this.backgroundTaskService.submitTask(TaskType.INTERNAL_REPORT, new Runnable(){

                @Override
                public void run() {
                    try {
                        InternalReportDelegate.this.logger.d("InternalReportDelegate - sending internal event");
                        Delivery delivery = InternalReportDelegate.this.config.getDelivery();
                        DeliveryParams params = InternalReportDelegate.this.config.getErrorApiDeliveryParams(payload);
                        if (delivery instanceof DefaultDelivery) {
                            Map<String, String> headers = params.getHeaders();
                            headers.put("Bugsnag-Internal-Error", "bugsnag-android");
                            headers.remove("Bugsnag-Api-Key");
                            DefaultDelivery defaultDelivery = (DefaultDelivery)delivery;
                            defaultDelivery.deliver(params.getEndpoint(), payload, headers);
                        }
                    }
                    catch (Exception exception) {
                        InternalReportDelegate.this.logger.w("Failed to report internal event to Bugsnag", exception);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }
}

