/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.provider.Settings;
import android.util.DisplayMetrics;
import com.bugsnag.android.Connectivity;
import com.bugsnag.android.Device;
import com.bugsnag.android.DeviceBuildInfo;
import com.bugsnag.android.DeviceWithState;
import com.bugsnag.android.Logger;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\f\b\u0000\u0018\u0000 <2\u00020\u0001:\u0001<B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010!\u001a\u00020\"H\u0007J\b\u0010#\u001a\u00020\"H\u0002J\u000f\u0010$\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020\"H\u0002J\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\"J\u000f\u0010,\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010-J\u0011\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\u0012\u00a2\u0006\u0002\u0010/J\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u000101J\n\u00102\u001a\u0004\u0018\u00010\tH\u0002J\b\u00103\u001a\u00020\tH\u0002J\u000f\u00104\u001a\u0004\u0018\u00010\u001eH\u0002\u00a2\u0006\u0002\u0010-J\u000f\u00105\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u00106J\n\u00107\u001a\u0004\u0018\u00010\tH\u0002J\u000f\u00108\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u00109J\b\u0010:\u001a\u00020\u001aH\u0002J\b\u0010;\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/bugsnag/android/DeviceDataCollector;", "", "connectivity", "Lcom/bugsnag/android/Connectivity;", "appContext", "Landroid/content/Context;", "resources", "Landroid/content/res/Resources;", "installId", "", "buildInfo", "Lcom/bugsnag/android/DeviceBuildInfo;", "dataDirectory", "Ljava/io/File;", "logger", "Lcom/bugsnag/android/Logger;", "(Lcom/bugsnag/android/Connectivity;Landroid/content/Context;Landroid/content/res/Resources;Ljava/lang/String;Lcom/bugsnag/android/DeviceBuildInfo;Ljava/io/File;Lcom/bugsnag/android/Logger;)V", "cpuAbi", "", "[Ljava/lang/String;", "displayMetrics", "Landroid/util/DisplayMetrics;", "dpi", "", "Ljava/lang/Integer;", "emulator", "", "locale", "rooted", "screenDensity", "", "Ljava/lang/Float;", "screenResolution", "calculateFreeDisk", "", "calculateFreeMemory", "calculateOrientation", "calculateOrientation$bugsnag_android_core_release", "calculateTotalMemory", "generateDevice", "Lcom/bugsnag/android/Device;", "generateDeviceWithState", "Lcom/bugsnag/android/DeviceWithState;", "now", "getBatteryLevel", "()Ljava/lang/Float;", "getCpuAbi", "()[Ljava/lang/String;", "getDeviceMetadata", "", "getLocationStatus", "getNetworkAccess", "getScreenDensity", "getScreenDensityDpi", "()Ljava/lang/Integer;", "getScreenResolution", "isCharging", "()Ljava/lang/Boolean;", "isEmulator", "isRooted", "Companion", "bugsnag-android-core_release"})
public final class DeviceDataCollector {
    private final DisplayMetrics displayMetrics;
    private final boolean emulator;
    private final boolean rooted;
    private final Float screenDensity;
    private final Integer dpi;
    private final String screenResolution;
    private final String locale;
    private final String[] cpuAbi;
    private final Connectivity connectivity;
    private final Context appContext;
    private final Resources resources;
    private final String installId;
    private final DeviceBuildInfo buildInfo;
    private final File dataDirectory;
    private final Logger logger;
    private static final String[] ROOT_INDICATORS;
    public static final Companion Companion;

    @NotNull
    public final Device generateDevice() {
        return new Device(this.buildInfo, this.cpuAbi, this.rooted, this.installId, this.locale, this.calculateTotalMemory());
    }

    @NotNull
    public final DeviceWithState generateDeviceWithState(long now) {
        return new DeviceWithState(this.buildInfo, this.rooted, this.installId, this.locale, this.calculateTotalMemory(), this.calculateFreeMemory(), this.calculateFreeDisk(), this.calculateOrientation$bugsnag_android_core_release(), new Date(now));
    }

    @NotNull
    public final Map<String, Object> getDeviceMetadata() {
        HashMap map = new HashMap();
        ((Map)map).put("batteryLevel", this.getBatteryLevel());
        ((Map)map).put("charging", this.isCharging());
        ((Map)map).put("locationStatus", this.getLocationStatus());
        ((Map)map).put("networkAccess", this.getNetworkAccess());
        ((Map)map).put("brand", this.buildInfo.getBrand());
        ((Map)map).put("screenDensity", this.screenDensity);
        ((Map)map).put("dpi", this.dpi);
        ((Map)map).put("emulator", this.emulator);
        ((Map)map).put("screenResolution", this.screenResolution);
        return map;
    }

    private final boolean isRooted() {
        String tags = this.buildInfo.getTags();
        if (tags != null && StringsKt.contains$default((CharSequence)tags, (CharSequence)"test-keys", (boolean)false, (int)2, null)) {
            return true;
        }
        DeviceDataCollector deviceDataCollector = this;
        boolean bl = false;
        try {
            Object object = Result.Companion;
            DeviceDataCollector $this$runCatching = deviceDataCollector;
            boolean bl2 = false;
            for (String candidate : ROOT_INDICATORS) {
                if (!new File(candidate).exists()) continue;
                return true;
            }
            Unit unit = Unit.INSTANCE;
            boolean bl3 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return false;
    }

    private final boolean isEmulator() {
        String fingerprint = this.buildInfo.getFingerprint();
        return fingerprint != null && (StringsKt.startsWith$default((String)fingerprint, (String)"unknown", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fingerprint, (CharSequence)"generic", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fingerprint, (CharSequence)"vbox", (boolean)false, (int)2, null));
    }

    private final Integer getScreenDensityDpi() {
        DisplayMetrics displayMetrics = this.displayMetrics;
        return displayMetrics != null ? Integer.valueOf(displayMetrics.densityDpi) : null;
    }

    private final Float getBatteryLevel() {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = this.appContext.registerReceiver(null, ifilter);
            if (batteryStatus != null) {
                return Float.valueOf((float)batteryStatus.getIntExtra("level", -1) / (float)batteryStatus.getIntExtra("scale", -1));
            }
        }
        catch (Exception exception) {
            this.logger.w("Could not get batteryLevel");
        }
        return null;
    }

    private final Boolean isCharging() {
        try {
            IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent batteryStatus = this.appContext.registerReceiver(null, ifilter);
            if (batteryStatus != null) {
                int status = batteryStatus.getIntExtra("status", -1);
                return status == 2 || status == 5;
            }
        }
        catch (Exception exception) {
            this.logger.w("Could not get charging status");
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getLocationStatus() {
        try {
            ContentResolver cr = this.appContext.getContentResolver();
            String providersAllowed = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            if (providersAllowed == null) return "disallowed";
            CharSequence charSequence = providersAllowed;
            boolean bl = false;
            if (charSequence.length() <= 0) return "disallowed";
            return "allowed";
        }
        catch (Exception exception) {
            this.logger.w("Could not get locationStatus");
            return null;
        }
    }

    private final String getNetworkAccess() {
        return this.connectivity.retrieveNetworkAccessState();
    }

    private final Float getScreenDensity() {
        DisplayMetrics displayMetrics = this.displayMetrics;
        return displayMetrics != null ? Float.valueOf(displayMetrics.density) : null;
    }

    private final String getScreenResolution() {
        String string;
        if (this.displayMetrics != null) {
            int n = this.displayMetrics.widthPixels;
            int n2 = this.displayMetrics.heightPixels;
            int n3 = 0;
            int max = Math.max(n, n2);
            n2 = this.displayMetrics.widthPixels;
            n3 = this.displayMetrics.heightPixels;
            boolean bl = false;
            int min = Math.min(n2, n3);
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string2 = "%dx%d";
            Object[] objectArray = new Object[]{max, min};
            boolean bl2 = false;
            String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String[] getCpuAbi() {
        String[] stringArray = this.buildInfo.getCpuAbis();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    @SuppressLint(value={"UsableSpace"})
    public final long calculateFreeDisk() {
        return this.dataDirectory.getUsableSpace();
    }

    private final long calculateFreeMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        return maxMemory != Long.MAX_VALUE ? maxMemory - runtime.totalMemory() + runtime.freeMemory() : runtime.freeMemory();
    }

    private final long calculateTotalMemory() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        return maxMemory != Long.MAX_VALUE ? maxMemory : runtime.totalMemory();
    }

    @Nullable
    public final String calculateOrientation$bugsnag_android_core_release() {
        String string;
        Integer n;
        Resources resources = this.resources;
        Integer n2 = n = resources != null && (resources = resources.getConfiguration()) != null ? Integer.valueOf(resources.orientation) : null;
        int n3 = 2;
        if (n2 != null && n2 == n3) {
            string = "landscape";
        } else {
            Integer n4 = n;
            n3 = 1;
            string = n4 != null && n4 == n3 ? "portrait" : null;
        }
        return string;
    }

    public DeviceDataCollector(@NotNull Connectivity connectivity, @NotNull Context appContext, @Nullable Resources resources, @NotNull String installId, @NotNull DeviceBuildInfo buildInfo, @NotNull File dataDirectory, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)connectivity, (String)"connectivity");
        Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
        Intrinsics.checkParameterIsNotNull((Object)installId, (String)"installId");
        Intrinsics.checkParameterIsNotNull((Object)buildInfo, (String)"buildInfo");
        Intrinsics.checkParameterIsNotNull((Object)dataDirectory, (String)"dataDirectory");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.connectivity = connectivity;
        this.appContext = appContext;
        this.resources = resources;
        this.installId = installId;
        this.buildInfo = buildInfo;
        this.dataDirectory = dataDirectory;
        this.logger = logger;
        Resources resources2 = this.resources;
        this.displayMetrics = resources2 != null ? resources2.getDisplayMetrics() : null;
        this.emulator = this.isEmulator();
        this.rooted = this.isRooted();
        this.screenDensity = this.getScreenDensity();
        this.dpi = this.getScreenDensityDpi();
        this.screenResolution = this.getScreenResolution();
        String string = Locale.getDefault().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Locale.getDefault().toString()");
        this.locale = string;
        this.cpuAbi = this.getCpuAbi();
    }

    static {
        Companion = new Companion(null);
        ROOT_INDICATORS = new String[]{"/system/xbin/su", "/system/bin/su", "/system/app/Superuser.apk", "/system/app/SuperSU.apk", "/system/app/Superuser", "/system/app/SuperSU", "/system/xbin/daemonsu", "/su/bin"};
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/bugsnag/android/DeviceDataCollector$Companion;", "", "()V", "ROOT_INDICATORS", "", "", "[Ljava/lang/String;", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

