/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.util.JsonReader;
import androidx.annotation.NonNull;
import com.bugsnag.android.Breadcrumb;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Breadcrumbs;
import com.bugsnag.android.BugsnagException;
import com.bugsnag.android.CachedThread;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.DateUtils;
import com.bugsnag.android.Error;
import com.bugsnag.android.Exceptions;
import com.bugsnag.android.HandledState;
import com.bugsnag.android.Logger;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Session;
import com.bugsnag.android.Severity;
import com.bugsnag.android.ThreadState;
import com.bugsnag.android.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class ErrorReader {
    ErrorReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Error readError(@NonNull Configuration config, @NonNull File errorFile) throws IOException {
        JsonReader reader = null;
        try {
            User user = null;
            Exceptions exceptions = null;
            Severity severity = Severity.ERROR;
            Session session = null;
            String context = null;
            String groupingHash = null;
            Map<String, Object> appData = null;
            Map<String, Object> deviceData = null;
            MetaData metaData = null;
            ThreadState threadState = null;
            Breadcrumbs crumbs = null;
            ArrayList<String> severityReasonValues = null;
            List<String> projectPackages = Collections.emptyList();
            boolean unhandled = false;
            reader = new JsonReader((Reader)new BufferedReader(new FileReader(errorFile)));
            reader.beginObject();
            block39: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "app": {
                        appData = ErrorReader.jsonObjectToMap(reader);
                        continue block39;
                    }
                    case "breadcrumbs": {
                        crumbs = ErrorReader.readBreadcrumbs(config, reader);
                        continue block39;
                    }
                    case "context": {
                        context = reader.nextString();
                        continue block39;
                    }
                    case "device": {
                        deviceData = ErrorReader.jsonObjectToMap(reader);
                        continue block39;
                    }
                    case "projectPackages": {
                        projectPackages = ErrorReader.jsonArrayToList(reader);
                        continue block39;
                    }
                    case "exceptions": {
                        exceptions = ErrorReader.readExceptions(config, reader);
                        continue block39;
                    }
                    case "groupingHash": {
                        groupingHash = reader.nextString();
                        continue block39;
                    }
                    case "metaData": {
                        metaData = new MetaData(ErrorReader.jsonObjectToMap(reader));
                        continue block39;
                    }
                    case "session": {
                        session = ErrorReader.readSession(reader);
                        continue block39;
                    }
                    case "severity": {
                        severity = Severity.fromString(reader.nextString());
                        continue block39;
                    }
                    case "severityReason": {
                        severityReasonValues = ErrorReader.readSeverityReason(reader);
                        continue block39;
                    }
                    case "threads": {
                        threadState = ErrorReader.readThreadState(reader);
                        continue block39;
                    }
                    case "unhandled": {
                        unhandled = reader.nextBoolean();
                        continue block39;
                    }
                    case "user": {
                        user = ErrorReader.readUser(reader);
                        continue block39;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (severityReasonValues == null || exceptions == null) {
                throw new IOException("File did not contain a valid error");
            }
            String severityReasonAttribute = severityReasonValues.size() > 1 ? severityReasonValues.get(1) : null;
            HandledState handledState = new HandledState(severityReasonValues.get(0), severity, unhandled, severityReasonAttribute);
            Error error = new Error(config, exceptions.getException(), handledState, severity, session, threadState);
            error.getExceptions().setExceptionType(exceptions.getExceptionType());
            error.setProjectPackages(projectPackages.toArray(new String[0]));
            error.setUser(user);
            error.setContext(context);
            error.setGroupingHash(groupingHash);
            error.setAppData(appData);
            error.setMetaData(metaData);
            error.setDeviceData(deviceData);
            error.setBreadcrumbs(crumbs);
            Error error2 = error;
            return error2;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Breadcrumbs readBreadcrumbs(Configuration config, JsonReader reader) throws IOException {
        Breadcrumbs crumbs = new Breadcrumbs(config);
        reader.beginArray();
        while (reader.hasNext()) {
            Breadcrumb breadcrumb = ErrorReader.readBreadcrumb(reader);
            if (breadcrumb == null) continue;
            crumbs.add(breadcrumb);
        }
        reader.endArray();
        return crumbs;
    }

    private static Breadcrumb readBreadcrumb(JsonReader reader) throws IOException {
        String name = null;
        String type = null;
        HashMap<String, String> metadata = new HashMap<String, String>();
        Date captureDate = null;
        reader.beginObject();
        block14: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "name": {
                    name = reader.nextString();
                    continue block14;
                }
                case "timestamp": {
                    try {
                        captureDate = DateUtils.fromIso8601(reader.nextString());
                        continue block14;
                    }
                    catch (Exception ex) {
                        throw new IOException("Failed to parse breadcrumb timestamp: ", ex);
                    }
                }
                case "type": {
                    type = reader.nextString().toUpperCase(Locale.US);
                    continue block14;
                }
                case "metaData": {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        metadata.put(reader.nextName(), reader.nextString());
                    }
                    reader.endObject();
                    continue block14;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (name != null && captureDate != null && type != null) {
            return new Breadcrumb(name, BreadcrumbType.valueOf(type), captureDate, metadata);
        }
        return null;
    }

    private static Exceptions readExceptions(Configuration config, JsonReader reader) throws IOException {
        BugsnagException root;
        reader.beginArray();
        BugsnagException ref = root = ErrorReader.readException(reader);
        while (reader.hasNext()) {
            BugsnagException exc = ErrorReader.readException(reader);
            ref.initCause(exc);
            ref = exc;
        }
        reader.endArray();
        Exceptions ex = new Exceptions(config, root);
        if (root != null) {
            ex.setExceptionType(root.getType());
        }
        return ex;
    }

    private static BugsnagException readException(JsonReader reader) throws IOException {
        reader.beginObject();
        String errorClass = null;
        String message = null;
        String type = "android";
        List<Map<String, Object>> frames = new ArrayList<Map<String, Object>>();
        block12: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "errorClass": {
                    errorClass = reader.nextString();
                    continue block12;
                }
                case "message": {
                    message = reader.nextString();
                    continue block12;
                }
                case "stacktrace": {
                    frames = ErrorReader.readStackFrames(reader);
                    continue block12;
                }
                case "type": {
                    type = reader.nextString();
                    continue block12;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        BugsnagException bugsnagException = new BugsnagException(errorClass, message, frames);
        bugsnagException.setType(type);
        return bugsnagException;
    }

    private static List<Map<String, Object>> readStackFrames(JsonReader reader) throws IOException {
        ArrayList<Map<String, Object>> frames = new ArrayList<Map<String, Object>>();
        reader.beginArray();
        while (reader.hasNext()) {
            frames.add(ErrorReader.readStackFrame(reader));
        }
        reader.endArray();
        return frames;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> readStackFrame(JsonReader reader) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        reader.beginObject();
        try {
            block6: while (reader.hasNext()) {
                String key = reader.nextName();
                switch (reader.peek()) {
                    case STRING: {
                        map.put(key, reader.nextString());
                        continue block6;
                    }
                    case NUMBER: {
                        map.put(key, ErrorReader.deserializeNumber(reader));
                        continue block6;
                    }
                }
                reader.skipValue();
            }
        }
        catch (IllegalStateException exc) {
            Logger.warn("Failed to read stackframe", exc);
        }
        reader.endObject();
        return map;
    }

    private static ArrayList<String> readSeverityReason(JsonReader reader) throws IOException {
        reader.beginObject();
        String type = null;
        String attributeValue = null;
        block8: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "type": {
                    type = reader.nextString();
                    continue block8;
                }
                case "attributes": {
                    reader.beginObject();
                    reader.nextName();
                    attributeValue = reader.nextString();
                    reader.endObject();
                    continue block8;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        ArrayList<String> values = new ArrayList<String>();
        if (type == null) {
            throw new IOException("Severity Reason type is required");
        }
        values.add(type);
        if (attributeValue != null) {
            values.add(attributeValue);
        }
        return values;
    }

    private static Session readSession(JsonReader reader) throws IOException {
        String id = null;
        Date startedAt = null;
        int unhandled = 0;
        int handled = 0;
        User user = null;
        reader.beginObject();
        block22: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "id": {
                    id = reader.nextString();
                    continue block22;
                }
                case "startedAt": {
                    try {
                        startedAt = DateUtils.fromIso8601(reader.nextString());
                        continue block22;
                    }
                    catch (Exception ex) {
                        throw new IOException("Unable to parse session startedAt: ", ex);
                    }
                }
                case "events": {
                    reader.beginObject();
                    block23: while (reader.hasNext()) {
                        switch (reader.nextName()) {
                            case "unhandled": {
                                unhandled = reader.nextInt();
                                continue block23;
                            }
                            case "handled": {
                                handled = reader.nextInt();
                                continue block23;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block22;
                }
                case "user": {
                    user = ErrorReader.readUser(reader);
                    continue block22;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (id != null && startedAt != null) {
            return new Session(id, startedAt, user, unhandled, handled);
        }
        throw new IOException("Session data missing required fields");
    }

    private static User readUser(JsonReader reader) throws IOException {
        User user = new User();
        reader.beginObject();
        block10: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "name": {
                    user.setName(reader.nextString());
                    continue block10;
                }
                case "id": {
                    user.setId(reader.nextString());
                    continue block10;
                }
                case "email": {
                    user.setEmail(reader.nextString());
                    continue block10;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return user;
    }

    private static ThreadState readThreadState(JsonReader reader) throws IOException {
        ArrayList<CachedThread> threads = new ArrayList<CachedThread>();
        reader.beginArray();
        while (reader.hasNext()) {
            CachedThread cachedThread = ErrorReader.readThread(reader);
            if (cachedThread == null) continue;
            threads.add(cachedThread);
        }
        reader.endArray();
        return new ThreadState(threads.toArray(new CachedThread[0]));
    }

    private static CachedThread readThread(JsonReader reader) throws IOException {
        long id = 0L;
        String name = null;
        String type = null;
        boolean errorReportingThread = false;
        List<Map<String, Object>> frames = null;
        reader.beginObject();
        block14: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "id": {
                    id = reader.nextLong();
                    continue block14;
                }
                case "name": {
                    name = reader.nextString();
                    continue block14;
                }
                case "type": {
                    type = reader.nextString();
                    continue block14;
                }
                case "stacktrace": {
                    frames = ErrorReader.readStackFrames(reader);
                    continue block14;
                }
                case "errorReportingThread": {
                    errorReportingThread = reader.nextBoolean();
                    continue block14;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (type != null && frames != null) {
            return new CachedThread(id, name, type, errorReportingThread, frames);
        }
        return null;
    }

    private static Map<String, Object> jsonObjectToMap(JsonReader reader) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        reader.beginObject();
        while (reader.hasNext()) {
            String key = reader.nextName();
            Object value = ErrorReader.coerceSerializableFromJSON(reader);
            if (value == null) continue;
            data.put(key, value);
        }
        reader.endObject();
        return data;
    }

    private static <T> List<T> jsonArrayToList(JsonReader reader) throws IOException {
        ArrayList<T> objects = new ArrayList<T>();
        reader.beginArray();
        while (reader.hasNext()) {
            T value = ErrorReader.coerceSerializableFromJSON(reader);
            if (value == null) continue;
            objects.add(value);
        }
        reader.endArray();
        return objects;
    }

    private static <T> T coerceSerializableFromJSON(JsonReader reader) throws IOException {
        switch (reader.peek()) {
            case BEGIN_OBJECT: {
                return (T)ErrorReader.jsonObjectToMap(reader);
            }
            case STRING: {
                return (T)reader.nextString();
            }
            case BOOLEAN: {
                return (T)Boolean.valueOf(reader.nextBoolean());
            }
            case NUMBER: {
                return ErrorReader.deserializeNumber(reader);
            }
            case BEGIN_ARRAY: {
                return (T)ErrorReader.jsonArrayToList(reader);
            }
        }
        return null;
    }

    private static <T> T deserializeNumber(JsonReader reader) throws IOException {
        try {
            return (T)Integer.valueOf(reader.nextInt());
        }
        catch (NumberFormatException ex) {
            try {
                return (T)Long.valueOf(reader.nextLong());
            }
            catch (NumberFormatException ex2) {
                return (T)Double.valueOf(reader.nextDouble());
            }
        }
    }
}

