/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Delivery;
import com.bugsnag.android.DeliveryFailureException;
import com.bugsnag.android.ErrorReportApiClient;
import com.bugsnag.android.Logger;
import com.bugsnag.android.NetworkException;
import com.bugsnag.android.Report;
import com.bugsnag.android.SessionTrackingApiClient;
import com.bugsnag.android.SessionTrackingPayload;
import com.bugsnag.android.ThreadSafe;

@ThreadSafe
class DeliveryCompat
implements Delivery {
    volatile ErrorReportApiClient errorReportApiClient;
    volatile SessionTrackingApiClient sessionTrackingApiClient;

    DeliveryCompat() {
    }

    @Override
    public void deliver(@NonNull SessionTrackingPayload payload, @NonNull Configuration config) throws DeliveryFailureException {
        if (this.sessionTrackingApiClient != null) {
            try {
                this.sessionTrackingApiClient.postSessionTrackingPayload(config.getSessionEndpoint(), payload, config.getSessionApiHeaders());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
    }

    @Override
    public void deliver(@NonNull Report report, @NonNull Configuration config) throws DeliveryFailureException {
        if (this.errorReportApiClient != null) {
            try {
                this.errorReportApiClient.postReport(config.getEndpoint(), report, config.getErrorApiHeaders());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
    }

    void handleException(Throwable throwable) throws DeliveryFailureException {
        if (throwable instanceof NetworkException) {
            throw new DeliveryFailureException(throwable.getMessage(), throwable);
        }
        Logger.warn("Ignoring Exception, this API is deprecated", throwable);
    }
}

