/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class Stacktrace
implements JsonStream.Streamable {
    private static final int STACKTRACE_TRIM_LENGTH = 200;
    private final List<String> projectPackages;
    final StackTraceElement[] stacktrace;

    Stacktrace(StackTraceElement[] stacktrace, String[] projectPackages) {
        this.stacktrace = stacktrace;
        this.projectPackages = Stacktrace.sanitiseProjectPackages(projectPackages);
    }

    @Override
    public void toStream(@NonNull JsonStream writer) throws IOException {
        writer.beginArray();
        for (int k = 0; k < this.stacktrace.length && k < 200; ++k) {
            StackTraceElement el = this.stacktrace[k];
            try {
                writer.beginObject();
                if (el.getClassName().length() > 0) {
                    writer.name("method").value(el.getClassName() + "." + el.getMethodName());
                } else {
                    writer.name("method").value(el.getMethodName());
                }
                writer.name("file").value(el.getFileName() == null ? "Unknown" : el.getFileName());
                writer.name("lineNumber").value(el.getLineNumber());
                if (Stacktrace.inProject(el.getClassName(), this.projectPackages)) {
                    writer.name("inProject").value(true);
                }
                writer.endObject();
                continue;
            }
            catch (Exception lineEx) {
                Logger.warn("Failed to serialize stacktrace", lineEx);
            }
        }
        writer.endArray();
    }

    private static List<String> sanitiseProjectPackages(String[] projectPackages) {
        if (projectPackages != null) {
            return Arrays.asList(projectPackages);
        }
        return Collections.emptyList();
    }

    static boolean inProject(String className, String[] projectPackages) {
        return Stacktrace.inProject(className, Stacktrace.sanitiseProjectPackages(projectPackages));
    }

    private static boolean inProject(String className, List<String> projectPackages) {
        for (String packageName : projectPackages) {
            if (packageName == null || !className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }
}

