/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import com.bugsnag.android.ThreadSafe;

@ThreadSafe
public class BugsnagException
extends Throwable {
    private static final long serialVersionUID = 5068182621179433346L;
    private String name;
    private String message;
    private String type = "android";

    public BugsnagException(@NonNull String name, @NonNull String message, @NonNull StackTraceElement[] frames) {
        super(message);
        this.setStackTrace(frames);
        this.name = name;
    }

    BugsnagException(@NonNull Throwable exc) {
        super(exc.getMessage());
        if (exc instanceof BugsnagException) {
            this.message = ((BugsnagException)exc).getMessage();
            this.name = ((BugsnagException)exc).getName();
            this.type = ((BugsnagException)exc).getType();
        } else {
            this.name = exc.getClass().getName();
        }
        this.setStackTrace(exc.getStackTrace());
        this.initCause(exc.getCause());
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        this.name = name;
    }

    @Override
    @NonNull
    public String getMessage() {
        return this.message != null ? this.message : super.getMessage();
    }

    public void setMessage(@NonNull String message) {
        this.message = message;
    }

    @NonNull
    String getType() {
        return this.type;
    }

    void setType(@NonNull String type) {
        this.type = type;
    }
}

