/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.bugsnag.android.BeforeNotify;
import com.bugsnag.android.BeforeRecordBreadcrumb;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Callback;
import com.bugsnag.android.Client;
import com.bugsnag.android.ConfigFactory;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.ErrorReportApiClient;
import com.bugsnag.android.Logger;
import com.bugsnag.android.MetaData;
import com.bugsnag.android.Report;
import com.bugsnag.android.SessionTrackingApiClient;
import com.bugsnag.android.Severity;
import java.util.Map;

public final class Bugsnag {
    private static final Object lock = new Object();
    @SuppressLint(value={"StaticFieldLeak"})
    static Client client;

    private Bugsnag() {
    }

    @NonNull
    public static Client init(@NonNull Context androidContext) {
        return Bugsnag.init(androidContext, null, true);
    }

    @NonNull
    public static Client init(@NonNull Context androidContext, @Nullable String apiKey) {
        return Bugsnag.init(androidContext, apiKey, true);
    }

    @NonNull
    public static Client init(@NonNull Context androidContext, @Nullable String apiKey, boolean enableExceptionHandler) {
        Configuration config = ConfigFactory.createNewConfiguration(androidContext, apiKey, enableExceptionHandler);
        return Bugsnag.init(androidContext, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static Client init(@NonNull Context androidContext, @NonNull Configuration config) {
        Object object = lock;
        synchronized (object) {
            if (client == null) {
                client = new Client(androidContext, config);
            } else {
                Bugsnag.logClientInitWarning();
            }
        }
        return client;
    }

    private static void logClientInitWarning() {
        Logger.warn("It appears that Bugsnag.init() was called more than once. Subsequent calls have no effect, but may indicate that Bugsnag is not integrated in an Application subclass, which can lead to undesired behaviour.");
    }

    public static void setAppVersion(@NonNull String appVersion) {
        Bugsnag.getClient().setAppVersion(appVersion);
    }

    @Nullable
    public static String getContext() {
        return Bugsnag.getClient().getContext();
    }

    public static void setContext(@Nullable String context) {
        Bugsnag.getClient().setContext(context);
    }

    @Deprecated
    public static void setEndpoint(@NonNull String endpoint) {
        Bugsnag.getClient().setEndpoint(endpoint);
    }

    public static void setBuildUUID(@Nullable String buildUuid) {
        Bugsnag.getClient().setBuildUUID(buildUuid);
    }

    public static void setFilters(String ... filters) {
        Bugsnag.getClient().setFilters(filters);
    }

    public static void setIgnoreClasses(String ... ignoreClasses) {
        Bugsnag.getClient().setIgnoreClasses(ignoreClasses);
    }

    public static void setNotifyReleaseStages(String ... notifyReleaseStages) {
        Bugsnag.getClient().setNotifyReleaseStages(notifyReleaseStages);
    }

    @Deprecated
    public static void setProjectPackages(String ... projectPackages) {
        Bugsnag.getClient().setProjectPackages(projectPackages);
    }

    public static void setReleaseStage(@Nullable String releaseStage) {
        Bugsnag.getClient().setReleaseStage(releaseStage);
    }

    public static void setSendThreads(boolean sendThreads) {
        Bugsnag.getClient().setSendThreads(sendThreads);
    }

    public static void setAutoCaptureSessions(boolean autoCapture) {
        Bugsnag.getClient().setAutoCaptureSessions(autoCapture);
    }

    public static void setUser(@Nullable String id, @Nullable String email, @Nullable String name) {
        Bugsnag.getClient().setUser(id, email, name);
    }

    public static void clearUser() {
        Bugsnag.getClient().clearUser();
    }

    public static void setUserId(@Nullable String id) {
        Bugsnag.getClient().setUserId(id);
    }

    public static void setUserEmail(@Nullable String email) {
        Bugsnag.getClient().setUserEmail(email);
    }

    public static void setUserName(@Nullable String name) {
        Bugsnag.getClient().setUserName(name);
    }

    @Deprecated
    public static void setErrorReportApiClient(@NonNull ErrorReportApiClient errorReportApiClient) {
        Bugsnag.getClient().setErrorReportApiClient(errorReportApiClient);
    }

    @Deprecated
    public static void setSessionTrackingApiClient(@NonNull SessionTrackingApiClient apiClient) {
        Bugsnag.getClient().setSessionTrackingApiClient(apiClient);
    }

    public static void beforeNotify(@NonNull BeforeNotify beforeNotify) {
        Bugsnag.getClient().beforeNotify(beforeNotify);
    }

    public static void beforeRecordBreadcrumb(@NonNull BeforeRecordBreadcrumb beforeRecordBreadcrumb) {
        Bugsnag.getClient().beforeRecordBreadcrumb(beforeRecordBreadcrumb);
    }

    public static void notify(@NonNull Throwable exception) {
        Bugsnag.getClient().notify(exception);
    }

    public static void notify(@NonNull Throwable exception, @Nullable Callback callback) {
        Bugsnag.getClient().notify(exception, callback);
    }

    public static void notify(@NonNull String name, @NonNull String message, @NonNull StackTraceElement[] stacktrace, @Nullable Callback callback) {
        Bugsnag.getClient().notify(name, message, stacktrace, callback);
    }

    public static void notify(@NonNull Throwable exception, @NonNull Severity severity) {
        Bugsnag.getClient().notify(exception, severity);
    }

    @Deprecated
    public static void notify(@NonNull Throwable exception, final @NonNull MetaData metaData) {
        Bugsnag.getClient().notify(exception, new Callback(){

            @Override
            public void beforeNotify(@NonNull Report report) {
                report.getError().setMetaData(metaData);
            }
        });
    }

    @Deprecated
    public static void notify(@NonNull Throwable exception, final @NonNull Severity severity, final @NonNull MetaData metaData) {
        Bugsnag.getClient().notify(exception, new Callback(){

            @Override
            public void beforeNotify(@NonNull Report report) {
                report.getError().setSeverity(severity);
                report.getError().setMetaData(metaData);
            }
        });
    }

    @Deprecated
    public static void notify(@NonNull String name, @NonNull String message, @NonNull StackTraceElement[] stacktrace, @NonNull Severity severity, @NonNull MetaData metaData) {
        final Severity finalSeverity = severity;
        final MetaData finalMetaData = metaData;
        Bugsnag.getClient().notify(name, message, stacktrace, new Callback(){

            @Override
            public void beforeNotify(@NonNull Report report) {
                report.getError().setSeverity(finalSeverity);
                report.getError().setMetaData(finalMetaData);
            }
        });
    }

    @Deprecated
    public static void notify(@NonNull String name, @NonNull String message, @Nullable String context, @NonNull StackTraceElement[] stacktrace, @NonNull Severity severity, @NonNull MetaData metaData) {
        final String finalContext = context;
        final Severity finalSeverity = severity;
        final MetaData finalMetaData = metaData;
        Bugsnag.getClient().notify(name, message, stacktrace, new Callback(){

            @Override
            public void beforeNotify(@NonNull Report report) {
                report.getError().setSeverity(finalSeverity);
                report.getError().setMetaData(finalMetaData);
                report.getError().setContext(finalContext);
            }
        });
    }

    public static void internalClientNotify(@NonNull Throwable exception, @NonNull Map<String, Object> clientData, boolean blocking, @Nullable Callback callback) {
        Bugsnag.getClient().internalClientNotify(exception, clientData, blocking, callback);
    }

    public static void addToTab(@NonNull String tab, @NonNull String key, @Nullable Object value) {
        Bugsnag.getClient().addToTab(tab, key, value);
    }

    public static void clearTab(@NonNull String tabName) {
        Bugsnag.getClient().clearTab(tabName);
    }

    @NonNull
    public static MetaData getMetaData() {
        return Bugsnag.getClient().getMetaData();
    }

    public static void setMetaData(@NonNull MetaData metaData) {
        Bugsnag.getClient().setMetaData(metaData);
    }

    public static void leaveBreadcrumb(@NonNull String message) {
        Bugsnag.getClient().leaveBreadcrumb(message);
    }

    public static void leaveBreadcrumb(@NonNull String name, @NonNull BreadcrumbType type, @NonNull Map<String, String> metadata) {
        Bugsnag.getClient().leaveBreadcrumb(name, type, metadata);
    }

    @Deprecated
    public static void setMaxBreadcrumbs(int numBreadcrumbs) {
        Bugsnag.getClient().config.setMaxBreadcrumbs(numBreadcrumbs);
    }

    public static void clearBreadcrumbs() {
        Bugsnag.getClient().clearBreadcrumbs();
    }

    public static void enableExceptionHandler() {
        Bugsnag.getClient().enableExceptionHandler();
    }

    public static void disableExceptionHandler() {
        Bugsnag.getClient().disableExceptionHandler();
    }

    public static void setLoggingEnabled(boolean enabled) {
        Bugsnag.getClient().setLoggingEnabled(enabled);
    }

    public static void startSession() {
        Bugsnag.getClient().startSession();
    }

    public static boolean resumeSession() {
        return Bugsnag.getClient().resumeSession();
    }

    public static void stopSession() {
        Bugsnag.getClient().stopSession();
    }

    @NonNull
    public static Client getClient() {
        if (client == null) {
            throw new IllegalStateException("You must call Bugsnag.init before any other Bugsnag methods");
        }
        return client;
    }
}

