/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import com.brunomnsilva.smartgraph.graphview.Args;
import com.brunomnsilva.smartgraph.graphview.ShapeWithRadius;
import javafx.beans.property.DoubleProperty;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Shape;

public class ShapeCircle
implements ShapeWithRadius<Circle> {
    private final Circle surrogate;

    public ShapeCircle(double x, double y, double radius) {
        Args.requireNonNegative(x, "x");
        Args.requireNonNegative(y, "y");
        Args.requireNonNegative(radius, "radius");
        this.surrogate = new Circle(x, y, radius);
    }

    @Override
    public Shape getShape() {
        return this.surrogate;
    }

    @Override
    public DoubleProperty centerXProperty() {
        return this.surrogate.centerXProperty();
    }

    @Override
    public DoubleProperty centerYProperty() {
        return this.surrogate.centerYProperty();
    }

    @Override
    public DoubleProperty radiusProperty() {
        return this.surrogate.radiusProperty();
    }

    @Override
    public double getRadius() {
        return this.surrogate.getRadius();
    }

    @Override
    public void setRadius(double radius) {
        Args.requireNonNegative(radius, "radius");
        if (Double.compare(this.getRadius(), radius) != 0) {
            this.surrogate.setRadius(radius);
        }
    }
}

