/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.util;

import com.browserup.bup.mitm.exception.UncheckedIOException;
import com.browserup.bup.util.ClasspathResourceUtil;
import com.browserup.harreader.model.Har;
import com.browserup.harreader.model.HarEntry;
import com.browserup.harreader.model.HarLog;
import com.browserup.harreader.model.HarPage;
import com.browserup.harreader.model.HarTiming;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserUpProxyUtil {
    private static final Logger log = LoggerFactory.getLogger(BrowserUpProxyUtil.class);
    private static final String VERSION_CLASSPATH_RESOURCE = "/com/browserup/bup/version";
    private static final String UNKNOWN_VERSION_STRING = "UNKNOWN-VERSION";
    private static final Supplier<String> version = Suppliers.memoize((Supplier)new Supplier<String>(){

        public String get() {
            return BrowserUpProxyUtil.readVersionFileOnClasspath();
        }
    });

    public static Har copyHarThroughPageRef(Har har, String pageRef) {
        if (har == null) {
            return null;
        }
        if (har.getLog() == null) {
            return new Har();
        }
        HashSet<String> pageRefsToCopy = new HashSet<String>();
        for (HarPage page2 : har.getLog().getPages()) {
            pageRefsToCopy.add(page2.getId());
            if (!pageRef.equals(page2.getId())) continue;
            break;
        }
        HarLog logCopy = new HarLog();
        har.getLog().getEntries().stream().filter(entry -> pageRefsToCopy.contains(entry.getPageref())).forEach(entry -> logCopy.getEntries().add((HarEntry)entry));
        har.getLog().getPages().stream().filter(page -> pageRefsToCopy.contains(page.getId())).forEach(page -> logCopy.getPages().add((HarPage)page));
        Har harCopy = new Har();
        harCopy.setLog(logCopy);
        return harCopy;
    }

    public static String getVersionString() {
        return (String)version.get();
    }

    private static String readVersionFileOnClasspath() {
        String versionString;
        try {
            versionString = ClasspathResourceUtil.classpathResourceToString((String)VERSION_CLASSPATH_RESOURCE, (Charset)StandardCharsets.UTF_8);
        }
        catch (UncheckedIOException e) {
            log.debug("Unable to load version from classpath resource: {}", (Object)VERSION_CLASSPATH_RESOURCE, (Object)e);
            return UNKNOWN_VERSION_STRING;
        }
        if (versionString.isEmpty()) {
            log.debug("Version file on classpath was empty or could not be read. Resource: {}", (Object)VERSION_CLASSPATH_RESOURCE);
            return UNKNOWN_VERSION_STRING;
        }
        return versionString;
    }

    public static InetSocketAddress inetSocketAddressFromString(String hostAndPort) throws URISyntaxException {
        URI uri = new URI("my://" + hostAndPort);
        String host = uri.getHost();
        int port = uri.getPort();
        if (uri.getHost() == null || uri.getPort() == -1) {
            throw new URISyntaxException(uri.toString(), "URI must have host and port parts");
        }
        return new InetSocketAddress(host, port);
    }

    public static int getTotalElapsedTime(HarTiming timings) {
        return (timings.getBlocked() != -1 ? timings.getBlocked() : 0) + (timings.getDns() != -1 ? timings.getDns() : 0) + (timings.getConnect() != -1 ? timings.getConnect() : 0) + (timings.getSend() != -1 ? timings.getSend() : 0) + (timings.getWait() != -1 ? timings.getWait() : 0) + (timings.getReceive() != -1 ? timings.getReceive() : 0);
    }
}

