/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.filters;

import com.browserup.bup.util.BrowserUpHttpUtil;
import com.browserup.bup.util.HttpUtil;
import com.google.common.net.HostAndPort;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.littleshoot.proxy.HttpFiltersAdapter;
import org.littleshoot.proxy.impl.ProxyUtils;

public class HttpsAwareFiltersAdapter
extends HttpFiltersAdapter {
    public static final String IS_HTTPS_ATTRIBUTE_NAME = "isHttps";
    public static final String HOST_ATTRIBUTE_NAME = "host";
    public static final String ORIGINAL_HOST_ATTRIBUTE_NAME = "originalHost";

    public HttpsAwareFiltersAdapter(HttpRequest originalRequest, ChannelHandlerContext ctx) {
        super(originalRequest, ctx);
    }

    public boolean isHttps() {
        Attribute isHttpsAttr = this.ctx.channel().attr(AttributeKey.valueOf((String)IS_HTTPS_ATTRIBUTE_NAME));
        Boolean isHttps = (Boolean)isHttpsAttr.get();
        if (isHttps == null) {
            return false;
        }
        return isHttps;
    }

    public String getFullUrl(HttpRequest modifiedRequest) {
        if (ProxyUtils.isCONNECT((HttpObject)modifiedRequest)) {
            String hostNoDefaultPort = BrowserUpHttpUtil.removeMatchingPort(modifiedRequest.uri(), 443);
            return "https://" + hostNoDefaultPort;
        }
        if (HttpUtil.startsWithHttpOrHttps((String)modifiedRequest.uri())) {
            return modifiedRequest.uri();
        }
        String hostAndPort = this.getHostAndPort(modifiedRequest);
        String path = modifiedRequest.uri();
        return this.isHttps() ? "https://" + hostAndPort + path : "http://" + hostAndPort + path;
    }

    public String getOriginalUrl() {
        return this.getFullUrl(this.originalRequest);
    }

    public String getHost(HttpRequest modifiedRequest) {
        String serverHost;
        if (this.isHttps()) {
            HostAndPort hostAndPort = HostAndPort.fromString((String)this.getHttpsRequestHostAndPort());
            serverHost = hostAndPort.getHost();
        } else {
            serverHost = HttpUtil.getHostFromRequest((HttpRequest)modifiedRequest);
        }
        return serverHost;
    }

    public String getHostAndPort(HttpRequest modifiedRequest) {
        return this.isHttps() ? this.getHttpsRequestHostAndPort() : HttpUtil.getHostAndPortFromRequest((HttpRequest)modifiedRequest);
    }

    private String getHttpsRequestHostAndPort() throws IllegalStateException {
        if (!this.isHttps()) {
            throw new IllegalStateException("Request is not HTTPS. Cannot get host and port on non-HTTPS request using this method.");
        }
        Attribute hostnameAttr = this.ctx.channel().attr(AttributeKey.valueOf((String)HOST_ATTRIBUTE_NAME));
        return (String)hostnameAttr.get();
    }

    private String getHttpsOriginalRequestHostAndPort() throws IllegalStateException {
        if (!this.isHttps()) {
            throw new IllegalStateException("Request is not HTTPS. Cannot get original host and port on non-HTTPS request using this method.");
        }
        Attribute hostnameAttr = this.ctx.channel().attr(AttributeKey.valueOf((String)ORIGINAL_HOST_ATTRIBUTE_NAME));
        return (String)hostnameAttr.get();
    }
}

