/*
 * Decompiled with CFR 0.152.
 */
package com.browserup.bup.client;

import com.browserup.bup.BrowserUpProxy;
import com.browserup.bup.proxy.dns.AdvancedHostResolver;
import com.browserup.bup.proxy.dns.ChainedHostResolver;
import com.browserup.bup.proxy.dns.DnsJavaResolver;
import com.browserup.bup.proxy.dns.NativeCacheManipulatingResolver;
import com.browserup.bup.proxy.dns.NativeResolver;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import org.openqa.selenium.Proxy;

public class ClientUtil {
    public static AdvancedHostResolver createNativeCacheManipulatingResolver() {
        return new NativeCacheManipulatingResolver();
    }

    public static AdvancedHostResolver createNativeResolver() {
        return new NativeResolver();
    }

    @Deprecated
    public static AdvancedHostResolver createDnsJavaResolver() {
        return new DnsJavaResolver();
    }

    @Deprecated
    public static AdvancedHostResolver createDnsJavaWithNativeFallbackResolver() {
        return new ChainedHostResolver((Collection<? extends AdvancedHostResolver>)ImmutableList.of((Object)new DnsJavaResolver(), (Object)new NativeCacheManipulatingResolver()));
    }

    public static Proxy createSeleniumProxy(BrowserUpProxy browserUpProxy) {
        return ClientUtil.createSeleniumProxy(browserUpProxy, ClientUtil.getConnectableAddress());
    }

    public static Proxy createSeleniumProxy(BrowserUpProxy browserUpProxy, InetAddress connectableAddress) {
        return ClientUtil.createSeleniumProxy(new InetSocketAddress(connectableAddress, browserUpProxy.getPort()));
    }

    public static Proxy createSeleniumProxy(InetSocketAddress connectableAddressAndPort) {
        Proxy proxy = new Proxy();
        proxy.setProxyType(Proxy.ProxyType.MANUAL);
        String proxyStr = String.format("%s:%d", connectableAddressAndPort.getHostString(), connectableAddressAndPort.getPort());
        proxy.setHttpProxy(proxyStr);
        proxy.setSslProxy(proxyStr);
        return proxy;
    }

    public static InetAddress getConnectableAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Could not resolve localhost", e);
        }
    }
}

