/*
 * Decompiled with CFR 0.152.
 */
package com.brentcroft.tools.materializer.util;

import com.brentcroft.tools.jstl.JstlTemplateManager;
import com.brentcroft.tools.jstl.MapBindings;
import com.brentcroft.tools.materializer.util.ComplexTypeObject;
import com.brentcroft.tools.materializer.util.ElementObject;
import com.brentcroft.tools.materializer.util.Mutator;
import com.brentcroft.tools.materializer.util.SchemaItem;
import com.brentcroft.tools.materializer.util.SimpleTypeObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SchemaObject {
    protected final List<ElementObject> rootObjects = new LinkedList<ElementObject>();
    protected final List<ComplexTypeObject> complexTypes = new LinkedList<ComplexTypeObject>();
    protected final List<SimpleTypeObject> simpleTypes = new LinkedList<SimpleTypeObject>();
    protected final Map<String, String> hints = new HashMap<String, String>();
    private String systemId;

    public String toString() {
        return String.format("rootElements: %n%s %ncomplexTypes: %n%s %nsimpleTypes: %n%s", this.rootObjects.stream().map(SchemaItem::toString).collect(Collectors.joining("\n")), this.complexTypes.stream().map(SchemaItem::toString).collect(Collectors.joining("\n")), this.simpleTypes.stream().map(SchemaItem::toString).collect(Collectors.joining("\n")));
    }

    public String generateSource(Mutator rootMutator, String templateUri, String packageName) {
        ArrayList<Mutator> stepTables = new ArrayList<Mutator>();
        rootMutator.detectTables(stepTables);
        JstlTemplateManager jstl = new JstlTemplateManager();
        Pattern p = Pattern.compile("&#\\d{3};");
        jstl.getELTemplateManager().setValueExpressionFilter(v -> Optional.ofNullable(v).filter(o -> o instanceof String).map(Object::toString).filter(s -> p.matcher((CharSequence)s).find()).map(s -> s.replace("&#125;", "}")).orElse(v));
        return jstl.expandUri(templateUri, (Map)new MapBindings().withEntry("packageName", (Object)packageName).withEntry("rootClass", rootMutator.getContext()).withEntry("root", (Object)rootMutator).withEntry("steps", stepTables));
    }

    public List<ElementObject> getRootObjects() {
        return this.rootObjects;
    }

    public List<ComplexTypeObject> getComplexTypes() {
        return this.complexTypes;
    }

    public List<SimpleTypeObject> getSimpleTypes() {
        return this.simpleTypes;
    }

    public Map<String, String> getHints() {
        return this.hints;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
}

