/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.widget;

import android.content.Context;
import android.widget.ImageView;
import com.braze.models.cards.Card;
import com.braze.models.cards.ImageOnlyCard;
import com.braze.support.BrazeLogger;
import com.braze.ui.R;
import com.braze.ui.actions.IAction;
import com.braze.ui.feed.view.BaseFeedCardView;

public class ImageOnlyCardView
extends BaseFeedCardView<ImageOnlyCard> {
    private static final String TAG = BrazeLogger.getBrazeLogTag(ImageOnlyCardView.class);
    private final ImageView mImage = (ImageView)this.getProperViewFromInflatedStub(R.id.com_braze_image_only_card_imageview_stub);
    private IAction mCardAction;
    private float mAspectRatio = 6.0f;

    public ImageOnlyCardView(Context context) {
        this(context, null);
    }

    public ImageOnlyCardView(Context context, ImageOnlyCard card) {
        super(context);
        this.mImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mImage.setAdjustViewBounds(true);
        if (card != null) {
            this.setCard(card);
        }
        this.setBackground(this.getResources().getDrawable(R.drawable.com_braze_card_background, null));
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.com_braze_image_only_card;
    }

    @Override
    public void onSetCard(ImageOnlyCard card) {
        if (card.getAspectRatio() != 0.0f) {
            this.mAspectRatio = card.getAspectRatio();
        }
        this.setImageViewToUrl(this.mImage, card.getImageUrl(), this.mAspectRatio, (Card)card);
        this.mCardAction = ImageOnlyCardView.getUriActionForCard((Card)card);
        this.setOnClickListener(view -> this.handleCardClick(this.applicationContext, (Card)card, this.mCardAction));
    }
}

