/*
 * Decompiled with CFR 0.152.
 */
package com.braze.push;

import android.app.Notification;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationManagerCompat;
import com.braze.Braze;
import com.braze.BrazeInternal;
import com.braze.Constants;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.coroutine.BrazeCoroutineScope;
import com.braze.models.push.BrazeNotificationPayload;
import com.braze.push.BrazeNotificationActionUtils;
import com.braze.push.BrazeNotificationUtils;
import com.braze.push.BrazePushReceiver;
import com.braze.support.BrazeLogger;
import com.braze.support.DateTimeUtils;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/braze/push/BrazePushReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "Companion", "android-sdk-ui_release"})
public class BrazePushReceiver
extends BroadcastReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MESSAGE_TYPE_KEY = "message_type";
    @NotNull
    private static final String DELETED_MESSAGES_KEY = "deleted_messages";
    @NotNull
    private static final String NUMBER_OF_MESSAGES_DELETED_KEY = "total_deleted";
    @NotNull
    private static final String ADM_RECEIVE_INTENT_ACTION = "com.amazon.device.messaging.intent.RECEIVE";
    @NotNull
    private static final String ADM_REGISTRATION_INTENT_ACTION = "com.amazon.device.messaging.intent.REGISTRATION";
    @NotNull
    private static final String ADM_ERROR_KEY = "error";
    @NotNull
    private static final String ADM_ERROR_DESCRIPTION_KEY = "error_description";
    @NotNull
    private static final String ADM_REGISTRATION_ID_KEY = "registration_id";
    @NotNull
    private static final String ADM_UNREGISTERED_KEY = "unregistered";
    @NotNull
    public static final String FIREBASE_MESSAGING_SERVICE_ROUTING_ACTION = "firebase_messaging_service_routing_action";
    @NotNull
    public static final String HMS_PUSH_SERVICE_ROUTING_ACTION = "hms_push_service_routing_action";

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        com.braze.push.BrazePushReceiver$Companion.handleReceivedIntent$default(Companion, context, intent, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void handleReceivedIntent(@NotNull Context context, @NotNull Intent intent, boolean runOnThread) {
        Companion.handleReceivedIntent(context, intent, runOnThread);
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean handleAdmRegistrationEventIfEnabled(@NotNull BrazeConfigurationProvider appConfigurationProvider, @NotNull Context context, @NotNull Intent intent) {
        return Companion.handleAdmRegistrationEventIfEnabled(appConfigurationProvider, context, intent);
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean handleAdmRegistrationIntent(@NotNull Context context, @NotNull Intent intent) {
        return Companion.handleAdmRegistrationIntent(context, intent);
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean handlePushNotificationPayload(@NotNull Context context, @NotNull Intent intent) {
        return Companion.handlePushNotificationPayload(context, intent);
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final BrazeNotificationPayload createPayload(@NotNull Context context, @NotNull BrazeConfigurationProvider appConfigurationProvider, @NotNull Bundle notificationExtras, @NotNull Bundle brazeExtras) {
        return Companion.createPayload(context, appConfigurationProvider, notificationExtras, brazeExtras);
    }

    @JvmStatic
    @JvmOverloads
    public static final void handleReceivedIntent(@NotNull Context context, @NotNull Intent intent) {
        Companion.handleReceivedIntent(context, intent);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\"\u0010 \u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010!\u001a\u00020\u0019H\u0007J\u001d\u0010\"\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/braze/push/BrazePushReceiver$Companion;", "", "()V", "ADM_ERROR_DESCRIPTION_KEY", "", "ADM_ERROR_KEY", "ADM_RECEIVE_INTENT_ACTION", "ADM_REGISTRATION_ID_KEY", "ADM_REGISTRATION_INTENT_ACTION", "ADM_UNREGISTERED_KEY", "DELETED_MESSAGES_KEY", "FIREBASE_MESSAGING_SERVICE_ROUTING_ACTION", "HMS_PUSH_SERVICE_ROUTING_ACTION", "MESSAGE_TYPE_KEY", "NUMBER_OF_MESSAGES_DELETED_KEY", "createPayload", "Lcom/braze/models/push/BrazeNotificationPayload;", "context", "Landroid/content/Context;", "appConfigurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "notificationExtras", "Landroid/os/Bundle;", "brazeExtras", "handleAdmRegistrationEventIfEnabled", "", "intent", "Landroid/content/Intent;", "handleAdmRegistrationIntent", "handlePush", "", "handlePushNotificationPayload", "handleReceivedIntent", "runOnThread", "logNotificationMetadata", "payload", "logNotificationMetadata$android_sdk_ui_release", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void handlePush(Context context, Intent intent) {
            Context applicationContext = context.getApplicationContext();
            String action = intent.getAction();
            try {
                com.braze.push.BrazePushReceiver$Companion.handlePush$performWork(action, applicationContext, intent, context);
            }
            catch (Exception e) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, (Function0)((Function0)new Function0<String>(action, intent){
                    final /* synthetic */ String $action;
                    final /* synthetic */ Intent $intent;
                    {
                        this.$action = $action;
                        this.$intent = $intent;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Caught exception while performing the push notification handling work. Action: " + this.$action + " Intent: " + this.$intent;
                    }
                }), (int)4, null);
            }
        }

        @JvmStatic
        @JvmOverloads
        public final void handleReceivedIntent(@NotNull Context context, @NotNull Intent intent, boolean runOnThread) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            if (runOnThread) {
                BuildersKt.launch$default((CoroutineScope)((CoroutineScope)BrazeCoroutineScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, intent, null){
                    int label;
                    final /* synthetic */ Context $context;
                    final /* synthetic */ Intent $intent;
                    {
                        this.$context = $context;
                        this.$intent = $intent;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                Context context = this.$context.getApplicationContext();
                                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context.applicationContext");
                                com.braze.push.BrazePushReceiver$Companion.access$handlePush(BrazePushReceiver.Companion, context, this.$intent);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            } else {
                this.handlePush(context, intent);
            }
        }

        public static /* synthetic */ void handleReceivedIntent$default(Companion companion, Context context, Intent intent, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            companion.handleReceivedIntent(context, intent, bl);
        }

        @JvmStatic
        @VisibleForTesting
        public final boolean handleAdmRegistrationEventIfEnabled(@NotNull BrazeConfigurationProvider appConfigurationProvider, @NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)appConfigurationProvider, (String)"appConfigurationProvider");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, (Function0)((Function0)new Function0<String>(intent){
                final /* synthetic */ Intent $intent;
                {
                    this.$intent = $intent;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Received ADM registration. Message: " + this.$intent;
                }
            }), (int)6, null);
            if (Constants.isAmazonDevice() && appConfigurationProvider.isAdmMessagingRegistrationEnabled()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)handleAdmRegistrationEventIfEnabled.2.INSTANCE, (int)7, null);
                this.handleAdmRegistrationIntent(context, intent);
                return true;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)handleAdmRegistrationEventIfEnabled.3.INSTANCE, (int)6, null);
            return false;
        }

        @JvmStatic
        @VisibleForTesting
        public final boolean handleAdmRegistrationIntent(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            String error = intent.getStringExtra(BrazePushReceiver.ADM_ERROR_KEY);
            String errorDescription = intent.getStringExtra(BrazePushReceiver.ADM_ERROR_DESCRIPTION_KEY);
            String registrationId = intent.getStringExtra(BrazePushReceiver.ADM_REGISTRATION_ID_KEY);
            String unregistered = intent.getStringExtra(BrazePushReceiver.ADM_UNREGISTERED_KEY);
            if (error != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(error, errorDescription){
                    final /* synthetic */ String $error;
                    final /* synthetic */ String $errorDescription;
                    {
                        this.$error = $error;
                        this.$errorDescription = $errorDescription;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Error during ADM registration: " + this.$error + " description: " + this.$errorDescription;
                    }
                }), (int)6, null);
            } else if (registrationId != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, (Function0)((Function0)new Function0<String>(registrationId){
                    final /* synthetic */ String $registrationId;
                    {
                        this.$registrationId = $registrationId;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Registering for ADM messages with registrationId: " + this.$registrationId;
                    }
                }), (int)6, null);
                Braze.Companion.getInstance(context).setRegisteredPushToken(registrationId);
            } else if (unregistered != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>(unregistered){
                    final /* synthetic */ String $unregistered;
                    {
                        this.$unregistered = $unregistered;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "The device was un-registered from ADM: " + this.$unregistered;
                    }
                }), (int)6, null);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)handleAdmRegistrationIntent.4.INSTANCE, (int)6, null);
                return false;
            }
            return true;
        }

        @JvmStatic
        @VisibleForTesting
        public final boolean handlePushNotificationPayload(@NotNull Context context, @NotNull Intent intent) {
            BrazeConfigurationProvider appConfigurationProvider;
            BrazeNotificationPayload payload;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            if (!BrazeNotificationUtils.isBrazePushMessage(intent)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)handlePushNotificationPayload.1.INSTANCE, (int)7, null);
                return false;
            }
            if (Intrinsics.areEqual((Object)BrazePushReceiver.DELETED_MESSAGES_KEY, (Object)intent.getStringExtra(BrazePushReceiver.MESSAGE_TYPE_KEY))) {
                int totalDeleted = intent.getIntExtra(BrazePushReceiver.NUMBER_OF_MESSAGES_DELETED_KEY, -1);
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, (Function0)((Function0)new Function0<String>(totalDeleted){
                    final /* synthetic */ int $totalDeleted;
                    {
                        this.$totalDeleted = $totalDeleted;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Firebase messaging 'total_deleted' reports " + this.$totalDeleted + " messages.";
                    }
                }), (int)6, null);
                return false;
            }
            Bundle bundle = intent.getExtras();
            if (bundle == null) {
                return false;
            }
            Bundle notificationExtras = bundle;
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, (Function0)((Function0)new Function0<String>(notificationExtras){
                final /* synthetic */ Bundle $notificationExtras;
                {
                    this.$notificationExtras = $notificationExtras;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Push message payload received: " + this.$notificationExtras;
                }
            }), (int)6, null);
            Bundle brazeExtras = BrazeNotificationPayload.Companion.getAttachedBrazeExtras(notificationExtras);
            notificationExtras.putBundle("extra", brazeExtras);
            if (!notificationExtras.containsKey("braze_push_received_timestamp")) {
                notificationExtras.putLong("braze_push_received_timestamp", DateTimeUtils.nowInMilliseconds());
            }
            if ((payload = this.createPayload(context, appConfigurationProvider = BrazeInternal.INSTANCE.getConfigurationProvider(context), notificationExtras, brazeExtras)).isUninstallTrackingPush()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, (Function0)handlePushNotificationPayload.4.INSTANCE, (int)6, null);
                return false;
            }
            String string = payload.getPushUniqueId();
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (!BrazeInternal.INSTANCE.validateAndStorePushId(context, it)) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)Companion, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, (Function0)((Function0)new Function0<String>(it){
                        final /* synthetic */ String $it;
                        {
                            this.$it = $it;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Push with identifier '" + this.$it + "' has already been seen. Not displaying or forwarding push.";
                        }
                    }), (int)6, null);
                    return false;
                }
            }
            BrazeNotificationUtils.handleContentCardsSerializedCardIfPresent(payload);
            if (payload.getShouldFetchTestTriggers() && appConfigurationProvider.isInAppMessageTestPushEagerDisplayEnabled() && BrazeInAppMessageManager.Companion.getInstance().getActivity() != null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)handlePushNotificationPayload.6.INSTANCE, (int)7, null);
                BrazeInternal.handleInAppMessageTestPush((Context)context, (Intent)intent);
                return false;
            }
            if (BrazeNotificationUtils.isNotificationMessage(intent)) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)handlePushNotificationPayload.7.INSTANCE, (int)7, null);
                int notificationId = BrazeNotificationUtils.getNotificationId(payload);
                notificationExtras.putInt("nid", notificationId);
                if (payload.isPushStory()) {
                    if (Constants.isAmazonDevice()) {
                        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)handlePushNotificationPayload.8.INSTANCE, (int)7, null);
                        return false;
                    }
                    if (!notificationExtras.containsKey("braze_story_newly_received")) {
                        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)handlePushNotificationPayload.9.INSTANCE, (int)7, null);
                        notificationExtras.putBoolean("braze_story_newly_received", true);
                    }
                }
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, (Function0)((Function0)new Function0<String>(payload){
                    final /* synthetic */ BrazeNotificationPayload $payload;
                    {
                        this.$payload = $payload;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Creating notification with payload:\n" + this.$payload;
                    }
                }), (int)6, null);
                Notification notification = BrazeNotificationUtils.getActiveNotificationFactory().createNotification(payload);
                if (notification == null) {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)handlePushNotificationPayload.11.INSTANCE, (int)7, null);
                    return false;
                }
                NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)context);
                Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"from(context)");
                NotificationManagerCompat notificationManager = notificationManagerCompat;
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)((Function0)new Function0<String>(notificationManager){
                    final /* synthetic */ NotificationManagerCompat $notificationManager;
                    {
                        this.$notificationManager = $notificationManager;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Value of notificationManager.areNotificationsEnabled() = " + this.$notificationManager.areNotificationsEnabled();
                    }
                }), (int)7, null);
                notificationManager.notify("appboy_notification", notificationId, notification);
                BrazeNotificationUtils.sendPushMessageReceivedBroadcast(context, notificationExtras, payload);
                BrazeNotificationUtils.wakeScreenIfAppropriate(context, appConfigurationProvider, notificationExtras);
                Integer n = payload.getPushDuration();
                if (n != null) {
                    int duration = ((Number)n).intValue();
                    boolean bl = false;
                    BrazeNotificationUtils.setNotificationDurationAlarm(context, BrazePushReceiver.class, notificationId, duration);
                }
                this.logNotificationMetadata$android_sdk_ui_release(context, payload);
                return true;
            }
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)handlePushNotificationPayload.14.INSTANCE, (int)7, null);
            BrazeNotificationUtils.sendPushMessageReceivedBroadcast(context, notificationExtras, payload);
            BrazeNotificationUtils.requestGeofenceRefreshIfAppropriate(payload);
            BrazeNotificationUtils.refreshFeatureFlagsIfAppropriate(payload);
            return false;
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public final BrazeNotificationPayload createPayload(@NotNull Context context, @NotNull BrazeConfigurationProvider appConfigurationProvider, @NotNull Bundle notificationExtras, @NotNull Bundle brazeExtras) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)appConfigurationProvider, (String)"appConfigurationProvider");
            Intrinsics.checkNotNullParameter((Object)notificationExtras, (String)"notificationExtras");
            Intrinsics.checkNotNullParameter((Object)brazeExtras, (String)"brazeExtras");
            return Constants.isAmazonDevice() ? new BrazeNotificationPayload(notificationExtras, BrazeNotificationPayload.Companion.getAttachedBrazeExtras(notificationExtras), context, appConfigurationProvider) : new BrazeNotificationPayload(notificationExtras, brazeExtras, context, appConfigurationProvider);
        }

        @VisibleForTesting
        public final void logNotificationMetadata$android_sdk_ui_release(@NotNull Context context, @NotNull BrazeNotificationPayload payload) {
            block2: {
                String it;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                if (payload.isPushDeliveryEnabled()) {
                    String string = payload.getCampaignId();
                    if (string != null) {
                        it = string;
                        boolean bl = false;
                        long min = RangesKt.coerceAtLeast((long)payload.getFlushMinMinutes(), (long)0L);
                        long max = RangesKt.coerceAtLeast((long)payload.getFlushMaxMinutes(), (long)min);
                        long minToMillis = TimeUnit.MINUTES.toMillis(min);
                        long waitTimeMs = max > min ? Random.Default.nextLong(minToMillis, TimeUnit.MINUTES.toMillis(max)) : minToMillis;
                        BrazeInternal.INSTANCE.logPushDelivery(context, it, waitTimeMs);
                    }
                }
                String string = payload.getCampaignId();
                if (string == null) break block2;
                it = string;
                boolean bl = false;
                BrazeInternal.INSTANCE.logPushCampaign(context, it);
            }
        }

        @JvmStatic
        @JvmOverloads
        public final void handleReceivedIntent(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            com.braze.push.BrazePushReceiver$Companion.handleReceivedIntent$default(this, context, intent, false, 4, null);
        }

        private static final void handlePush$performWork(String action, Context applicationContext, Intent $intent, Context $context) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)Companion, (BrazeLogger.Priority)BrazeLogger.Priority.I, null, (boolean)false, (Function0)((Function0)new Function0<String>($intent){
                final /* synthetic */ Intent $intent;
                {
                    this.$intent = $intent;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Received broadcast message. Message: " + this.$intent;
                }
            }), (int)6, null);
            CharSequence charSequence = action;
            if (charSequence == null || charSequence.length() == 0) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)Companion, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)((Function0)new Function0<String>($intent){
                    final /* synthetic */ Intent $intent;
                    {
                        this.$intent = $intent;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Push action is null. Not handling intent: " + this.$intent;
                    }
                }), (int)6, null);
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)applicationContext, (String)"applicationContext");
            BrazeInternal.applyPendingRuntimeConfiguration((Context)applicationContext);
            switch (action) {
                case "hms_push_service_routing_action": 
                case "com.amazon.device.messaging.intent.RECEIVE": 
                case "com.braze.action.STORY_TRAVERSE": 
                case "firebase_messaging_service_routing_action": {
                    Companion.handlePushNotificationPayload(applicationContext, $intent);
                    break;
                }
                case "com.amazon.device.messaging.intent.REGISTRATION": {
                    Companion.handleAdmRegistrationEventIfEnabled(new BrazeConfigurationProvider(applicationContext), applicationContext, $intent);
                    break;
                }
                case "com.braze.action.CANCEL_NOTIFICATION": {
                    BrazeNotificationUtils.handleCancelNotificationAction(applicationContext, $intent);
                    break;
                }
                case "com.braze.action.BRAZE_PUSH_DELETED": {
                    BrazeNotificationUtils.handleNotificationDeleted(applicationContext, $intent);
                    break;
                }
                case "com.braze.action.BRAZE_STORY_CLICKED": {
                    BrazeNotificationUtils.handlePushStoryPageClicked($context, $intent);
                    break;
                }
                case "com.braze.action.BRAZE_ACTION_CLICKED": {
                    BrazeNotificationActionUtils.handleNotificationActionClicked($context, $intent);
                    break;
                }
                case "com.braze.action.BRAZE_PUSH_CLICKED": {
                    BrazeNotificationUtils.handleNotificationOpened($context, $intent);
                    break;
                }
                default: {
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)Companion, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)handlePush.performWork.3.INSTANCE, (int)6, null);
                }
            }
        }

        public static final /* synthetic */ void access$handlePush(Companion $this, Context context, Intent intent) {
            $this.handlePush(context, intent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

