/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.graphql.types;

import com.braintreegateway.exceptions.ServerException;
import com.braintreegateway.graphql.enums.RecommendedPaymentOption;
import com.braintreegateway.graphql.types.PaymentRecommendation;
import com.braintreegateway.graphql.unions.CustomerRecommendations;
import com.braintreegateway.util.Experimental;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Experimental(value="This class is experimental and may change in future releases.")
public class CustomerRecommendationsPayload {
    private final String sessionId;
    private final boolean isInPayPalNetwork;
    private final CustomerRecommendations recommendations;

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isInPayPalNetwork() {
        return this.isInPayPalNetwork;
    }

    public CustomerRecommendations getRecommendations() {
        return this.recommendations;
    }

    public CustomerRecommendationsPayload(Map<String, Object> response) {
        this.sessionId = (String)CustomerRecommendationsPayload.getValue(response, "generateCustomerRecommendations.sessionId");
        this.isInPayPalNetwork = (Boolean)CustomerRecommendationsPayload.getValue(response, "generateCustomerRecommendations.isInPayPalNetwork");
        this.recommendations = CustomerRecommendationsPayload.extractRecommendations(response);
    }

    private static CustomerRecommendations extractRecommendations(Map<String, Object> response) {
        try {
            List paymentRecommendations = (List)CustomerRecommendationsPayload.getValue(response, "generateCustomerRecommendations.paymentRecommendations");
            List<PaymentRecommendation> paymentRecommendationList = paymentRecommendations.stream().map(recommendationObj -> {
                Integer recommendedPriority = (Integer)CustomerRecommendationsPayload.getValue(recommendationObj, "recommendedPriority");
                String paymentOptionString = (String)CustomerRecommendationsPayload.getValue(recommendationObj, "paymentOption");
                RecommendedPaymentOption paymentOption = RecommendedPaymentOption.valueOf(paymentOptionString);
                return new PaymentRecommendation(paymentOption, recommendedPriority);
            }).collect(Collectors.toList());
            return new CustomerRecommendations(paymentRecommendationList);
        }
        catch (Exception e) {
            throw new ServerException("Error extracting recommendations: " + e.getMessage());
        }
    }

    private static <T> T getValue(Map<String, Object> response, String key) {
        Map map = response;
        String[] keyParts = key.split("\\.");
        for (int k = 0; k < keyParts.length - 1; ++k) {
            String subKey = keyParts[k];
            map = (Map)CustomerRecommendationsPayload.popValue(map, subKey);
        }
        String lastKey = keyParts[keyParts.length - 1];
        return CustomerRecommendationsPayload.popValue(map, lastKey);
    }

    private static <T> T popValue(Map<String, Object> response, String key) {
        if (!response.containsKey(key)) {
            throw new ServerException("Couldn't parse response");
        }
        return (T)response.get(key);
    }
}

