/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.enums.Business;
import com.braintreegateway.enums.Consumer;
import com.braintreegateway.enums.Corporate;
import com.braintreegateway.enums.PrepaidReloadable;
import com.braintreegateway.enums.Purchase;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;

public class AndroidPayDetails {
    private String bin;
    private String business;
    private String cardType;
    private String commercial;
    private String consumer;
    private String corporate;
    private String countryOfIssuance;
    private String debit;
    private String durbinRegulated;
    private String expirationMonth;
    private String expirationYear;
    private String globalId;
    private String googleTransactionId;
    private String healthcare;
    private String imageUrl;
    private Boolean isNetworkTokenized;
    private String issuingBank;
    private String last4;
    private String paymentAccountReference;
    private String payroll;
    private String prepaid;
    private String prepaidReloadable;
    private String productId;
    private String purchase;
    private String sourceCardLast4;
    private String sourceCardType;
    private String sourceDescription;
    private String token;
    private String virtualCardLast4;
    private String virtualCardType;

    public AndroidPayDetails(NodeWrapper node) {
        this.sourceCardType = node.findString("source-card-type");
        this.sourceCardLast4 = node.findString("source-card-last-4");
        this.sourceDescription = node.findString("source-description");
        this.virtualCardType = node.findString("virtual-card-type");
        this.virtualCardLast4 = node.findString("virtual-card-last-4");
        this.cardType = this.virtualCardType;
        this.last4 = this.virtualCardLast4;
        this.expirationMonth = node.findString("expiration-month");
        this.expirationYear = node.findString("expiration-year");
        this.token = node.findString("token");
        this.googleTransactionId = node.findString("google-transaction-id");
        this.bin = node.findString("bin");
        this.imageUrl = node.findString("image-url");
        this.isNetworkTokenized = node.findBoolean("is-network-tokenized");
        this.paymentAccountReference = node.findString("payment-account-reference");
        this.payroll = node.findString("payroll");
        this.prepaid = node.findString("prepaid");
        this.prepaidReloadable = node.findString("prepaid-reloadable");
        this.healthcare = node.findString("healthcare");
        this.debit = node.findString("debit");
        this.durbinRegulated = node.findString("durbin-regulated");
        this.commercial = node.findString("commercial");
        this.issuingBank = node.findString("issuing-bank");
        this.countryOfIssuance = node.findString("country-of-issuance");
        this.productId = node.findString("product-id");
        this.globalId = node.findString("global-id");
        this.business = node.findString("business");
        this.consumer = node.findString("consumer");
        this.corporate = node.findString("corporate");
        this.purchase = node.findString("purchase");
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getSourceCardType() {
        return this.sourceCardType;
    }

    public String getSourceCardLast4() {
        return this.sourceCardLast4;
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    public String getVirtualCardType() {
        return this.virtualCardType;
    }

    public String getVirtualCardLast4() {
        return this.virtualCardLast4;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    public String getToken() {
        return this.token;
    }

    public String getGoogleTransactionId() {
        return this.googleTransactionId;
    }

    public String getBin() {
        return this.bin;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public Boolean isNetworkTokenized() {
        return this.isNetworkTokenized;
    }

    public String getPaymentAccountReference() {
        return this.paymentAccountReference;
    }

    public String getPrepaid() {
        return this.prepaid;
    }

    public PrepaidReloadable getPrepaidReloadable() {
        return (PrepaidReloadable)EnumUtils.findByToString((Enum[])PrepaidReloadable.values(), (String)this.prepaidReloadable, (Enum)PrepaidReloadable.UNKNOWN);
    }

    public String getHealthcare() {
        return this.healthcare;
    }

    public String getDebit() {
        return this.debit;
    }

    public String getDurbinRegulated() {
        return this.durbinRegulated;
    }

    public String getCommercial() {
        return this.commercial;
    }

    public String getPayroll() {
        return this.payroll;
    }

    public String getIssuingBank() {
        return this.issuingBank;
    }

    public String getCountryOfIssuance() {
        return this.countryOfIssuance;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getGlobalId() {
        return this.globalId;
    }

    public Business getBusiness() {
        return (Business)EnumUtils.findByToString((Enum[])Business.values(), (String)this.business, (Enum)Business.UNKNOWN);
    }

    public Consumer getConsumer() {
        return (Consumer)EnumUtils.findByToString((Enum[])Consumer.values(), (String)this.consumer, (Enum)Consumer.UNKNOWN);
    }

    public Corporate getCorporate() {
        return (Corporate)EnumUtils.findByToString((Enum[])Corporate.values(), (String)this.corporate, (Enum)Corporate.UNKNOWN);
    }

    public Purchase getPurchase() {
        return (Purchase)EnumUtils.findByToString((Enum[])Purchase.values(), (String)this.purchase, (Enum)Purchase.UNKNOWN);
    }
}

