/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.CreditCard;
import com.braintreegateway.enums.PrepaidReloadable;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;

public class MetaCheckoutTokenDetails {
    private String bin;
    private String cardholderName;
    private String cardType;
    private String commercial;
    private String containerId;
    private String countryOfIssuance;
    private String cryptogram;
    private String debit;
    private String durbinRegulated;
    private String ecommerceIndicator;
    private String expirationMonth;
    private String expirationYear;
    private String healthcare;
    private String imageUrl;
    private String issuingBank;
    private String last4;
    private String payroll;
    private String prepaid;
    private String prepaidReloadable;
    private String productId;
    private String token;

    public MetaCheckoutTokenDetails(NodeWrapper node) {
        this.bin = node.findString("bin");
        this.cardType = node.findString("card-type");
        this.cardholderName = node.findString("cardholder-name");
        this.containerId = node.findString("container-id");
        this.cryptogram = node.findString("cryptogram");
        this.ecommerceIndicator = node.findString("ecommerce-indicator");
        this.expirationMonth = node.findString("expiration-month");
        this.expirationYear = node.findString("expiration-year");
        this.imageUrl = node.findString("image-url");
        this.last4 = node.findString("last-4");
        this.token = node.findString("token");
        this.commercial = node.findString("commercial");
        this.debit = node.findString("debit");
        this.durbinRegulated = node.findString("durbin-regulated");
        this.healthcare = node.findString("healthcare");
        this.payroll = node.findString("payroll");
        this.prepaid = node.findString("prepaid");
        this.prepaidReloadable = node.findString("prepaid-reloadable");
        this.productId = node.findString("product-id");
        this.countryOfIssuance = node.findString("country-of-issuance");
        this.issuingBank = node.findString("issuing-bank");
    }

    public String getBin() {
        return this.bin;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getCryptogram() {
        return this.cryptogram;
    }

    public String getCardholderName() {
        return this.cardholderName;
    }

    public String getExpirationDate() {
        if (this.expirationMonth == null || this.expirationYear == null) {
            return "0/0";
        }
        return this.getExpirationMonth() + "/" + this.getExpirationYear();
    }

    public String getEcommerceIndicator() {
        return this.ecommerceIndicator;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getMaskedNumber() {
        return this.getBin() + "******" + this.getLast4();
    }

    public String getToken() {
        return this.token;
    }

    public CreditCard.Commercial getCommercial() {
        if (this.commercial.equals(CreditCard.Commercial.YES.toString())) {
            return CreditCard.Commercial.YES;
        }
        if (this.commercial.equals(CreditCard.Commercial.NO.toString())) {
            return CreditCard.Commercial.NO;
        }
        return CreditCard.Commercial.UNKNOWN;
    }

    public CreditCard.Debit getDebit() {
        if (this.debit.equals(CreditCard.Debit.YES.toString())) {
            return CreditCard.Debit.YES;
        }
        if (this.debit.equals(CreditCard.Debit.NO.toString())) {
            return CreditCard.Debit.NO;
        }
        return CreditCard.Debit.UNKNOWN;
    }

    public CreditCard.DurbinRegulated getDurbinRegulated() {
        if (this.durbinRegulated.equals(CreditCard.DurbinRegulated.YES.toString())) {
            return CreditCard.DurbinRegulated.YES;
        }
        if (this.durbinRegulated.equals(CreditCard.DurbinRegulated.NO.toString())) {
            return CreditCard.DurbinRegulated.NO;
        }
        return CreditCard.DurbinRegulated.UNKNOWN;
    }

    public CreditCard.Healthcare getHealthcare() {
        if (this.healthcare.equals(CreditCard.Healthcare.YES.toString())) {
            return CreditCard.Healthcare.YES;
        }
        if (this.healthcare.equals(CreditCard.Healthcare.NO.toString())) {
            return CreditCard.Healthcare.NO;
        }
        return CreditCard.Healthcare.UNKNOWN;
    }

    public CreditCard.Payroll getPayroll() {
        if (this.payroll.equals(CreditCard.Payroll.YES.toString())) {
            return CreditCard.Payroll.YES;
        }
        if (this.payroll.equals(CreditCard.Payroll.NO.toString())) {
            return CreditCard.Payroll.NO;
        }
        return CreditCard.Payroll.UNKNOWN;
    }

    public CreditCard.Prepaid getPrepaid() {
        if (this.prepaid.equals(CreditCard.Prepaid.YES.toString())) {
            return CreditCard.Prepaid.YES;
        }
        if (this.prepaid.equals(CreditCard.Prepaid.NO.toString())) {
            return CreditCard.Prepaid.NO;
        }
        return CreditCard.Prepaid.UNKNOWN;
    }

    public PrepaidReloadable getPrepaidReloadable() {
        return (PrepaidReloadable)EnumUtils.findByToString((Enum[])PrepaidReloadable.values(), (String)this.prepaidReloadable, (Enum)PrepaidReloadable.UNKNOWN);
    }

    public String getProductId() {
        if (this.productId.equals("")) {
            return "Unknown";
        }
        return this.productId;
    }

    public String getCountryOfIssuance() {
        if (this.countryOfIssuance.equals("")) {
            return "Unknown";
        }
        return this.countryOfIssuance;
    }

    public String getIssuingBank() {
        if (this.issuingBank.equals("")) {
            return "Unknown";
        }
        return this.issuingBank;
    }
}

