/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AccountUpdaterDailyReport;
import com.braintreegateway.ConnectedMerchantPayPalStatusChanged;
import com.braintreegateway.ConnectedMerchantStatusTransitioned;
import com.braintreegateway.Disbursement;
import com.braintreegateway.Dispute;
import com.braintreegateway.GrantedPaymentInstrumentUpdate;
import com.braintreegateway.LocalPaymentCompleted;
import com.braintreegateway.LocalPaymentExpired;
import com.braintreegateway.LocalPaymentFunded;
import com.braintreegateway.LocalPaymentReversed;
import com.braintreegateway.MerchantAccount;
import com.braintreegateway.OAuthAccessRevocation;
import com.braintreegateway.PartnerMerchant;
import com.braintreegateway.PaymentMethodCustomerDataUpdatedMetadata;
import com.braintreegateway.RevokedPaymentMethodMetadata;
import com.braintreegateway.Subscription;
import com.braintreegateway.Transaction;
import com.braintreegateway.TransactionReview;
import com.braintreegateway.ValidationErrors;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.util.Calendar;

public class WebhookNotification {
    private AccountUpdaterDailyReport accountUpdaterDailyReport;
    private ConnectedMerchantPayPalStatusChanged connectedMerchantPayPalStatusChanged;
    private ConnectedMerchantStatusTransitioned connectedMerchantStatusTransitioned;
    private Disbursement disbursement;
    private Dispute dispute;
    private ValidationErrors errors;
    private GrantedPaymentInstrumentUpdate grantedPaymentInstrumentUpdate;
    private Kind kind;
    private LocalPaymentCompleted localPaymentCompleted;
    private LocalPaymentExpired localPaymentExpired;
    private LocalPaymentFunded localPaymentFunded;
    private LocalPaymentReversed localPaymentReversed;
    private MerchantAccount merchantAccount;
    private OAuthAccessRevocation oauthAccessRevocation;
    private PartnerMerchant partnerMerchant;
    private PaymentMethodCustomerDataUpdatedMetadata paymentMethodCustomerDataUpdatedMetadata;
    private RevokedPaymentMethodMetadata revokedPaymentMethodMetadata;
    private String sourceMerchantId;
    private Subscription subscription;
    private Calendar timestamp;
    private Transaction transaction;
    private TransactionReview transactionReview;

    public WebhookNotification(NodeWrapper node) {
        NodeWrapper paymentMethodCustomerDataUpdatedMetadataNode;
        NodeWrapper localPaymentFundedNode;
        NodeWrapper localPaymentExpiredNode;
        NodeWrapper localPaymentNode;
        NodeWrapper localPaymentReverseNode;
        NodeWrapper grantedPaymentInstrumentUpdateNode;
        NodeWrapper accountUpdaterDailyReportNode;
        NodeWrapper connectedMerchantPayPalStatusChangedNode;
        NodeWrapper connectedMerchantStatusTransitionedNode;
        NodeWrapper oAuthAccessRevocationNode;
        NodeWrapper partnerMerchantNode;
        NodeWrapper transactionReviewNode;
        NodeWrapper transactionNode;
        NodeWrapper disputeNode;
        NodeWrapper merchantAccountNode;
        NodeWrapper disbursementNode;
        NodeWrapper subscriptionNode;
        this.kind = EnumUtils.findByName(Kind.class, node.findString("kind"), Kind.UNRECOGNIZED);
        this.timestamp = node.findDateTime("timestamp");
        this.sourceMerchantId = node.findString("source-merchant-id");
        NodeWrapper wrapperNode = node.findFirst("subject");
        NodeWrapper errorNode = wrapperNode.findFirst("api-error-response");
        if (errorNode != null) {
            wrapperNode = errorNode;
        }
        if ((subscriptionNode = wrapperNode.findFirst("subscription")) != null) {
            this.subscription = new Subscription(subscriptionNode);
        }
        if ((disbursementNode = wrapperNode.findFirst("disbursement")) != null) {
            this.disbursement = new Disbursement(disbursementNode);
        }
        if ((merchantAccountNode = wrapperNode.findFirst("merchant-account")) != null) {
            this.merchantAccount = new MerchantAccount(merchantAccountNode);
        }
        if ((disputeNode = wrapperNode.findFirst("dispute")) != null) {
            this.dispute = new Dispute(disputeNode);
        }
        if ((transactionNode = wrapperNode.findFirst("transaction")) != null) {
            this.transaction = new Transaction(transactionNode);
        }
        if ((transactionReviewNode = wrapperNode.findFirst("transaction-review")) != null) {
            this.transactionReview = new TransactionReview(transactionReviewNode);
        }
        if ((partnerMerchantNode = wrapperNode.findFirst("partner-merchant")) != null) {
            this.partnerMerchant = new PartnerMerchant(partnerMerchantNode);
        }
        if ((oAuthAccessRevocationNode = wrapperNode.findFirst("oauth-application-revocation")) != null) {
            this.oauthAccessRevocation = new OAuthAccessRevocation(oAuthAccessRevocationNode);
        }
        if ((connectedMerchantStatusTransitionedNode = wrapperNode.findFirst("connected-merchant-status-transitioned")) != null) {
            this.connectedMerchantStatusTransitioned = new ConnectedMerchantStatusTransitioned(connectedMerchantStatusTransitionedNode);
        }
        if ((connectedMerchantPayPalStatusChangedNode = wrapperNode.findFirst("connected-merchant-paypal-status-changed")) != null) {
            this.connectedMerchantPayPalStatusChanged = new ConnectedMerchantPayPalStatusChanged(connectedMerchantPayPalStatusChangedNode);
        }
        if ((accountUpdaterDailyReportNode = wrapperNode.findFirst("account-updater-daily-report")) != null) {
            this.accountUpdaterDailyReport = new AccountUpdaterDailyReport(accountUpdaterDailyReportNode);
        }
        if ((grantedPaymentInstrumentUpdateNode = wrapperNode.findFirst("granted-payment-instrument-update")) != null) {
            this.grantedPaymentInstrumentUpdate = new GrantedPaymentInstrumentUpdate(grantedPaymentInstrumentUpdateNode);
        }
        if (this.kind == Kind.GRANTED_PAYMENT_METHOD_REVOKED || this.kind == Kind.PAYMENT_METHOD_REVOKED_BY_CUSTOMER) {
            this.revokedPaymentMethodMetadata = new RevokedPaymentMethodMetadata(wrapperNode);
        }
        if ((localPaymentReverseNode = wrapperNode.findFirst("local-payment-reversed")) != null && this.kind == Kind.LOCAL_PAYMENT_REVERSED) {
            this.localPaymentReversed = new LocalPaymentReversed(localPaymentReverseNode);
        }
        if ((localPaymentNode = wrapperNode.findFirst("local-payment")) != null && this.kind == Kind.LOCAL_PAYMENT_COMPLETED) {
            this.localPaymentCompleted = new LocalPaymentCompleted(localPaymentNode);
        }
        if ((localPaymentExpiredNode = wrapperNode.findFirst("local-payment-expired")) != null && this.kind == Kind.LOCAL_PAYMENT_EXPIRED) {
            this.localPaymentExpired = new LocalPaymentExpired(localPaymentExpiredNode);
        }
        if ((localPaymentFundedNode = wrapperNode.findFirst("local-payment-funded")) != null && this.kind == Kind.LOCAL_PAYMENT_FUNDED) {
            this.localPaymentFunded = new LocalPaymentFunded(localPaymentFundedNode);
        }
        if ((paymentMethodCustomerDataUpdatedMetadataNode = wrapperNode.findFirst("payment-method-customer-data-updated-metadata")) != null && this.kind == Kind.PAYMENT_METHOD_CUSTOMER_DATA_UPDATED) {
            this.paymentMethodCustomerDataUpdatedMetadata = new PaymentMethodCustomerDataUpdatedMetadata(paymentMethodCustomerDataUpdatedMetadataNode);
        }
        if (!wrapperNode.isSuccess()) {
            this.errors = new ValidationErrors(wrapperNode);
        }
    }

    public ValidationErrors getErrors() {
        return this.errors;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getSourceMerchantId() {
        return this.sourceMerchantId;
    }

    public MerchantAccount getMerchantAccount() {
        return this.merchantAccount;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public TransactionReview getTransactionReview() {
        return this.transactionReview;
    }

    public Disbursement getDisbursement() {
        return this.disbursement;
    }

    public Dispute getDispute() {
        return this.dispute;
    }

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    public PartnerMerchant getPartnerMerchant() {
        return this.partnerMerchant;
    }

    public OAuthAccessRevocation getOAuthAccessRevocation() {
        return this.oauthAccessRevocation;
    }

    public ConnectedMerchantStatusTransitioned getConnectedMerchantStatusTransitioned() {
        return this.connectedMerchantStatusTransitioned;
    }

    public ConnectedMerchantPayPalStatusChanged getConnectedMerchantPayPalStatusChanged() {
        return this.connectedMerchantPayPalStatusChanged;
    }

    public AccountUpdaterDailyReport getAccountUpdaterDailyReport() {
        return this.accountUpdaterDailyReport;
    }

    public GrantedPaymentInstrumentUpdate getGrantedPaymentInstrumentUpdate() {
        return this.grantedPaymentInstrumentUpdate;
    }

    public RevokedPaymentMethodMetadata getRevokedPaymentMethodMetadata() {
        return this.revokedPaymentMethodMetadata;
    }

    public LocalPaymentCompleted getLocalPaymentCompleted() {
        return this.localPaymentCompleted;
    }

    public LocalPaymentExpired getLocalPaymentExpired() {
        return this.localPaymentExpired;
    }

    public LocalPaymentFunded getLocalPaymentFunded() {
        return this.localPaymentFunded;
    }

    public LocalPaymentReversed getLocalPaymentReversed() {
        return this.localPaymentReversed;
    }

    public PaymentMethodCustomerDataUpdatedMetadata getPaymentMethodCustomerDataUpdatedMetadata() {
        return this.paymentMethodCustomerDataUpdatedMetadata;
    }

    public static enum Kind {
        ACCOUNT_UPDATER_DAILY_REPORT("account_updater_daily_report"),
        CHECK("check"),
        CONNECTED_MERCHANT_STATUS_TRANSITIONED("connected_merchant_status_transitioned"),
        CONNECTED_MERCHANT_PAYPAL_STATUS_CHANGED("connected_merchant_paypal_status_changed"),
        DISBURSEMENT("disbursement"),
        DISBURSEMENT_EXCEPTION("disbursement_exception"),
        DISPUTE_ACCEPTED("dispute_accepted"),
        DISPUTE_AUTO_ACCEPTED("dispute_auto_accepted"),
        DISPUTE_DISPUTED("dispute_disputed"),
        DISPUTE_EXPIRED("dispute_expired"),
        DISPUTE_LOST("dispute_lost"),
        DISPUTE_OPENED("dispute_opened"),
        DISPUTE_UNDER_REVIEW("dispute_under_review"),
        DISPUTE_WON("dispute_won"),
        GRANTED_PAYMENT_METHOD_REVOKED("granted_payment_method_revoked"),
        GRANTOR_UPDATED_GRANTED_PAYMENT_METHOD("grantor_updated_granted_payment_method"),
        LOCAL_PAYMENT_COMPLETED("local_payment_completed"),
        LOCAL_PAYMENT_EXPIRED("local_payment_expired"),
        LOCAL_PAYMENT_FUNDED("local_payment_funded"),
        LOCAL_PAYMENT_REVERSED("local_payment_reversed"),
        OAUTH_ACCESS_REVOKED("oauth_access_revoked"),
        PARTNER_MERCHANT_DISCONNECTED("partner_merchant_disconnected"),
        PARTNER_MERCHANT_CONNECTED("partner_merchant_connected"),
        PARTNER_MERCHANT_DECLINED("partner_merchant_declined"),
        PAYMENT_METHOD_CUSTOMER_DATA_UPDATED("payment_method_customer_data_updated"),
        PAYMENT_METHOD_REVOKED_BY_CUSTOMER("payment_method_revoked_by_customer"),
        RECIPIENT_UPDATED_GRANTED_PAYMENT_METHOD("recipient_updated_granted_payment_method"),
        REFUND_FAILED("refund_failed"),
        SUB_MERCHANT_ACCOUNT_APPROVED("sub_merchant_account_approved"),
        SUB_MERCHANT_ACCOUNT_DECLINED("sub_merchant_account_declined"),
        SUBSCRIPTION_BILLING_SKIPPED("subscription_billing_skipped"),
        SUBSCRIPTION_CANCELED("subscription_canceled"),
        SUBSCRIPTION_CHARGED_SUCCESSFULLY("subscription_charged_successfully"),
        SUBSCRIPTION_CHARGED_UNSUCCESSFULLY("subscription_charged_unsuccessfully"),
        SUBSCRIPTION_EXPIRED("subscription_expired"),
        SUBSCRIPTION_TRIAL_ENDED("subscription_trial_ended"),
        SUBSCRIPTION_WENT_ACTIVE("subscription_went_active"),
        SUBSCRIPTION_WENT_PAST_DUE("subscription_went_past_due"),
        TRANSACTION_DISBURSED("transaction_disbursed"),
        TRANSACTION_REVIEWED("transaction_reviewed"),
        TRANSACTION_SETTLED("transaction_settled"),
        TRANSACTION_SETTLEMENT_DECLINED("transaction_settlement_declined"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private Kind(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

