/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.LiabilityShift;
import com.braintreegateway.util.NodeWrapper;
import java.util.List;

public class RiskData {
    private Boolean deviceDataCaptured;
    private LiabilityShift liabilityShift;
    private List<String> decisionReasons;
    private String decision;
    private String fraudServiceProvider;
    private String id;
    private String transactionRiskScore;

    public RiskData(NodeWrapper node) {
        this.id = node.findString("id");
        this.decision = node.findString("decision");
        String deviceDataCapturedString = node.findString("device-data-captured");
        this.deviceDataCaptured = deviceDataCapturedString == null ? null : Boolean.valueOf(deviceDataCapturedString);
        this.fraudServiceProvider = node.findString("fraud-service-provider");
        this.transactionRiskScore = node.findString("transaction-risk-score");
        this.decisionReasons = node.findAllStrings("decision-reasons");
        NodeWrapper liabilityShiftNode = node.findFirst("liability-shift");
        if (liabilityShiftNode != null && !liabilityShiftNode.isBlank()) {
            this.liabilityShift = new LiabilityShift(liabilityShiftNode);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getDecision() {
        return this.decision;
    }

    public List<String> getDecisionReasons() {
        return this.decisionReasons;
    }

    public Boolean getDeviceDataCaptured() {
        return this.deviceDataCaptured;
    }

    public String getFraudServiceProvider() {
        return this.fraudServiceProvider;
    }

    public LiabilityShift getLiabilityShift() {
        return this.liabilityShift;
    }

    public String getTransactionRiskScore() {
        return this.transactionRiskScore;
    }
}

