/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.Request;
import com.braintreegateway.ThreeDSecureLookupAdditionalInformation;
import com.braintreegateway.ThreeDSecureLookupAddress;
import com.braintreegateway.exceptions.UnexpectedException;
import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ThreeDSecureLookupRequest
extends Request {
    private ThreeDSecureLookupAdditionalInformation additionalInformation;
    private String amount;
    private String authorizationFingerprint;
    private ThreeDSecureLookupAddress billingAddress;
    private String braintreeLibraryVersion;
    private Boolean cardAddChallengeRequested;
    private Boolean challengeRequested;
    private Map clientMetadata;
    private Boolean dataOnlyRequested;
    private String dfReferenceId;
    private String email;
    private Boolean exemptionRequested;
    private String merchantAccountId;
    private String nonce;
    private String requestedExemptionType;
    private String browserAcceptHeader;
    private String browserColorDepth;
    private Boolean browserJavaEnabled;
    private Boolean browserJavascriptEnabled;
    private String browserLanguage;
    private String browserScreenHeight;
    private String browserScreenWidth;
    private String browserTimeZone;
    private String deviceChannel;
    private String ipAddress;
    private String userAgent;

    public ThreeDSecureLookupRequest additionalInformation(ThreeDSecureLookupAdditionalInformation additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    public ThreeDSecureLookupRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    public ThreeDSecureLookupRequest clientData(String clientData) {
        Map jsonMap;
        try {
            jsonMap = JSON.std.mapFrom((Object)clientData);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
        this.nonce = (String)jsonMap.get("nonce");
        this.authorizationFingerprint = (String)jsonMap.get("authorizationFingerprint");
        this.braintreeLibraryVersion = (String)jsonMap.get("braintreeLibraryVersion");
        this.dfReferenceId = (String)jsonMap.get("dfReferenceId");
        this.clientMetadata = (Map)jsonMap.get("clientMetadata");
        return this;
    }

    public ThreeDSecureLookupRequest cardAddChallengeRequested(Boolean cardAddChallengeRequested) {
        this.cardAddChallengeRequested = cardAddChallengeRequested;
        return this;
    }

    public ThreeDSecureLookupRequest challengeRequested(Boolean challengeRequested) {
        this.challengeRequested = challengeRequested;
        return this;
    }

    public ThreeDSecureLookupRequest dataOnlyRequested(Boolean dataOnlyRequested) {
        this.dataOnlyRequested = dataOnlyRequested;
        return this;
    }

    public ThreeDSecureLookupRequest exemptionRequested(Boolean exemptionRequested) {
        this.exemptionRequested = exemptionRequested;
        return this;
    }

    public ThreeDSecureLookupRequest requestedExemptionType(String requestedExemptionType) {
        this.requestedExemptionType = requestedExemptionType;
        return this;
    }

    public ThreeDSecureLookupRequest email(String email) {
        this.email = email;
        return this;
    }

    public ThreeDSecureLookupRequest billingAddress(ThreeDSecureLookupAddress billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    public ThreeDSecureLookupRequest merchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
        return this;
    }

    public ThreeDSecureLookupRequest browserJavaEnabled(Boolean enabled) {
        this.browserJavaEnabled = enabled;
        return this;
    }

    public ThreeDSecureLookupRequest browserAcceptHeader(String header) {
        this.browserAcceptHeader = header;
        return this;
    }

    public ThreeDSecureLookupRequest browserLanguage(String language) {
        this.browserLanguage = language;
        return this;
    }

    public ThreeDSecureLookupRequest browserColorDepth(String depth) {
        this.browserColorDepth = depth;
        return this;
    }

    public ThreeDSecureLookupRequest browserScreenHeight(String height) {
        this.browserScreenHeight = height;
        return this;
    }

    public ThreeDSecureLookupRequest browserScreenWidth(String width) {
        this.browserScreenWidth = width;
        return this;
    }

    public ThreeDSecureLookupRequest browserTimeZone(String zone) {
        this.browserTimeZone = zone;
        return this;
    }

    public ThreeDSecureLookupRequest userAgent(String agent) {
        this.userAgent = agent;
        return this;
    }

    public ThreeDSecureLookupRequest ipAddress(String address) {
        this.ipAddress = address;
        return this;
    }

    public ThreeDSecureLookupRequest deviceChannel(String channel) {
        this.deviceChannel = channel;
        return this;
    }

    public ThreeDSecureLookupRequest browserJavascriptEnabled(Boolean enabled) {
        this.browserJavascriptEnabled = enabled;
        return this;
    }

    private ThreeDSecureLookupAdditionalInformation getAdditionalInformation() {
        return this.additionalInformation;
    }

    public String getNonce() {
        return this.nonce;
    }

    private String getAuthorizationFingerprint() {
        return this.authorizationFingerprint;
    }

    private String getBraintreeLibraryVersion() {
        return this.braintreeLibraryVersion;
    }

    private String getDfReferenceId() {
        return this.dfReferenceId;
    }

    public String getAmount() {
        return this.amount;
    }

    private Map getClientMetadata() {
        return this.clientMetadata;
    }

    private Boolean getCardAddChallengeRequested() {
        return this.cardAddChallengeRequested;
    }

    private Boolean getChallengeRequested() {
        return this.challengeRequested;
    }

    private Boolean getExemptionRequested() {
        return this.exemptionRequested;
    }

    private String getRequestedExemptionType() {
        return this.requestedExemptionType;
    }

    private Boolean getDataOnlyRequested() {
        return this.dataOnlyRequested;
    }

    private String getEmail() {
        return this.email;
    }

    private String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    private Boolean getBrowserJavaEnabled() {
        return this.browserJavaEnabled;
    }

    private String getBrowserAcceptHeader() {
        return this.browserAcceptHeader;
    }

    private String getBrowserLanguage() {
        return this.browserLanguage;
    }

    private String getBrowserColorDepth() {
        return this.browserColorDepth;
    }

    private String getBrowserScreenHeight() {
        return this.browserScreenHeight;
    }

    private String getBrowserScreenWidth() {
        return this.browserScreenWidth;
    }

    private String getBrowserTimeZone() {
        return this.browserTimeZone;
    }

    private String getUserAgent() {
        return this.userAgent;
    }

    private String getIpAddress() {
        return this.ipAddress;
    }

    private String getDeviceChannel() {
        return this.deviceChannel;
    }

    private Boolean getBrowserJavascriptEnabled() {
        return this.browserJavascriptEnabled;
    }

    public String toJSON() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        HashMap<String, String> metaMap = new HashMap<String, String>();
        Map<String, Object> additionalInfo = this.additionalInformation != null ? this.additionalInformation.toMap() : new HashMap<String, Object>();
        try {
            metaMap.put("platform", "java");
            metaMap.put("sdkVersion", Configuration.VERSION);
            metaMap.put("source", "http");
            jsonMap.put("authorizationFingerprint", this.getAuthorizationFingerprint());
            jsonMap.put("email", this.getEmail());
            jsonMap.put("amount", this.getAmount());
            jsonMap.put("braintreeLibraryVersion", this.getBraintreeLibraryVersion());
            jsonMap.put("df_reference_id", this.getDfReferenceId());
            jsonMap.put("clientMetadata", this.getClientMetadata());
            jsonMap.put("_meta", metaMap);
            jsonMap.put("cardAddChallengeRequested", this.getCardAddChallengeRequested());
            jsonMap.put("challengeRequested", this.getChallengeRequested());
            jsonMap.put("exemptionRequested", this.getExemptionRequested());
            jsonMap.put("requestedExemptionType", this.getRequestedExemptionType());
            jsonMap.put("dataOnlyRequested", this.getDataOnlyRequested());
            jsonMap.put("merchantAccountId", this.getMerchantAccountId());
            jsonMap.put("browserColorDepth", this.getBrowserColorDepth());
            jsonMap.put("browserHeader", this.getBrowserAcceptHeader());
            jsonMap.put("browserLanguage", this.getBrowserLanguage());
            jsonMap.put("browserJavaEnabled", this.getBrowserJavaEnabled());
            jsonMap.put("browserJavascriptEnabled", this.getBrowserJavascriptEnabled());
            jsonMap.put("browserScreenHeight", this.getBrowserScreenHeight());
            jsonMap.put("browserScreenWidth", this.getBrowserScreenWidth());
            jsonMap.put("browserTimeZone", this.getBrowserTimeZone());
            jsonMap.put("deviceChannel", this.getDeviceChannel());
            jsonMap.put("ipAddress", this.getIpAddress());
            jsonMap.put("userAgent", this.getUserAgent());
            if (this.billingAddress != null) {
                additionalInfo.put("billingGivenName", this.billingAddress.getGivenName());
                additionalInfo.put("billingSurname", this.billingAddress.getSurname());
                additionalInfo.put("billingPhoneNumber", this.billingAddress.getPhoneNumber());
                additionalInfo.put("billingCity", this.billingAddress.getLocality());
                additionalInfo.put("billingCountryCode", this.billingAddress.getCountryCodeAlpha2());
                additionalInfo.put("billingLine1", this.billingAddress.getStreetAddress());
                additionalInfo.put("billingLine2", this.billingAddress.getExtendedAddress());
                additionalInfo.put("billingPostalCode", this.billingAddress.getPostalCode());
                additionalInfo.put("billingState", this.billingAddress.getRegion());
            }
            jsonMap.put("additional_info", additionalInfo);
            return JSON.std.asString(jsonMap);
        }
        catch (IOException e) {
            throw new UnexpectedException(e.getMessage(), e);
        }
    }
}

