/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.CreditCardRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;

public class CreditCardOptionsRequest
extends Request {
    private Boolean failOnDuplicatePaymentMethod;
    private Boolean makeDefault;
    private Boolean skipAdvancedFraudChecking;
    private Boolean verifyCard;
    private CreditCardRequest parent;
    private String updateExistingToken;
    private String venmoSdkSession;
    private String verificationAccountType;
    private String verificationAmount;
    private String verificationCurrencyIsoCode;
    private String verificationMerchantAccountId;

    public CreditCardOptionsRequest(CreditCardRequest parent) {
        this.parent = parent;
    }

    public CreditCardRequest done() {
        return this.parent;
    }

    public CreditCardOptionsRequest verificationMerchantAccountId(String verificationMerchantAccountId) {
        this.verificationMerchantAccountId = verificationMerchantAccountId;
        return this;
    }

    public CreditCardOptionsRequest verificationAccountType(String verificationAccountType) {
        this.verificationAccountType = verificationAccountType;
        return this;
    }

    public CreditCardOptionsRequest failOnDuplicatePaymentMethod(Boolean failOnDuplicatePaymentMethod) {
        this.failOnDuplicatePaymentMethod = failOnDuplicatePaymentMethod;
        return this;
    }

    public CreditCardOptionsRequest verificationAmount(String verificationAmount) {
        this.verificationAmount = verificationAmount;
        return this;
    }

    public CreditCardOptionsRequest verifyCard(Boolean verifyCard) {
        this.verifyCard = verifyCard;
        return this;
    }

    public CreditCardOptionsRequest skipAdvancedFraudChecking(Boolean skipAdvancedFraudChecking) {
        this.skipAdvancedFraudChecking = skipAdvancedFraudChecking;
        return this;
    }

    public CreditCardOptionsRequest makeDefault(Boolean makeDefault) {
        this.makeDefault = makeDefault;
        return this;
    }

    public CreditCardOptionsRequest updateExistingToken(String token) {
        this.updateExistingToken = token;
        return this;
    }

    public CreditCardOptionsRequest venmoSdkSession(String venmoSdkSession) {
        this.venmoSdkSession = venmoSdkSession;
        return this;
    }

    public CreditCardOptionsRequest verificationCurrencyIsoCode(String verificationCurrencyIsoCode) {
        this.verificationCurrencyIsoCode = verificationCurrencyIsoCode;
        return this;
    }

    @Override
    public String toXML() {
        return this.buildRequest("options").toXML();
    }

    @Override
    public String toQueryString() {
        return this.toQueryString("options");
    }

    @Override
    public String toQueryString(String root) {
        return this.buildRequest(root).toQueryString();
    }

    protected RequestBuilder buildRequest(String root) {
        RequestBuilder builder = new RequestBuilder(root);
        builder.addElement("failOnDuplicatePaymentMethod", this.failOnDuplicatePaymentMethod);
        builder.addElement("skipAdvancedFraudChecking", this.skipAdvancedFraudChecking);
        builder.addElement("updateExistingToken", this.updateExistingToken);
        builder.addElement("venmoSdkSession", this.venmoSdkSession);
        builder.addElement("verificationAccountType", this.verificationAccountType);
        builder.addElement("verificationAmount", this.verificationAmount);
        builder.addElement("verificationCurrencyIsoCode", this.verificationCurrencyIsoCode);
        builder.addElement("verificationMerchantAccountId", this.verificationMerchantAccountId);
        builder.addElement("verifyCard", this.verifyCard);
        if (this.makeDefault != null && this.makeDefault.booleanValue()) {
            builder.addElement("makeDefault", this.makeDefault);
        }
        return builder;
    }
}

