/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.Customer;
import com.braintreegateway.CustomerPager;
import com.braintreegateway.CustomerRequest;
import com.braintreegateway.CustomerSearchRequest;
import com.braintreegateway.ResourceCollection;
import com.braintreegateway.Result;
import com.braintreegateway.TransparentRedirectRequest;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.List;

public class CustomerGateway {
    private Configuration configuration;
    private Http http;

    public CustomerGateway(Http http, Configuration configuration) {
        this.configuration = configuration;
        this.http = http;
    }

    public ResourceCollection<Customer> all() {
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/customers/advanced_search_ids");
        return new ResourceCollection<Customer>(new CustomerPager(this, new CustomerSearchRequest()), response);
    }

    List<Customer> fetchCustomers(CustomerSearchRequest query, List<String> ids) {
        query.ids().in(ids);
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/customers/advanced_search", query);
        ArrayList<Customer> items = new ArrayList<Customer>();
        for (NodeWrapper node : response.findAll("customer")) {
            items.add(new Customer(node));
        }
        return items;
    }

    @Deprecated
    public Result<Customer> confirmTransparentRedirect(String queryString) {
        TransparentRedirectRequest trRequest = new TransparentRedirectRequest(this.configuration, queryString);
        NodeWrapper node = this.http.post(this.configuration.getMerchantPath() + "/customers/all/confirm_transparent_redirect_request", trRequest);
        return new Result<Customer>(node, Customer.class);
    }

    public Result<Customer> create(CustomerRequest request) {
        NodeWrapper node = this.http.post(this.configuration.getMerchantPath() + "/customers", request);
        return new Result<Customer>(node, Customer.class);
    }

    public Result<Customer> delete(String id) {
        this.http.delete(this.configuration.getMerchantPath() + "/customers/" + id);
        return new Result<Customer>();
    }

    public Customer find(String id) {
        if (id == null || id.trim().equals("")) {
            throw new NotFoundException();
        }
        return new Customer(this.http.get(this.configuration.getMerchantPath() + "/customers/" + id));
    }

    public Customer find(String id, String associationFilterId) {
        if (id == null || id.trim().equals("")) {
            throw new NotFoundException();
        }
        if (associationFilterId == null || associationFilterId.isEmpty()) {
            throw new NotFoundException();
        }
        String queryParams = "?association_filter_id=" + associationFilterId;
        return new Customer(this.http.get(this.configuration.getMerchantPath() + "/customers/" + id + queryParams));
    }

    public ResourceCollection<Customer> search(CustomerSearchRequest query) {
        NodeWrapper node = this.http.post(this.configuration.getMerchantPath() + "/customers/advanced_search_ids", query);
        return new ResourceCollection<Customer>(new CustomerPager(this, query), node);
    }

    @Deprecated
    public String transparentRedirectURLForCreate() {
        return this.configuration.getBaseURL() + this.configuration.getMerchantPath() + "/customers/all/create_via_transparent_redirect_request";
    }

    @Deprecated
    public String transparentRedirectURLForUpdate() {
        return this.configuration.getBaseURL() + this.configuration.getMerchantPath() + "/customers/all/update_via_transparent_redirect_request";
    }

    public Result<Customer> update(String id, CustomerRequest request) {
        NodeWrapper node = this.http.put(this.configuration.getMerchantPath() + "/customers/" + id, request);
        return new Result<Customer>(node, Customer.class);
    }
}

