/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.TransactionLineItem;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.List;

public class TransactionLineItemGateway {
    private Http http;
    private Configuration configuration;

    public TransactionLineItemGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public List<TransactionLineItem> findAll(String transactionId) {
        if (transactionId == null || transactionId.trim().equals("")) {
            throw new NotFoundException();
        }
        NodeWrapper node = this.http.get(this.configuration.getMerchantPath() + "/transactions/" + transactionId + "/line_items");
        ArrayList<TransactionLineItem> transactionLineItems = new ArrayList<TransactionLineItem>();
        for (NodeWrapper transactionLineItemResponse : node.findAll("line-item")) {
            transactionLineItems.add(new TransactionLineItem(transactionLineItemResponse));
        }
        return transactionLineItems;
    }
}

