/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.IbanBankAccount;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;

public class IdealPayment {
    private String id;
    private String idealTransactionId;
    private String imageUrl;
    private String status;
    private String currency;
    private BigDecimal amount;
    private String orderId;
    private String issuer;
    private String approvalUrl;
    private IbanBankAccount ibanBankAccount;

    public IdealPayment(NodeWrapper node) {
        this.id = node.findString("id");
        this.idealTransactionId = node.findString("ideal-transaction-id");
        this.imageUrl = node.findString("image-url");
        this.currency = node.findString("currency");
        this.status = node.findString("status");
        this.amount = node.findBigDecimal("amount");
        this.orderId = node.findString("order-id");
        this.issuer = node.findString("issuer");
        this.approvalUrl = node.findString("approval-url");
        NodeWrapper ibanBankAccountNode = node.findFirst("iban-bank-account");
        if (ibanBankAccountNode != null) {
            this.ibanBankAccount = new IbanBankAccount(ibanBankAccountNode);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getIdealTransactionId() {
        return this.idealTransactionId;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getStatus() {
        return this.status;
    }

    public String getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getApprovalUrl() {
        return this.approvalUrl;
    }

    public IbanBankAccount getIbanBankAccount() {
        return this.ibanBankAccount;
    }
}

