/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.PaymentMethodNonce;
import com.braintreegateway.Result;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentMethodNonceGateway {
    private Http http;
    private Configuration configuration;

    public PaymentMethodNonceGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public Result<PaymentMethodNonce> create(String paymentMethodToken) {
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + "/payment_methods/" + paymentMethodToken + "/nonces");
        return this.parseResponse(response);
    }

    public PaymentMethodNonce find(String paymentMethodNonce) {
        NodeWrapper response = this.http.get(this.configuration.getMerchantPath() + "/payment_method_nonces/" + paymentMethodNonce);
        return new PaymentMethodNonce(response);
    }

    public Result<PaymentMethodNonce> parseResponse(NodeWrapper response) {
        return new Result<PaymentMethodNonce>(response, PaymentMethodNonce.class);
    }
}

