/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AddModificationRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;
import com.braintreegateway.SubscriptionRequest;
import com.braintreegateway.UpdateModificationRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModificationsRequest
extends Request {
    private SubscriptionRequest parent;
    private String name;
    private List<AddModificationRequest> adds;
    private List<UpdateModificationRequest> updates;
    private List<String> removeModificationIds;

    public ModificationsRequest(SubscriptionRequest parent, String name) {
        this.name = name;
        this.parent = parent;
        this.adds = new ArrayList<AddModificationRequest>();
        this.updates = new ArrayList<UpdateModificationRequest>();
        this.removeModificationIds = new ArrayList<String>();
    }

    public AddModificationRequest add() {
        AddModificationRequest addModificationRequest = new AddModificationRequest(this);
        this.adds.add(addModificationRequest);
        return addModificationRequest;
    }

    public SubscriptionRequest done() {
        return this.parent;
    }

    public ModificationsRequest remove(String ... modificationIds) {
        return this.remove(Arrays.asList(modificationIds));
    }

    public ModificationsRequest remove(List<String> modificationIds) {
        this.removeModificationIds.addAll(modificationIds);
        return this;
    }

    public UpdateModificationRequest update(String existingId) {
        UpdateModificationRequest updateModificationRequest = new UpdateModificationRequest(this, existingId);
        this.updates.add(updateModificationRequest);
        return updateModificationRequest;
    }

    @Override
    public String toXML() {
        return this.buildRequest(this.name).toXML();
    }

    protected RequestBuilder buildRequest(String root) {
        return new RequestBuilder(root).addElement("add", this.adds).addElement("remove", this.removeModificationIds).addElement("update", this.updates);
    }
}

