/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Address;
import com.braintreegateway.AddressRequest;
import com.braintreegateway.Configuration;
import com.braintreegateway.Result;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressGateway {
    private Http http;
    private Configuration configuration;

    public AddressGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public Result<Address> create(String customerId, AddressRequest request) {
        NodeWrapper node = this.http.post(this.configuration.getMerchantPath() + "/customers/" + customerId + "/addresses", request);
        return new Result<Address>(node, Address.class);
    }

    public Result<Address> delete(String customerId, String id) {
        this.http.delete(this.configuration.getMerchantPath() + "/customers/" + customerId + "/addresses/" + id);
        return new Result<Address>();
    }

    public Address find(String customerId, String id) {
        if (customerId == null || customerId.trim().equals("") || id == null || id.trim().equals("")) {
            throw new NotFoundException();
        }
        return new Address(this.http.get(this.configuration.getMerchantPath() + "/customers/" + customerId + "/addresses/" + id));
    }

    public Result<Address> update(String customerId, String id, AddressRequest request) {
        NodeWrapper node = this.http.put(this.configuration.getMerchantPath() + "/customers/" + customerId + "/addresses/" + id, request);
        return new Result<Address>(node, Address.class);
    }
}

