/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.util;

import com.braintreegateway.util.NodeWrapper;
import com.braintreegateway.util.StringUtils;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNodeWrapper
extends NodeWrapper {
    private static SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private String name;
    private Map<String, String> attributes = new HashMap<String, String>();
    private List<Object> content = new LinkedList<Object>();

    private SimpleNodeWrapper(String name) {
        this.name = name;
    }

    public static SimpleNodeWrapper parse(String xml) {
        try {
            InputSource source = new InputSource(new StringReader(xml));
            SAXParser parser = saxParserFactory.newSAXParser();
            MapNodeHandler handler = new MapNodeHandler();
            parser.parse(source, (DefaultHandler)handler);
            return handler.root;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public List<NodeWrapper> findAll(String expression) {
        String[] paths = expression.split("/");
        LinkedList<String> tokens = new LinkedList<String>(Arrays.asList(paths));
        LinkedList<NodeWrapper> nodes = new LinkedList<NodeWrapper>();
        this.findAll(tokens, nodes);
        return nodes;
    }

    private void findAll(LinkedList<String> tokens, List<NodeWrapper> nodes) {
        if (tokens.isEmpty()) {
            nodes.add(this);
        } else {
            String first = tokens.getFirst();
            if (".".equals(first)) {
                this.findAll(this.restOf(tokens), nodes);
            }
            for (SimpleNodeWrapper node : this.childNodes()) {
                if (!"*".equals(first) && !first.equals(node.name)) continue;
                node.findAll(this.restOf(tokens), nodes);
            }
        }
    }

    private SimpleNodeWrapper find(LinkedList<String> tokens) {
        if (tokens.isEmpty()) {
            return this;
        }
        String first = tokens.getFirst();
        if (".".equals(first)) {
            return this.find(this.restOf(tokens));
        }
        for (SimpleNodeWrapper node : this.childNodes()) {
            if (!"*".equals(first) && !first.equals(node.name)) continue;
            return node.find(this.restOf(tokens));
        }
        return null;
    }

    private SimpleNodeWrapper find(String expression) {
        String[] paths = expression.split("/");
        LinkedList<String> tokens = new LinkedList<String>(Arrays.asList(paths));
        return this.find(tokens);
    }

    private LinkedList<String> restOf(LinkedList<String> tokens) {
        LinkedList<String> newTokens = new LinkedList<String>(tokens);
        newTokens.removeFirst();
        return newTokens;
    }

    @Override
    public NodeWrapper findFirst(String expression) {
        return this.find(expression);
    }

    @Override
    public String findString(String expression) {
        SimpleNodeWrapper node = this.find(expression);
        if (node == null) {
            return null;
        }
        return node.stringValue();
    }

    @Override
    public boolean isBlank() {
        return "true".equals(this.attributes.get("nil"));
    }

    private String stringValue() {
        if (this.content.size() == 1 && this.content.get(0) == null) {
            return null;
        }
        StringBuilder value = new StringBuilder();
        for (Object o : this.content) {
            value.append(o.toString());
        }
        return value.toString().trim();
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    private List<SimpleNodeWrapper> childNodes() {
        LinkedList<SimpleNodeWrapper> nodes = new LinkedList<SimpleNodeWrapper>();
        for (Object o : this.content) {
            if (!(o instanceof SimpleNodeWrapper)) continue;
            nodes.add((SimpleNodeWrapper)o);
        }
        return nodes;
    }

    @Override
    public Map<String, String> getFormParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        for (SimpleNodeWrapper node : this.childNodes()) {
            node.buildParams("", params);
        }
        return params;
    }

    private void buildParams(String prefix, Map<String, String> params) {
        String newPrefix;
        List<SimpleNodeWrapper> childNodes = this.childNodes();
        String string = newPrefix = "".equals(prefix) ? StringUtils.underscore(this.name) : prefix + "[" + StringUtils.underscore(this.name) + "]";
        if (childNodes.isEmpty()) {
            params.put(newPrefix, this.stringValue());
        } else {
            for (SimpleNodeWrapper childNode : childNodes) {
                childNode.buildParams(newPrefix, params);
            }
        }
    }

    public String toString() {
        return "<" + this.name + (this.attributes.isEmpty() ? "" : " attributes=" + StringUtils.toString(this.attributes)) + " content=" + StringUtils.toString(this.content) + ">";
    }

    private static class MapNodeHandler
    extends DefaultHandler {
        private static Pattern NON_WHITE_SPACE = Pattern.compile("\\S");
        private Stack<SimpleNodeWrapper> stack = new Stack();
        public SimpleNodeWrapper root;

        private MapNodeHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            SimpleNodeWrapper node = new SimpleNodeWrapper(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                node.attributes.put(attributes.getQName(i), attributes.getValue(i));
            }
            if ("true".equals(node.attributes.get("nil"))) {
                node.content.add(null);
            }
            if (!this.stack.isEmpty()) {
                this.stack.peek().content.add(node);
            }
            this.stack.push(node);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            SimpleNodeWrapper pop = this.stack.pop();
            if (this.stack.isEmpty()) {
                this.root = pop;
            }
        }

        public void characters(char[] chars, int start, int length) throws SAXException {
            String value = new String(chars, start, length);
            Matcher matcher = NON_WHITE_SPACE.matcher(value);
            if (value.length() > 0 && matcher.find()) {
                this.stack.peek().content.add(value);
            }
        }
    }
}

