/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Environment;
import com.braintreegateway.exceptions.ConfigurationException;

public class CredentialsParser {
    public Environment environment;
    public String merchantId;
    public String clientId;
    public String clientSecret;
    public String accessToken;

    public CredentialsParser(String clientId, String clientSecret) {
        if (!clientSecret.startsWith("client_secret")) {
            throw new ConfigurationException("Value passed for clientSecret is not a valid clientSecret");
        }
        this.clientSecret = clientSecret;
        if (!clientId.startsWith("client_id")) {
            throw new ConfigurationException("Value passed for clientId is not a valid clientId");
        }
        this.clientId = clientId;
        Environment clientIdEnvironment = this.parseEnvironment(clientId);
        Environment clientSecretEnvironment = this.parseEnvironment(clientSecret);
        if (clientIdEnvironment != clientSecretEnvironment) {
            throw new ConfigurationException("Mismatched credential environments: clientId environment is: " + clientIdEnvironment.getEnvironmentName() + " and clientSecret environment is: " + clientSecretEnvironment.getEnvironmentName());
        }
        this.environment = clientIdEnvironment;
    }

    public CredentialsParser(String accessToken) {
        if (!accessToken.startsWith("access_token")) {
            throw new ConfigurationException("Value passed for accessToken is not a valid accessToken");
        }
        this.accessToken = accessToken;
        this.merchantId = this.parseMerchantId(accessToken);
        this.environment = this.parseEnvironment(accessToken);
    }

    private Environment parseEnvironment(String credential) {
        String environment = credential.split("\\$")[1];
        if (environment.equals("development") || environment.equals("integration")) {
            return Environment.DEVELOPMENT;
        }
        if (environment.equals("sandbox")) {
            return Environment.SANDBOX;
        }
        if (environment.equals("production")) {
            return Environment.PRODUCTION;
        }
        throw new IllegalArgumentException("Unknown environment: " + environment);
    }

    private String parseMerchantId(String accessToken) {
        return accessToken.split("\\$")[2];
    }
}

