/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Address;
import com.braintreegateway.ApplePayCard;
import com.braintreegateway.CoinbaseAccount;
import com.braintreegateway.CreditCard;
import com.braintreegateway.PayPalAccount;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Customer {
    private Calendar createdAt;
    private Calendar updatedAt;
    private String company;
    private String email;
    private String fax;
    private String firstName;
    private String id;
    private String lastName;
    private String phone;
    private String website;
    private Map<String, String> customFields;
    private List<CreditCard> creditCards;
    private List<PayPalAccount> paypalAccounts;
    private List<ApplePayCard> applePayCards;
    private List<CoinbaseAccount> coinbaseAccounts;
    private List<Address> addresses;

    public Customer(NodeWrapper node) {
        this.id = node.findString("id");
        this.firstName = node.findString("first-name");
        this.lastName = node.findString("last-name");
        this.company = node.findString("company");
        this.email = node.findString("email");
        this.fax = node.findString("fax");
        this.phone = node.findString("phone");
        this.website = node.findString("website");
        this.createdAt = node.findDateTime("created-at");
        this.updatedAt = node.findDateTime("updated-at");
        this.customFields = node.findMap("custom-fields/*");
        this.creditCards = new ArrayList<CreditCard>();
        for (NodeWrapper creditCardResponse : node.findAll("credit-cards/credit-card")) {
            this.creditCards.add(new CreditCard(creditCardResponse));
        }
        this.paypalAccounts = new ArrayList<PayPalAccount>();
        for (NodeWrapper paypalResponse : node.findAll("paypal-accounts/paypal-account")) {
            this.paypalAccounts.add(new PayPalAccount(paypalResponse));
        }
        this.applePayCards = new ArrayList<ApplePayCard>();
        for (NodeWrapper applePayCardResponse : node.findAll("apple-pay-cards/apple-pay-card")) {
            this.applePayCards.add(new ApplePayCard(applePayCardResponse));
        }
        this.coinbaseAccounts = new ArrayList<CoinbaseAccount>();
        for (NodeWrapper coinbaseAccountResponse : node.findAll("coinbase-accounts/coinbase-account")) {
            this.coinbaseAccounts.add(new CoinbaseAccount(coinbaseAccountResponse));
        }
        this.addresses = new ArrayList<Address>();
        for (NodeWrapper addressResponse : node.findAll("addresses/address")) {
            this.addresses.add(new Address(addressResponse));
        }
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    public String getId() {
        return this.id;
    }

    public String getCompany() {
        return this.company;
    }

    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFax() {
        return this.fax;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getWebsite() {
        return this.website;
    }

    public List<Address> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public List<CreditCard> getCreditCards() {
        return Collections.unmodifiableList(this.creditCards);
    }

    public List<PayPalAccount> getPayPalAccounts() {
        return Collections.unmodifiableList(this.paypalAccounts);
    }

    public List<CoinbaseAccount> getCoinbaseAccounts() {
        return Collections.unmodifiableList(this.coinbaseAccounts);
    }

    public List<ApplePayCard> getApplePayCards() {
        return Collections.unmodifiableList(this.applePayCards);
    }

    public List<? extends PaymentMethod> getPaymentMethods() {
        ArrayList<PaymentMethod> paymentMethods = new ArrayList<PaymentMethod>();
        paymentMethods.addAll(this.getCreditCards());
        paymentMethods.addAll(this.getPayPalAccounts());
        paymentMethods.addAll(this.getApplePayCards());
        return Collections.unmodifiableList(paymentMethods);
    }

    public PaymentMethod getDefaultPaymentMethod() {
        for (PaymentMethod paymentMethod : this.getPaymentMethods()) {
            if (!paymentMethod.isDefault()) continue;
            return paymentMethod;
        }
        return null;
    }
}

