/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;

public class MerchantAccount {
    private final String id;
    private final Status status;
    private final MerchantAccount masterMerchantAccount;

    public MerchantAccount(NodeWrapper node) {
        this.id = node.findString("id");
        this.status = EnumUtils.findByName(Status.class, node.findString("status"));
        NodeWrapper masterNode = node.findFirst("master-merchant-account");
        this.masterMerchantAccount = masterNode != null ? new MerchantAccount(masterNode) : null;
    }

    public String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    public MerchantAccount getMasterMerchantAccount() {
        return this.masterMerchantAccount;
    }

    public boolean isSubMerchant() {
        return this.masterMerchantAccount != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        PENDING,
        ACTIVE,
        SUSPENDED,
        UNRECOGNIZED;

    }
}

