/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Environment {
    DEVELOPMENT(Environment.developmentHost() + ":" + Environment.developmentPort(), Environment.developmentCertificates()),
    PRODUCTION("https://www.braintreegateway.com:443", new String[]{"ssl/www_braintreegateway_com.ca.der", "ssl/securetrust.ca.der"}),
    SANDBOX("https://sandbox.braintreegateway.com:443", new String[]{"ssl/sandbox-godaddy-root.ca.der", "ssl/sandbox_braintreegateway_com.ca.der", "ssl/sandbox-godaddy-intermediate.ca.der"});

    public final String baseURL;
    public final String[] certificateFilenames;

    private Environment(String baseURL, String[] certificateFilenames) {
        this.baseURL = baseURL;
        this.certificateFilenames = Arrays.copyOf(certificateFilenames, certificateFilenames.length);
    }

    private static String developmentPort() {
        if (System.getenv().get("GATEWAY_PORT") != null) {
            return System.getenv().get("GATEWAY_PORT");
        }
        if (System.getProperty("com.braintreegateway.port") != null) {
            return System.getProperty("com.braintreegateway.port");
        }
        return "3000";
    }

    private static String developmentHost() {
        return System.getProperty("com.braintreegateway.host") == null ? "http://localhost" : System.getProperty("com.braintreegateway.host");
    }

    private static String[] developmentCertificates() {
        if (System.getProperty("com.braintreegateway.certificates") == null) {
            return new String[0];
        }
        String certs = System.getProperty("com.braintreegateway.certificates");
        return certs.split(",");
    }
}

