/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.util;

import com.braintreegateway.Request;
import java.net.URLEncoder;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryString {
    private StringBuilder builder;

    public QueryString() {
        this.builder = new StringBuilder("");
    }

    public QueryString(String content) {
        this.builder = new StringBuilder(content);
    }

    public QueryString append(String key, Object value) {
        if (value == null) {
            return this;
        }
        if (value instanceof Request) {
            return this.appendRequest(key, (Request)value);
        }
        if (value instanceof Map) {
            return this.appendMap(key, (Map)value);
        }
        return this.appendString(key, value.toString());
    }

    public String toString() {
        return this.builder.toString();
    }

    protected String encodeParam(String key, String value) {
        String encodedKey = "";
        String encodedValue = "";
        try {
            encodedKey = URLEncoder.encode(key, "UTF-8");
            encodedValue = URLEncoder.encode(value, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return encodedKey + "=" + encodedValue;
    }

    protected QueryString appendString(String key, String value) {
        if (key != null && !key.equals("") && value != null) {
            if (this.builder.length() > 0) {
                this.builder.append("&");
            }
            this.builder.append(this.encodeParam(key, value));
        }
        return this;
    }

    protected QueryString appendRequest(String parent, Request request) {
        String requestQueryString;
        if (request != null && (requestQueryString = request.toQueryString(parent)).length() > 0) {
            if (this.builder.length() > 0) {
                this.builder.append("&");
            }
            this.builder.append(requestQueryString);
        }
        return this;
    }

    protected QueryString appendMap(String key, Map<?, ?> value) {
        for (Object keyString : value.keySet()) {
            this.appendString(String.format("%s[%s]", key, keyString), value.get(keyString).toString());
        }
        return this;
    }
}

