/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

class TLSSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory internalSSLSocketFactory;

    static TLSSocketFactory newInstance() throws SSLException {
        return new TLSSocketFactory();
    }

    TLSSocketFactory() throws SSLException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            this.internalSSLSocketFactory = sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new SSLException(e.getMessage());
        }
    }

    TLSSocketFactory(InputStream certificateStream) throws SSLException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certificates = cf.generateCertificates(certificateStream);
            for (Certificate certificate : certificates) {
                if (!(certificate instanceof X509Certificate)) continue;
                String subject = ((X509Certificate)certificate).getSubjectDN().getName();
                keyStore.setCertificateEntry(subject, certificate);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, tmf.getTrustManagers(), null);
            this.internalSSLSocketFactory = sSLContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new SSLException(e.getMessage());
        }
        finally {
            try {
                certificateStream.close();
            }
            catch (IOException | NullPointerException exception) {}
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.internalSSLSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.internalSSLSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.enableTLSOnSocket(this.internalSSLSocketFactory.createSocket(address, port, localAddress, localPort));
    }

    private Socket enableTLSOnSocket(Socket socket) {
        if (socket instanceof SSLSocket) {
            ArrayList<String> supportedProtocols = new ArrayList<String>(Arrays.asList(((SSLSocket)socket).getSupportedProtocols()));
            supportedProtocols.retainAll(Collections.singletonList("TLSv1.2"));
            ((SSLSocket)socket).setEnabledProtocols(supportedProtocols.toArray(new String[supportedProtocols.size()]));
        }
        return socket;
    }
}

